/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.util;

import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.InvalidSignedValueException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.gm.GMNamedCurves;
import org.bouncycastle162.asn1.x9.X9ECParameters;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.digests.SM3Digest;
import org.bouncycastle162.crypto.params.ECDomainParameters;
import org.bouncycastle162.crypto.params.ECPublicKeyParameters;
import org.bouncycastle162.crypto.params.ParametersWithID;
import org.bouncycastle162.crypto.signers.DSAEncoding;
import org.bouncycastle162.crypto.signers.PlainDSAEncoding;
import org.bouncycastle162.crypto.signers.SM2Signer;
import org.bouncycastle162.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle162.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.bouncycastle162.jce.spec.ECParameterSpec;
import org.bouncycastle162.jce.spec.ECPrivateKeySpec;
import org.bouncycastle162.jce.spec.ECPublicKeySpec;
import org.bouncycastle162.math.ec.ECPoint;
import org.bouncycastle162.util.encoders.Hex;

public class GmUtil {
    private static X9ECParameters x9ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static String defautSM2Id = "1234567812345678";
    private static final int RS_LEN = 32;

    public static byte[] signSm3WithSm2(byte[] msg, PrivateKey privateKey) {
        return GmUtil.rsAsn1ToPlainByteArray(GmUtil.signSm3WithSm2Asn1Rs(msg, privateKey));
    }

    public static byte[] signSm3WithSm2Asn1Rs(byte[] msg, PrivateKey privateKey) {
        try {
            Signature signer = Signature.getInstance("SM3withSM2", "BC162");
            signer.initSign(privateKey, new SecureRandom());
            signer.update(msg, 0, msg.length);
            return signer.sign();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySm3WithSm2(byte[] msg, byte[] rs, PublicKey publicKey) throws InvalidSignedValueException {
        return GmUtil.verifySm3WithSm2New(msg, rs, publicKey);
    }

    public static boolean verifySm3WithSm2Old(byte[] msg, byte[] rs, PublicKey publicKey) {
        byte[] data;
        if (rs == null || msg == null) {
            return false;
        }
        if (rs.length == 64) {
            data = GmUtil.rsPlainByteArrayToAsn1(rs);
        } else {
            byte[] rs1 = GmUtil.rsAsn1ToPlainByteArray(rs);
            data = GmUtil.rsPlainByteArrayToAsn1(rs1);
        }
        return GmUtil.verifySm3WithSm2Asn1Rs(msg, data, publicKey);
    }

    public static boolean verifySm3WithSm2New(byte[] originData, byte[] expSigVal, PublicKey publicKey) throws InvalidSignedValueException {
        ECPublicKeyParameters param = null;
        if (!(publicKey instanceof BCECPublicKey)) {
            throw new InvalidSignedValueException("\u516c\u94a5\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        BCECPublicKey localECPublicKey = (BCECPublicKey)publicKey;
        ECParameterSpec localECParameterSpec = localECPublicKey.getParameters();
        ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
        param = new ECPublicKeyParameters(localECPublicKey.getQ(), localECDomainParameters);
        ParametersWithID parametersWithID = new ParametersWithID((CipherParameters)param, defautSM2Id.getBytes());
        SM2Signer localSM2Signer = new SM2Signer((DSAEncoding)new PlainDSAEncoding());
        if (expSigVal.length != 64) {
            try {
                expSigVal = GmUtil.fixSignData(expSigVal);
            }
            catch (Exception e) {
                throw new InvalidSignedValueException("\u7b7e\u540d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", e);
            }
        }
        localSM2Signer.init(false, (CipherParameters)parametersWithID);
        localSM2Signer.update(originData, 0, originData.length);
        return localSM2Signer.verifySignature(expSigVal);
    }

    private static byte[] fixSignData(byte[] expSigVal) {
        org.bouncycastle149.asn1.ASN1Sequence signedData = org.bouncycastle149.asn1.ASN1Sequence.getInstance((Object)expSigVal);
        org.bouncycastle149.asn1.ASN1Integer rInt = (org.bouncycastle149.asn1.ASN1Integer)signedData.getObjectAt(0);
        org.bouncycastle149.asn1.ASN1Integer sInt = (org.bouncycastle149.asn1.ASN1Integer)signedData.getObjectAt(1);
        BigInteger r = rInt.getPositiveValue();
        BigInteger s = sInt.getPositiveValue();
        byte[] rByte = GmUtil.toByteArray32(r);
        byte[] sByte = GmUtil.toByteArray32(s);
        byte[] rsBytes = new byte[64];
        System.arraycopy(rByte, 0, rsBytes, 0, 32);
        System.arraycopy(sByte, 0, rsBytes, 32, 32);
        return rsBytes;
    }

    private static byte[] toByteArray32(BigInteger r) {
        byte[] rsBytes = new byte[32];
        byte[] originByte = r.toByteArray();
        int rLen = originByte.length;
        if (rLen == 32) {
            return originByte;
        }
        if (rLen < 32) {
            System.arraycopy(originByte, 0, rsBytes, 32 - rLen, rLen);
        } else {
            System.arraycopy(originByte, rLen - 32, rsBytes, 0, 32);
        }
        return rsBytes;
    }

    private static boolean verifySm3WithSm2Asn1Rs(byte[] msg, byte[] rs, PublicKey publicKey) {
        try {
            Signature verifier = Signature.getInstance("SM3withSM2", "BC162");
            verifier.initVerify(publicKey);
            verifier.update(msg, 0, msg.length);
            return verifier.verify(rs);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] sm3(byte[] bytes) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(bytes, 0, bytes.length);
        byte[] result = new byte[sm3.getDigestSize()];
        sm3.doFinal(result, 0);
        return result;
    }

    private static byte[] bigIntToFixLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return GmUtil.copyOfRange(rs, 1, 33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])rs));
    }

    private static byte[] rsAsn1ToPlainByteArray(byte[] rsDer) {
        org.bouncycastle149.asn1.ASN1Sequence seq = org.bouncycastle149.asn1.ASN1Sequence.getInstance((Object)rsDer);
        org.bouncycastle149.asn1.ASN1Integer rInt = (org.bouncycastle149.asn1.ASN1Integer)seq.getObjectAt(0);
        org.bouncycastle149.asn1.ASN1Integer sInt = (org.bouncycastle149.asn1.ASN1Integer)seq.getObjectAt(1);
        BigInteger r0 = rInt.getPositiveValue();
        BigInteger s0 = sInt.getPositiveValue();
        byte[] r = GmUtil.bigIntToFixLengthBytes(r0);
        byte[] s = GmUtil.bigIntToFixLengthBytes(s0);
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    private static byte[] rsPlainByteArrayToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new RuntimeException("\u975e\u6cd5\u7b7e\u540d\u6570\u636e");
        }
        BigInteger r = new BigInteger(1, GmUtil.copyOfRange(sign, 0, 32));
        BigInteger s = new BigInteger(1, GmUtil.copyOfRange(sign, 32, 64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException("\u7b7e\u540d\u53cd\u5e8f\u5217\u5316\u5931\u8d25", e);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("EC", "BC162");
            kpGen.initialize((AlgorithmParameterSpec)ecParameterSpec, new SecureRandom());
            return kpGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BCECPrivateKey getPrivateKeyFromD(BigInteger d) {
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, ecParameterSpec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static BCECPublicKey getPublicKeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), ecParameterSpec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static BCECPublicKey getPublicKeyFromPrivateKey(BCECPrivateKey privateKey) {
        ECPoint p = x9ECParameters.getG().multiply(privateKey.getD()).normalize();
        return GmUtil.getPublicKeyFromXY(p.getXCoord().toBigInteger(), p.getYCoord().toBigInteger());
    }

    public static PublicKey getPublicKeyFromX509File(InputStream in) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC162");
            X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
            return x509.getPublicKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey getPublicKeyFromX509File(File file) {
        PublicKey publicKey;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            publicKey = GmUtil.getPublicKeyFromX509File(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                GmUtil.close(inputStream);
                throw throwable;
            }
        }
        GmUtil.close(inputStream);
        return publicKey;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String bigIntegerToHex(BigInteger data) {
        return Hex.toHexString((byte[])GmUtil.bigIntToFixLengthBytes(data)).toUpperCase();
    }

    public static void printResult(byte[] msg, byte[] sig, PublicKey publicKey) {
        System.out.println("=============================");
        System.out.println("verify url: https://const.net.cn/tool/sm2/verify/");
        System.out.println("msg:" + Hex.toHexString((byte[])msg).toUpperCase());
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)sig);
        System.out.println("PUBLIC:" + GmUtil.bigIntegerToHex(((BCECPublicKey)publicKey).getW().getAffineX()) + GmUtil.bigIntegerToHex(((BCECPublicKey)publicKey).getW().getAffineY()));
        System.out.println("R:" + GmUtil.bigIntegerToHex(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue()));
        System.out.println("S:" + GmUtil.bigIntegerToHex(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue()));
        System.out.println("User ID:" + Hex.toHexString((byte[])"1234567812345678".getBytes()));
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

