/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.util;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static Map<String, byte[]> unzipFile(byte[] zipData) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        InputStream in = null;
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new ByteArrayInputStream(zipData));
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                IOUtil.copy(zin, byteOutput);
                byte[] b = byteOutput.toByteArray();
                map.put(ZipUtil.parseSuffix(entryName), b);
                byteOutput.flush();
                IOUtil.close(byteOutput);
            }
            HashMap<String, byte[]> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u89e3\u538b\u5931\u8d25\u3002", e);
        }
        finally {
            try {
                if (zin != null) {
                    zin.closeEntry();
                    zin.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String parseSuffix(String fileName) {
        int idx = fileName.lastIndexOf(46);
        return fileName.substring(idx).toLowerCase();
    }

    public static void main(String[] args) {
        try {
            byte[] zipData = IOUtil.readFile("D:/data/sm2/test03/inv_ord_issuer_20220318_03300210061651919106.zip");
            Map<String, byte[]> map = ZipUtil.unzipFile(zipData);
            System.out.println(map.keySet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

