/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore;

import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreException;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreUtils;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.ICertificateStore;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.PrincipalUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateStoreMemory
implements ICertificateStore {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateStoreMemory.class);
    private static final String storeFile = "com/ygsoft/abc/mapp/ygca/test/cert/keystore1.bks";
    private KeyStore keyStore;

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public CertificateStoreMemory() {
        InputStream keyStoreInputStream = null;
        try {
            keyStoreInputStream = this.getBKSStoreFile();
            this.keyStore = this.loadKeyStore(keyStoreInputStream, "123456");
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u8bfb\u53d6\u8bc1\u4e66\u5b58\u50a8\u6587\u4ef6\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                CertificateStoreUtils.close(keyStoreInputStream);
                throw throwable;
            }
        }
        CertificateStoreUtils.close(keyStoreInputStream);
    }

    public CertificateStoreMemory(InputStream keyStoreInputStream, String storePass) {
        this.keyStore = this.loadKeyStore(keyStoreInputStream, storePass);
    }

    public InputStream getBKSStoreFile() {
        return CertificateStoreMemory.class.getClassLoader().getResourceAsStream(storeFile);
    }

    public synchronized KeyStore loadKeyStore(InputStream keyStoreInputStream, String storePass) {
        KeyStore ks = null;
        Object in = null;
        try {
            ks = KeyStore.getInstance("BKS", (Provider)new BouncyCastleProvider());
            ks.load(keyStoreInputStream, storePass.toCharArray());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u52a0\u8f7d\u8bc1\u4e66\u5b58\u50a8\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                CertificateStoreUtils.close(in);
                throw throwable;
            }
        }
        CertificateStoreUtils.close(in);
        return ks;
    }

    protected String createAliasByCert(Certificate certificate) {
        try {
            return CertificateStoreUtils.MD5(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("\u8bc1\u4e66\u683c\u5f0f\u4e0d\u6b63\u786e", e);
        }
    }

    @Override
    public void add(Certificate certificate) throws IOException {
        try {
            String alias = this.createAliasByCert(certificate);
            this.keyStore.setCertificateEntry(alias, certificate);
        }
        catch (Exception e) {
            throw new IOException("\u6dfb\u52a0\u8bc1\u4e66\u5931\u8d25", e);
        }
    }

    private void verify(List<Certificate> targetCertificates) throws CertificateStoreException {
        try {
            PKIXParameters params = new PKIXParameters(this.keyStore);
            params.setRevocationEnabled(false);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            CertPath certPath = certificateFactory.generateCertPath(targetCertificates);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
            certPathValidator.validate(certPath, params);
        }
        catch (Exception e) {
            throw new CertificateStoreException("\u8bc1\u4e66\u4fe1\u4efb\u94fe\u9a8c\u8bc1\u4e0d\u901a\u8fc7", e);
        }
    }

    @Override
    public void verify(Certificate targetCertificate) throws CertificateStoreException {
        this.verify2(targetCertificate);
    }

    private void validate3(X509Certificate targetCertificate) throws CertificateStoreException {
        List<X509Certificate> certList = Collections.singletonList(targetCertificate);
        KeyStore truststore = this.keyStore;
        List _crls = null;
        boolean _enableOCSP = false;
        boolean _enableCRLDP = false;
        try {
            X509CertSelector certSelect = new X509CertSelector();
            certSelect.setCertificate(certList.get(0));
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(truststore, (CertSelector)certSelect);
            pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList)));
            pbParams.setMaxPathLength(-1);
            pbParams.setRevocationEnabled(false);
            if (_crls != null && !_crls.isEmpty()) {
                pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(_crls)));
            }
            if (_enableOCSP) {
                Security.setProperty("ocsp.enable", "true");
            }
            if (_enableCRLDP) {
                System.setProperty("com.sun.security.enableCRLDP", "true");
            }
            BouncyCastleProvider provider = new BouncyCastleProvider();
            CertPathBuilderResult buildResult = CertPathBuilder.getInstance("PKIX", (Provider)provider).build(pbParams);
            CertPathValidator.getInstance("PKIX", (Provider)provider).validate(buildResult.getCertPath(), pbParams);
        }
        catch (GeneralSecurityException e) {
            throw new CertificateStoreException("\u8bc1\u4e66\u4fe1\u4efb\u94fe\u9a8c\u8bc1\u4e0d\u901a\u8fc7", e);
        }
    }

    @Override
    public int remove(Certificate certificate) {
        try {
            Enumeration<String> e = this.keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate item = this.keyStore.getCertificate(alias);
                if (!item.equals(certificate)) continue;
                this.keyStore.deleteEntry(alias);
                return 1;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5220\u9664\u8bc1\u4e66\u51fa\u9519", e);
        }
        return 0;
    }

    @Override
    public List<Certificate> list() {
        ArrayList<Certificate> data = new ArrayList<Certificate>();
        try {
            Enumeration<String> enumeration = this.keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                Certificate c = this.keyStore.getCertificate(key);
                data.add(c);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u5931\u8d25", e);
        }
        return data;
    }

    public void verify2(Certificate certificate) throws CertificateStoreException {
        boolean exists = false;
        boolean success = false;
        X509Certificate target = (X509Certificate)certificate;
        X500Name targetSubjectDN = PrincipalUtils.getSubjectPrincipal(target);
        X500Name targetIssuerDN = PrincipalUtils.getEncodedIssuerPrincipal(target);
        try {
            Enumeration<String> enumeration = this.keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                X509Certificate item = (X509Certificate)this.keyStore.getCertificate(alias);
                X500Name itemSubjectDN = PrincipalUtils.getSubjectPrincipal(item);
                if (!targetIssuerDN.equals((Object)itemSubjectDN) || !target.getSigAlgOID().equals(item.getSigAlgOID())) continue;
                exists = true;
                PublicKey pbk = item.getPublicKey();
                try {
                    target.verify(pbk);
                    success = true;
                    LOG.info(String.format("\u8bc1\u4e66%s\u7684\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u901a\u8fc7", targetSubjectDN.toString()));
                }
                catch (Exception e) {
                    LOG.warn(String.format("\u8bc1\u4e66%s\u7684\u4fe1\u4efb\u94fe\u9a8c\u8bc1\u5931\u8d25", targetSubjectDN.toString()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new CertificateStoreException("\u8bc1\u4e66\u4fe1\u4efb\u94fe\u9a8c\u8bc1\u51fa\u9519", e);
        }
        if (!exists) {
            LOG.warn(String.format("\u8bc1\u4e66[%s]\u7684\u9881\u53d1\u8bc1\u4e66\u673a\u6784[%s]\u4e0d\u5b58\u5728", targetSubjectDN.toString(), targetIssuerDN.toString()));
            throw new CertificateStoreException("\u8bc1\u4e66\u4fe1\u4efb\u94fe\u4e0d\u5b58\u5728");
        }
        if (!success) {
            throw new CertificateStoreException("\u8bc1\u4e66\u4fe1\u4efb\u94fe\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

