/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd;

import com.ygsoft.abc.mapp.ygca.gwcw.common.config.ConfigTool;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignInfoVO;
import com.ygsoft.abc.mapp.ygca.gwcw.util.X509CertVOUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.GBT35275ValidateContainerExt;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateAbstractContainer;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.SESV4ValidateContainerExt;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert.CertTools;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.ContentInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignedData;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignerInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.InvalidSignedValueException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1GeneralizedTime;
import org.bouncycastle162.asn1.ASN1OctetString;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1UTCTime;
import org.bouncycastle162.asn1.DERBitString;
import org.bouncycastle162.asn1.DLSequence;
import org.bouncycastle162.asn1.x509.Certificate;
import org.bouncycastle162.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDValidateProxyContainer
extends OFDValidateAbstractContainer {
    private static final Logger LOG = LoggerFactory.getLogger(OFDValidateProxyContainer.class);

    @Override
    public void validate(SigType sigType, String signAlgName, byte[] tbsContent, byte[] signedValue) throws InvalidSignedValueException, IOException, GeneralSecurityException {
        if (sigType == SigType.Sign) {
            this.validateSign(sigType, signAlgName, tbsContent, signedValue);
        } else if (sigType == SigType.Seal) {
            this.validateSeal(sigType, signAlgName, tbsContent, signedValue);
        }
    }

    protected void validateSign(SigType sigType, String signAlgName, byte[] tbsContent, byte[] signedValue) throws InvalidSignedValueException, IOException, GeneralSecurityException {
        SignInfoVO signInfoVO = OFDValidateProxyContainer.getSinInfoBySignData(signedValue);
        if (signInfoVO == null) {
            throw new InvalidSignedValueException("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25");
        }
        this.getSignInfoS().add(signInfoVO);
        LOG.info(String.format("verifyOfd sign start by: %s, with cert: %s", GBT35275ValidateContainerExt.class.getSimpleName(), signInfoVO));
        new GBT35275ValidateContainerExt().validate(sigType, signAlgName, tbsContent, signedValue);
    }

    protected void validateSeal(SigType sigType, String signAlgName, byte[] tbsContent, byte[] signedValue) throws InvalidSignedValueException, IOException, GeneralSecurityException {
        String subject;
        SignInfoVO signInfoVO = OFDValidateProxyContainer.getSinInfoBySealData(signedValue);
        if (signInfoVO == null) {
            throw new InvalidSignedValueException("\u83b7\u53d6\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25");
        }
        this.getSignInfoS().add(signInfoVO);
        LOG.info(String.format("verifyOfd seal start by: %s with cert: %s", SESV4ValidateContainerExt.class.getSimpleName(), signInfoVO));
        if (ConfigTool.checkSubject() && ((subject = signInfoVO.getCertInfo().getSubject()).contains("\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8") || subject.contains("\u4e2d\u56fd\u5149\u5927\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8") || subject.contains("\u4e2d\u56fd\u7535\u529b\u8d22\u52a1\u6709\u9650\u516c\u53f8"))) {
            throw new InvalidSignedValueException("\u672c\u5730\u9a8c\u7b7e\u4e0d\u652f\u6301\u8be5\u5f00\u5177\u5355\u4f4d");
        }
        new SESV4ValidateContainerExt().validate(sigType, signAlgName, tbsContent, signedValue);
    }

    protected static SignInfoVO getSinInfoBySignData(byte[] signedValueData) throws InvalidSignedValueException {
        SignInfoVO targetSinInfo = null;
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(signedValueData);
            SignedData signedData = SignedData.getInstance(contentInfo.getContent());
            Iterator iterator = signedData.getSignerInfos().iterator();
            if (iterator.hasNext()) {
                ASN1Encodable item = (ASN1Encodable)iterator.next();
                SignerInfo signerInfo = SignerInfo.getInstance(item);
                IssuerAndSerialNumber iaSn = signerInfo.getIssuerAngSerialNumber();
                Certificate c = signedData.getSignCert(iaSn);
                java.security.cert.Certificate cert = CertTools.toJavaCert(c);
                targetSinInfo = new SignInfoVO(X509CertVOUtil.convert(cert), null);
            }
        }
        catch (Exception e) {
            throw new InvalidSignedValueException("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", e);
        }
        return targetSinInfo;
    }

    protected static SignInfoVO getSinInfoBySealData(byte[] signedValueData) throws InvalidSignedValueException {
        SignInfoVO targetSinInfo;
        block7: {
            targetSinInfo = null;
            try {
                ASN1Sequence root = ASN1Sequence.getInstance((Object)signedValueData);
                if (root != null && root.size() >= 4) {
                    DLSequence tbsSign = (DLSequence)root.getObjectAt(0);
                    ASN1OctetString cert = (ASN1OctetString)root.getObjectAt(1);
                    byte[] certDER = cert.getOctets();
                    java.security.cert.Certificate signCert = new CertificateFactory().engineGenerateCertificate((InputStream)new ByteArrayInputStream(certDER));
                    Date signTime = null;
                    try {
                        ASN1GeneralizedTime time = (ASN1GeneralizedTime)tbsSign.getObjectAt(2);
                        signTime = time.getDate();
                    }
                    catch (Exception e) {
                        LOG.warn("\u83b7\u53d6\u7b7e\u7ae0\u65f6\u95f4\u5931\u8d25", (Throwable)e);
                    }
                    targetSinInfo = new SignInfoVO(X509CertVOUtil.convert(signCert), signTime);
                    break block7;
                }
                if (root == null || root.size() != 2) break block7;
                DLSequence tbsSign = (DLSequence)root.getObjectAt(0);
                ASN1OctetString cert = (ASN1OctetString)tbsSign.getObjectAt(5);
                byte[] certDER = cert.getOctets();
                java.security.cert.Certificate signCert = new CertificateFactory().engineGenerateCertificate((InputStream)new ByteArrayInputStream(certDER));
                Date signTime = null;
                String signVersion = null;
                try {
                    DERBitString time = (DERBitString)tbsSign.getObjectAt(2);
                    String tt = new String(time.getBytes());
                    ASN1UTCTime utc = new ASN1UTCTime(tt);
                    signTime = utc.getDate();
                    signVersion = String.valueOf(tbsSign.getObjectAt(0));
                }
                catch (Exception e) {
                    LOG.warn("\u83b7\u53d6\u7b7e\u7ae0\u65f6\u95f4\u5931\u8d25", (Throwable)e);
                }
                targetSinInfo = new SignInfoVO(X509CertVOUtil.convert(signCert), signTime, signVersion);
            }
            catch (Exception e) {
                throw new InvalidSignedValueException("\u83b7\u53d6\u7b7e\u7ae0\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", e);
            }
        }
        return targetSinInfo;
    }
}

