/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd;

import com.ygsoft.abc.mapp.ygca.gwcw.common.config.ConfigTool;
import com.ygsoft.abc.mapp.ygca.gwcw.util.GmUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreException;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreFactory;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.SignedDataValidateContainer;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.InvalidSignedValueException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Arrays;
import org.bouncycastle162.asn1.ASN1BitString;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1OctetString;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1String;
import org.bouncycastle162.asn1.DLSequence;
import org.bouncycastle162.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle162.jcajce.provider.digest.SHA1;
import org.bouncycastle162.jcajce.provider.digest.SM3;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SESV4ValidateContainerExt
implements SignedDataValidateContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SESV4ValidateContainerExt.class);
    private static String sm3withsm2 = "1.2.156.10197.1.501";
    private static String rsasha1 = "1.2.840.113549.1.1.5";

    @Override
    public void validate(SigType type, String signAlgName, byte[] tbsContent, byte[] signedValue) throws InvalidSignedValueException, IOException, GeneralSecurityException {
        SM3.Digest md;
        if (type == SigType.Sign) {
            throw new InvalidSignedValueException("\u7b7e\u540d\u7c7b\u578b(type)\u5fc5\u987b\u662f Seal,\u4e0d\u652f\u6301\u7535\u5b50\u5370\u7ae0\u9a8c\u8bc1");
        }
        ASN1Sequence root = ASN1Sequence.getInstance((Object)signedValue);
        DLSequence tbsSign = (DLSequence)root.getObjectAt(0);
        ASN1OctetString cert = (ASN1OctetString)root.getObjectAt(1);
        ASN1ObjectIdentifier signatureAlgID = (ASN1ObjectIdentifier)root.getObjectAt(2);
        if (sm3withsm2.equals(signatureAlgID.getId())) {
            md = new SM3.Digest();
        } else if (rsasha1.equals(signatureAlgID.getId())) {
            md = new SHA1.Digest();
        } else {
            throw new InvalidSignedValueException("Signature.dat \u7b7e\u540d\u7b97\u6cd5\u9519\u8bef");
        }
        ASN1BitString signature = (ASN1BitString)root.getObjectAt(3);
        ASN1BitString dataHash = (ASN1BitString)tbsSign.getObjectAt(3);
        ASN1String propertyInfo = (ASN1String)tbsSign.getObjectAt(4);
        byte[] expectDataHash = dataHash.getBytes();
        byte[] actualDataHash = md.digest(tbsContent);
        if (!Arrays.equals(actualDataHash, expectDataHash)) {
            throw new InvalidSignedValueException("Signature.xml \u6587\u4ef6\u88ab\u7be1\u6539\uff0c\u7535\u5b50\u7b7e\u7ae0\u5931\u6548\u3002(" + propertyInfo.getString() + ")");
        }
        byte[] expSigVal = signature.getBytes();
        byte[] certDER = cert.getOctets();
        Certificate signCert = new CertificateFactory().engineGenerateCertificate((InputStream)new ByteArrayInputStream(certDER));
        PublicKey publicKey = signCert.getPublicKey();
        if (sm3withsm2.equals(signatureAlgID.getId())) {
            boolean result = GmUtil.verifySm3WithSm2(tbsSign.getEncoded(), expSigVal, publicKey);
            if (!result) {
                throw new InvalidSignedValueException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u7b7e\u540d\u503c\u4e0d\u5339\u914d\u3002");
            }
        } else if (rsasha1.equals(signatureAlgID.getId())) {
            Signature sg = Signature.getInstance(signAlgName, (Provider)new BouncyCastleProvider());
            sg.initVerify(publicKey);
            sg.update(tbsSign.getEncoded());
            if (!sg.verify(expSigVal)) {
                throw new InvalidSignedValueException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u7b7e\u540d\u503c\u4e0d\u5339\u914d\u3002");
            }
        }
        if (ConfigTool.checkCert()) {
            try {
                CertificateStoreFactory.getInstance().verify(signCert);
            }
            catch (CertificateStoreException e) {
                throw new InvalidSignedValueException("\u8bc1\u4e66\u6709\u6548\u6027\u9a8c\u8bc1\u4e0d\u901a\u8fc7", e);
            }
        }
    }
}

