/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType;

import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.STBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ST_Array
extends STBase
implements Cloneable {
    private static final long serialVersionUID = -7070787076052245580L;
    private List<String> array = new ArrayList<String>();

    public static ST_Array unitCTM() {
        return new ST_Array(new Serializable[]{"1", "0", "0", "1", "0", "0"});
    }

    public ST_Array mtxMul(ST_Array array) {
        if (this.array.size() != 6 || array.size() != 6) {
            throw new IllegalArgumentException("\u77e9\u9635\u4e58\u6cd5\u6570\u7ec4\u89c4\u6a21\u5fc5\u987b 6\u5143\u7d20(a b c d e f)");
        }
        double[][] a = this.toMtx();
        double[][] b = array.toMtx();
        double[][] res = new double[3][3];
        for (int k = 0; k < 3; ++k) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double[] dArray = res[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * b[k][j];
                }
            }
        }
        return new ST_Array(new Serializable[]{ST_Array.fmt(res[0][0]), ST_Array.fmt(res[0][1]), ST_Array.fmt(res[1][0]), ST_Array.fmt(res[1][1]), ST_Array.fmt(res[2][0]), ST_Array.fmt(res[2][1])});
    }

    public static ST_Array getInstance(String arrStr) {
        if (arrStr == null || arrStr.trim().length() == 0) {
            return null;
        }
        return new ST_Array((Serializable[])arrStr.trim().split("\\s+"));
    }

    /*
     * WARNING - void declaration
     */
    public ST_Array(Serializable ... arr) {
        if (arr == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.array = new ArrayList<String>(arr.length);
        for (Serializable serializable : arr) {
            void var5_5;
            if (serializable instanceof String || serializable == null) {
                String str = (String)((Object)serializable);
                if (serializable == null || str.trim().length() == 0) continue;
                String string = str;
            } else if (serializable instanceof Double) {
                String string = STBase.fmt((Double)serializable);
            } else if (serializable instanceof Number) {
                String string = serializable.toString();
            }
            this.array.add(var5_5.toString());
        }
    }

    public ST_Array add(String item) {
        this.array.add(item);
        return this;
    }

    public List<String> getArray() {
        return this.array;
    }

    public String[] expectStrArr(int expectCount) {
        String[] res = new String[expectCount];
        for (int i = 0; i < expectCount; ++i) {
            res[i] = i < this.array.size() ? this.array.get(i) : "";
        }
        return res;
    }

    public Double[] toDouble() {
        ArrayList<Double> result = new ArrayList<Double>();
        for (String str : this.array) {
            result.add(STBase.toDouble(str));
        }
        return result.toArray(new Double[0]);
    }

    public Integer[] toInt() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String str : this.array) {
            result.add(STBase.toInt(str));
        }
        return result.toArray(new Integer[0]);
    }

    public ST_Array setArray(List<String> array) {
        this.array = array;
        return this;
    }

    public int size() {
        return this.array.size();
    }

    public double[][] toMtx() {
        if (this.size() != 6) {
            throw new IllegalArgumentException("\u77e9\u9635\u6570\u7ec4\u5fc5\u987b\u6709 9\u4e2a\u5143\u7d20");
        }
        double[][] mtx = new double[3][3];
        mtx[0][0] = Double.parseDouble(this.array.get(0));
        mtx[0][1] = Double.parseDouble(this.array.get(1));
        mtx[0][2] = 0.0;
        mtx[1][0] = Double.parseDouble(this.array.get(2));
        mtx[1][1] = Double.parseDouble(this.array.get(3));
        mtx[1][2] = 0.0;
        mtx[2][0] = Double.parseDouble(this.array.get(4));
        mtx[2][1] = Double.parseDouble(this.array.get(5));
        mtx[2][2] = 1.0;
        return mtx;
    }

    public void printMtx() {
        double[][] m = this.toMtx();
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                System.out.print(ST_Array.fmt(m[i][j]) + "\t");
            }
            System.out.println();
        }
    }

    public Double get(int index) {
        String s = this.array.get(index);
        return Double.parseDouble(s);
    }

    public Integer getInt(int index) {
        String s = this.array.get(index);
        if (s.startsWith("#")) {
            return Integer.parseInt(s.substring(1), 16);
        }
        return Integer.parseInt(s);
    }

    public int[] expectIntArr(int len) {
        int[] res = new int[len];
        for (int i = 0; i < len && i < this.array.size(); ++i) {
            try {
                res[i] = this.getInt(i);
                continue;
            }
            catch (Exception e) {
                res[i] = 0;
            }
        }
        return res;
    }

    public double[] expectArr(int len) {
        double[] res = new double[len];
        for (int i = 0; i < len && i < this.array.size(); ++i) {
            try {
                res[i] = this.get(i);
                continue;
            }
            catch (NumberFormatException e) {
                res[i] = 0.0;
            }
        }
        return res;
    }

    public ST_Array clone() {
        ST_Array res = new ST_Array(new Serializable[0]);
        for (String item : this.array) {
            res.add(item);
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String item : this.array) {
            sb.append(' ').append(item);
        }
        return sb.toString().trim();
    }
}

