/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.pathObj;

import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.STBase;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.tight.method.Arc;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.tight.method.Close;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.tight.method.Command;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.tight.method.CubicBezier;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.tight.method.Line;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.tight.method.Move;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.graph.tight.method.QuadraticBezier;
import java.util.List;

public class OptVal
implements Cloneable {
    public String opt;
    public double[] values = new double[0];

    public OptVal(String opt) {
        this.opt = opt;
    }

    public OptVal(String opt, double[] values) {
        this.opt = opt;
        if (values != null) {
            this.values = values;
        }
    }

    public OptVal(String opt, List<String> valueStrList) {
        this.opt = opt;
        if (valueStrList != null) {
            this.values = new double[valueStrList.size()];
            for (int i = 0; i < valueStrList.size(); ++i) {
                try {
                    this.values[i] = Double.parseDouble(valueStrList.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.values[i] = 0.0;
                }
            }
        }
    }

    public String getOpt() {
        return this.opt;
    }

    public void setOpt(String opt) {
        this.opt = opt;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public static double[] filling(double[] arr, int num) {
        if (arr == null) {
            arr = new double[num];
        }
        if (arr.length < num) {
            return OptVal.copyOf(arr, num);
        }
        return arr;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public Command toCmd() {
        if (StringUtil.equals(this.opt, "S") || StringUtil.equals(this.opt, "M")) {
            double[] arr = OptVal.filling(this.values, 2);
            return new Move(arr[0], arr[1]);
        }
        if (StringUtil.equals(this.opt, "L")) {
            double[] arr = OptVal.filling(this.values, 2);
            return new Line(arr[0], arr[1]);
        }
        if (StringUtil.equals(this.opt, "Q")) {
            double[] arr = OptVal.filling(this.values, 4);
            return new QuadraticBezier(arr[0], arr[1], arr[2], arr[3]);
        }
        if (StringUtil.equals(this.opt, "B")) {
            double[] arr = OptVal.filling(this.values, 6);
            return new CubicBezier(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
        }
        if (StringUtil.equals(this.opt, "A")) {
            double[] arr = OptVal.filling(this.values, 7);
            return new Arc(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6]);
        }
        if (StringUtil.equals(this.opt, "C")) {
            return new Close();
        }
        return null;
    }

    public double[] expectValues() {
        if (StringUtil.equals(this.opt, "S") || StringUtil.equals(this.opt, "M") || StringUtil.equals(this.opt, "L")) {
            return OptVal.filling(this.values, 2);
        }
        if (StringUtil.equals(this.opt, "Q")) {
            return OptVal.filling(this.values, 4);
        }
        if (StringUtil.equals(this.opt, "B")) {
            return OptVal.filling(this.values, 6);
        }
        if (StringUtil.equals(this.opt, "A")) {
            return OptVal.filling(this.values, 7);
        }
        if (StringUtil.equals(this.opt, "C")) {
            return new double[0];
        }
        return new double[0];
    }

    public OptVal clone() {
        return new OptVal(this.opt, (double[])this.values.clone());
    }

    public String toString() {
        if (StringUtil.equals(this.opt, "S") || StringUtil.equals(this.opt, "M") || StringUtil.equals(this.opt, "L")) {
            double[] arr = OptVal.filling(this.values, 2);
            return String.format("%s %s %s", this.opt, STBase.fmt(arr[0]), STBase.fmt(arr[1]));
        }
        if (StringUtil.equals(this.opt, "Q")) {
            double[] arr = OptVal.filling(this.values, 4);
            return String.format("Q %s %s %s %s", STBase.fmt(arr[0]), STBase.fmt(arr[1]), STBase.fmt(arr[2]), STBase.fmt(arr[3]));
        }
        if (StringUtil.equals(this.opt, "B")) {
            double[] arr = OptVal.filling(this.values, 6);
            return String.format("B %s %s %s %s %s %s", STBase.fmt(arr[0]), STBase.fmt(arr[1]), STBase.fmt(arr[2]), STBase.fmt(arr[3]), STBase.fmt(arr[4]), STBase.fmt(arr[5]));
        }
        if (StringUtil.equals(this.opt, "A")) {
            double[] arr = OptVal.filling(this.values, 7);
            return String.format("A %s %s %s %s %s %s %s", STBase.fmt(arr[0]), STBase.fmt(arr[1]), STBase.fmt(arr[2]), STBase.fmt(arr[3]), STBase.fmt(arr[4]), STBase.fmt(arr[5]), STBase.fmt(arr[6]));
        }
        if (StringUtil.equals(this.opt, "C")) {
            return "C";
        }
        return "";
    }
}

