/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse;

import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.SESVersion;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.SES_Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.SESeal;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1Sequence;

public class SESVersionHolder {
    private SESVersion version;
    private ASN1Sequence objSeq;

    public SESVersionHolder(SESVersion version, ASN1Sequence objSeq) {
        this.version = version;
        this.objSeq = objSeq;
    }

    public SESVersion getVersion() {
        return this.version;
    }

    public ASN1Sequence getObjSeq() {
        return this.objSeq;
    }

    public <T extends ASN1Object> T SESObject() {
        ASN1Object obj = null;
        switch (this.version) {
            case v1: {
                if (this.objSeq.size() != 2) break;
                obj = new SES_Signature(this.objSeq);
                break;
            }
            case v4: {
                if (this.objSeq.size() < 4) break;
                obj = new com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature(this.objSeq);
            }
        }
        return (T)obj;
    }

    public <T extends ASN1Object> T SealObject() {
        ASN1Object obj = null;
        switch (this.version) {
            case v1: {
                if (this.objSeq.size() != 2) break;
                obj = new SESeal(this.objSeq);
                break;
            }
            case v4: {
                if (this.objSeq.size() != 4) break;
                obj = new com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SESeal(this.objSeq);
            }
        }
        return (T)obj;
    }

    public SES_Signature getInstanceV1() {
        return (SES_Signature)((Object)this.SESObject());
    }

    public com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature getInstanceV4() {
        return (com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature)((Object)this.SESObject());
    }
}

