/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1;

import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.TBS_Sign;
import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle162.asn1.ASN1BitString;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.DERBitString;
import org.bouncycastle162.asn1.DERSequence;

public class SES_Signature
extends ASN1Object {
    private TBS_Sign toSign;
    private ASN1BitString signature;

    public SES_Signature() {
    }

    public SES_Signature(TBS_Sign toSign, ASN1BitString signature) {
        this.toSign = toSign;
        this.signature = signature;
    }

    public SES_Signature(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.toSign = TBS_Sign.getInstance(e.nextElement());
        this.signature = DERBitString.getInstance(e.nextElement());
    }

    public static SES_Signature getInstance(Object o) {
        if (o instanceof SES_Signature) {
            return (SES_Signature)((Object)o);
        }
        if (o instanceof byte[]) {
            ASN1InputStream aIn = new ASN1InputStream((byte[])o);
            try {
                ASN1Primitive obj = aIn.readObject();
                return new SES_Signature(ASN1Sequence.getInstance((Object)obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e \u683c\u5f0f\u9519\u8bef", e);
            }
        }
        if (o != null) {
            return new SES_Signature(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public TBS_Sign getToSign() {
        return this.toSign;
    }

    public SES_Signature setToSign(TBS_Sign toSign) {
        this.toSign = toSign;
        return this;
    }

    public ASN1BitString getSignature() {
        return this.signature;
    }

    public SES_Signature setSignature(ASN1BitString signature) {
        this.signature = signature;
        return this;
    }

    public SES_Signature setSignature(byte[] signature) {
        this.signature = new DERBitString(signature);
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.toSign);
        v.add((ASN1Encodable)this.signature);
        return new DERSequence(v);
    }
}

