/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut;

import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1TaggedObject;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.DERTaggedObject;

public final class ContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private ASN1Encodable content;

    public ContentInfo(ASN1ObjectIdentifier contentType, ASN1Encodable content) {
        this.contentType = contentType;
        this.content = content;
    }

    public static ContentInfo getInstance(Object obj) {
        if (obj instanceof ContentInfo) {
            return (ContentInfo)((Object)obj);
        }
        if (obj != null) {
            return new ContentInfo(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public ContentInfo(ASN1Sequence seq) {
        this.contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            ASN1TaggedObject tagged = (ASN1TaggedObject)seq.getObjectAt(1);
            if (!tagged.isExplicit() || tagged.getTagNo() != 0) {
                throw new IllegalArgumentException("content \u65e0\u6cd5\u89e3\u6790");
            }
            this.content = tagged.getObject();
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public ContentInfo setContentType(ASN1ObjectIdentifier contentType) {
        this.contentType = contentType;
        return this;
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    public ContentInfo setContent(ASN1Encodable content) {
        this.content = content;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.contentType);
        if (this.content != null) {
            v.add((ASN1Encodable)new DERTaggedObject(0, this.content));
        }
        return new DERSequence(v);
    }
}

