/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1OctetString;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.util.BigIntegers;

public class SM2Cipher
extends ASN1Object {
    private ASN1Integer xCoordinate;
    private ASN1Integer yCoordinate;
    private ASN1OctetString hash;
    private ASN1OctetString cipherText;

    public SM2Cipher() {
    }

    public SM2Cipher(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.xCoordinate = ASN1Integer.getInstance(e.nextElement());
        this.yCoordinate = ASN1Integer.getInstance(e.nextElement());
        this.hash = ASN1OctetString.getInstance(e.nextElement());
        this.cipherText = ASN1OctetString.getInstance(e.nextElement());
    }

    public static SM2Cipher getInstance(Object o) {
        if (o instanceof SM2Cipher) {
            return (SM2Cipher)((Object)o);
        }
        if (o != null) {
            return new SM2Cipher(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public ASN1Integer getxCoordinate() {
        return this.xCoordinate;
    }

    public void setxCoordinate(ASN1Integer xCoordinate) {
        this.xCoordinate = xCoordinate;
    }

    public ASN1Integer getyCoordinate() {
        return this.yCoordinate;
    }

    public void setyCoordinate(ASN1Integer yCoordinate) {
        this.yCoordinate = yCoordinate;
    }

    public ASN1OctetString getHash() {
        return this.hash;
    }

    public void setHash(ASN1OctetString hash) {
        this.hash = hash;
    }

    public ASN1OctetString getCipherText() {
        return this.cipherText;
    }

    public void setCipherText(ASN1OctetString cipherText) {
        this.cipherText = cipherText;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.xCoordinate);
        v.add((ASN1Encodable)this.yCoordinate);
        v.add((ASN1Encodable)this.hash);
        v.add((ASN1Encodable)this.cipherText);
        return new DERSequence(v);
    }

    public byte[] convertC1C3C2() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        byte[] tmp = BigIntegers.asUnsignedByteArray((BigInteger)this.getxCoordinate().getValue());
        System.arraycopy(tmp, 0, x, 32 - tmp.length, tmp.length);
        tmp = BigIntegers.asUnsignedByteArray((BigInteger)this.getyCoordinate().getValue());
        System.arraycopy(tmp, 0, y, 32 - tmp.length, tmp.length);
        stream.write(4);
        stream.write(x);
        stream.write(y);
        stream.write(this.getHash().getOctets());
        stream.write(this.getCipherText().getOctets());
        stream.flush();
        return stream.toByteArray();
    }

    public static SM2Cipher fromC1C3C2(byte[] c1c3c2) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(c1c3c2);
        stream.read();
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        byte[] hash = new byte[32];
        int length = c1c3c2.length - 1 - 32 - 32 - 32;
        byte[] cipherText = new byte[length];
        stream.read(x);
        stream.read(y);
        stream.read(hash);
        stream.read(cipherText);
        SM2Cipher sm2Cipher = new SM2Cipher();
        sm2Cipher.setxCoordinate(new ASN1Integer(new BigInteger(1, x)));
        sm2Cipher.setyCoordinate(new ASN1Integer(new BigInteger(1, y)));
        sm2Cipher.setHash((ASN1OctetString)new DEROctetString(hash));
        sm2Cipher.setCipherText((ASN1OctetString)new DEROctetString(cipherText));
        return sm2Cipher;
    }
}

