/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.reader;

import com.ygsoft.abc.mapp.ygca.exception.VerifyRuntimeException;
import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.OFDElement;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.doc.CT_CommonData;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.doc.Document;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.DocBody;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.OFD;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.CT_MultiMedia;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.MediaType;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.OFDResource;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.Res;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.resources.ColorSpaces;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.resources.CompositeGraphicUnits;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.resources.DrawParams;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.resources.Fonts;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.resources.MultiMedias;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_RefID;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.compositeObj.CT_VectorG;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.pageDescription.CT_GraphicUnit;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.text.font.CT_Font;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.OFDDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.OFDReader;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.ResourceLocator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class ResourceManage {
    private final Map<String, CT_ColorSpace> colorSpaceMap = new HashMap<String, CT_ColorSpace>();
    private final Map<String, CT_DrawParam> drawParamMap = new HashMap<String, CT_DrawParam>();
    private final Map<String, CT_Font> fontMap = new HashMap<String, CT_Font>();
    private final Map<String, CT_MultiMedia> multiMediaMap = new HashMap<String, CT_MultiMedia>();
    private final Map<String, CT_VectorG> compositeGraphicUnitMap = new HashMap<String, CT_VectorG>();
    private final Map<String, OFDElement> allResMap = new HashMap<String, OFDElement>();
    private CT_CommonData commonData;
    private final OFDReader ofdReader;

    public ResourceManage(OFDReader ofdReader) {
        this.ofdReader = ofdReader;
        try {
            this.loadDefaultDoc();
        }
        catch (Exception e) {
            throw new VerifyRuntimeException("\u6587\u6863\u7ed3\u6784\u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public ResourceManage(OFDReader ofdReader, int docNum) {
        this.ofdReader = ofdReader;
        try {
            this.loadDoc(docNum);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u6863\u7ed3\u6784\u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public CT_DrawParam getDrawParam(String id) {
        return this.drawParamMap.get(id);
    }

    public CT_DrawParam getDrawParamFinal(String id) {
        if (id == null) {
            return null;
        }
        CT_DrawParam current = this.drawParamMap.get(id);
        return this.superDrawParam(current);
    }

    public CT_DrawParam superDrawParam(CT_DrawParam current) {
        if (current == null) {
            return null;
        }
        ST_RefID relative = (current = current.clone()).getRelative();
        if (relative == null) {
            return current;
        }
        CT_DrawParam parent = this.getDrawParamFinal(relative.toString());
        if (parent == null) {
            return current;
        }
        if (current.attributeValue("LineWidth") == null && parent.attributeValue("LineWidth") != null) {
            current.addAttribute("LineWidth", parent.attributeValue("LineWidth"));
        }
        if (current.attributeValue("Join") == null && parent.attributeValue("Join") != null) {
            current.addAttribute("Join", parent.attributeValue("Join"));
        }
        if (current.attributeValue("Cap") == null && parent.attributeValue("Cap") != null) {
            current.addAttribute("Cap", parent.attributeValue("Cap"));
        }
        if (current.attributeValue("DashOffset") == null && parent.attributeValue("DashOffset") != null) {
            current.addAttribute("DashOffset", parent.attributeValue("DashOffset"));
        }
        if (current.attributeValue("DashPattern") == null && parent.attributeValue("DashPattern") != null) {
            current.addAttribute("DashPattern", parent.attributeValue("DashPattern"));
        }
        if (current.attributeValue("MiterLimit") == null && parent.attributeValue("MiterLimit") != null) {
            current.addAttribute("MiterLimit", parent.attributeValue("MiterLimit"));
        }
        if (current.getFillColor() == null && parent.getFillColor() != null) {
            current.setFillColor(parent.getFillColor());
        }
        if (current.getStrokeColor() == null && parent.getStrokeColor() != null) {
            current.setStrokeColor(parent.getStrokeColor());
        }
        return current;
    }

    public CT_DrawParam superDrawParam(CT_GraphicUnit<?> current) {
        if (current == null) {
            return null;
        }
        ST_RefID drawParam = current.getDrawParam();
        if (drawParam == null) {
            return null;
        }
        CT_DrawParam parent = this.getDrawParamFinal(drawParam.toString());
        if (parent == null) {
            return null;
        }
        if (current.attributeValue("LineWidth") == null && parent.attributeValue("LineWidth") != null) {
            current.addAttribute("LineWidth", parent.attributeValue("LineWidth"));
        }
        if (current.attributeValue("Join") == null && parent.attributeValue("Join") != null) {
            current.addAttribute("Join", parent.attributeValue("Join"));
        }
        if (current.attributeValue("Cap") == null && parent.attributeValue("Cap") != null) {
            current.addAttribute("Cap", parent.attributeValue("Cap"));
        }
        if (current.attributeValue("DashOffset") == null && parent.attributeValue("DashOffset") != null) {
            current.addAttribute("DashOffset", parent.attributeValue("DashOffset"));
        }
        if (current.attributeValue("DashPattern") == null && parent.attributeValue("DashPattern") != null) {
            current.addAttribute("DashPattern", parent.attributeValue("DashPattern"));
        }
        if (current.attributeValue("MiterLimit") == null && parent.attributeValue("MiterLimit") != null) {
            current.addAttribute("MiterLimit", parent.attributeValue("MiterLimit"));
        }
        return parent;
    }

    public CT_MultiMedia getMultiMedia(String id) {
        return this.multiMediaMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage(String refID) throws IOException {
        CT_MultiMedia multiMedia = this.getMultiMedia(refID);
        if (multiMedia == null) {
            return null;
        }
        if (MediaType.Image != multiMedia.getType()) {
            return null;
        }
        ST_Loc loc = multiMedia.getMediaFile();
        if (loc == null) {
            return null;
        }
        ResourceLocator rl = this.ofdReader.getResourceLocator();
        rl.save();
        try {
            FileInputStream in;
            block11: {
                BufferedImage bufferedImage;
                FilePath imgPath = rl.getFile(loc);
                in = null;
                try {
                    in = new FileInputStream(new File(imgPath.getPath()));
                    String fileName = loc.getFileName().toLowerCase();
                    if (!fileName.endsWith(".jb2") && !fileName.endsWith(".gbig2")) break block11;
                    bufferedImage = null;
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close(in);
                return bufferedImage;
            }
            BufferedImage bufferedImage = ImageIO.read(in);
            IOUtil.close(in);
            return bufferedImage;
        }
        finally {
            rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImageByteArray(String refID) throws IOException {
        CT_MultiMedia multiMedia = this.getMultiMedia(refID);
        if (multiMedia == null) {
            return null;
        }
        if (MediaType.Image != multiMedia.getType()) {
            return null;
        }
        ST_Loc loc = multiMedia.getMediaFile();
        if (loc == null) {
            return null;
        }
        ResourceLocator rl = this.ofdReader.getResourceLocator();
        rl.save();
        try {
            byte[] byArray;
            FilePath imgPath = rl.getFile(loc);
            FileInputStream in = null;
            try {
                in = new FileInputStream(new File(imgPath.getPath()));
                byArray = IOUtil.toByteArray(in);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close(in);
            return byArray;
        }
        finally {
            rl.restore();
        }
    }

    public BufferedImage getImage(ImageObject imageObject) throws IOException {
        BufferedImage mask;
        BufferedImage image = this.getImage(imageObject.getResourceID().toString());
        if (image == null) {
            return null;
        }
        if (imageObject.getImageMask() == null || (mask = this.getImage(imageObject.getImageMask().toString())) != null) {
            // empty if block
        }
        return image;
    }

    public CT_Font getFont(String id) {
        return this.fontMap.get(id);
    }

    public CT_ColorSpace getColorSpace(String id) {
        if (id == null) {
            ST_RefID defaultCSIdRef = this.commonData.getDefaultCS();
            if (defaultCSIdRef == null) {
                return null;
            }
            id = defaultCSIdRef.toString();
        }
        return this.colorSpaceMap.get(id);
    }

    public CT_VectorG getCompositeGraphicUnit(String id) {
        return this.compositeGraphicUnitMap.get(id);
    }

    public ResourceManage loadDoc(int docNum) throws IOException, DocumentException {
        OFDDir ofdDir = this.ofdReader.getOFDDir();
        OFD ofd = ofdDir.getOfd();
        DocBody docBody = ofd.getDocBody(docNum);
        this.colorSpaceMap.clear();
        this.drawParamMap.clear();
        this.fontMap.clear();
        this.multiMediaMap.clear();
        this.compositeGraphicUnitMap.clear();
        this.loadDocRes(docBody);
        return this;
    }

    private void loadDefaultDoc() throws IOException, DocumentException {
        OFDDir ofdDir = this.ofdReader.getOFDDir();
        OFD ofd = ofdDir.getOfd();
        this.loadDocRes(ofd.getDocBody());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDocRes(DocBody docBody) throws IOException, DocumentException {
        ResourceLocator rl = this.ofdReader.getResourceLocator();
        try {
            rl.save();
            ST_Loc docRoot = docBody.getDocRoot();
            Document document = rl.get(docRoot, Document.newFunc());
            rl.cd(docRoot.parent());
            this.commonData = new CT_CommonData((Element)document.getCommonData().clone());
            for (ST_Loc pubResLoc : this.commonData.getPublicResList()) {
                this.loadResFile(rl, pubResLoc);
            }
            for (ST_Loc docResLoc : this.commonData.getDocumentResList()) {
                this.loadResFile(rl, docResLoc);
            }
        }
        finally {
            rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResFile(ResourceLocator rl, ST_Loc resLoc) {
        if (resLoc == null) {
            return;
        }
        try {
            rl.save();
            rl.cd(resLoc.parent());
            Res res = rl.get(resLoc, Res.newFunc());
            ST_Loc baseLoc = res.getBaseLoc();
            for (OFDResource ofdResource : res.getResources()) {
                OFDElement item;
                if (ofdResource instanceof ColorSpaces) {
                    for (CT_ColorSpace colorSpace : ((ColorSpaces)ofdResource).getColorSpaces()) {
                        item = new CT_ColorSpace((Element)colorSpace.clone());
                        if (((CT_ColorSpace)item).getProfile() != null) {
                            ST_Loc absProfile = this.abs(rl, baseLoc, ((CT_ColorSpace)item).getProfile());
                            ((CT_ColorSpace)item).setProfile(absProfile);
                        }
                        this.colorSpaceMap.put(((CT_ColorSpace)item).getID().toString(), (CT_ColorSpace)item);
                        this.allResMap.put(((CT_ColorSpace)item).getID().toString(), item);
                    }
                    continue;
                }
                if (ofdResource instanceof DrawParams) {
                    for (CT_DrawParam drawParam : ((DrawParams)ofdResource).getDrawParams()) {
                        item = new CT_DrawParam(drawParam.clone());
                        this.drawParamMap.put(((CT_DrawParam)item).getID().toString(), (CT_DrawParam)item);
                        this.allResMap.put(((CT_DrawParam)item).getID().toString(), item);
                    }
                    continue;
                }
                if (ofdResource instanceof Fonts) {
                    for (CT_Font font : ((Fonts)ofdResource).getFonts()) {
                        item = new CT_Font((Element)font.clone());
                        if (((CT_Font)item).getFontFile() != null) {
                            ST_Loc absFontFile = this.abs(rl, baseLoc, ((CT_Font)item).getFontFile());
                            ((CT_Font)item).setFontFile(absFontFile);
                        }
                        this.fontMap.put(((CT_Font)item).getID().toString(), (CT_Font)item);
                        this.allResMap.put(((CT_Font)item).getID().toString(), item);
                    }
                    continue;
                }
                if (ofdResource instanceof MultiMedias) {
                    for (CT_MultiMedia multiMedia : ((MultiMedias)ofdResource).getMultiMedias()) {
                        item = new CT_MultiMedia((Element)multiMedia.clone());
                        if (((CT_MultiMedia)item).getMediaFile() != null) {
                            ST_Loc absMediaFile = this.abs(rl, baseLoc, ((CT_MultiMedia)item).getMediaFile());
                            ((CT_MultiMedia)item).setMediaFile(absMediaFile);
                        }
                        this.multiMediaMap.put(((CT_MultiMedia)item).getID().toString(), (CT_MultiMedia)item);
                        this.allResMap.put(((CT_MultiMedia)item).getID().toString(), item);
                    }
                    continue;
                }
                if (!(ofdResource instanceof CompositeGraphicUnits)) continue;
                for (CT_VectorG ctVectorG : ((CompositeGraphicUnits)ofdResource).getCompositeGraphicUnits()) {
                    item = new CT_VectorG((Element)ctVectorG.clone());
                    this.compositeGraphicUnitMap.put(((CT_VectorG)item).getID().toString(), (CT_VectorG)item);
                    this.allResMap.put(((CT_VectorG)item).getID().toString(), item);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            rl.restore();
        }
    }

    private ST_Loc abs(ResourceLocator rl, ST_Loc base, ST_Loc target) {
        ST_Loc absLoc;
        if (target == null) {
            return null;
        }
        if (base != null) {
            absLoc = rl.getAbsTo(base);
            absLoc = absLoc.cat(target);
        } else {
            absLoc = rl.getAbsTo(target);
        }
        return absLoc;
    }

    public List<CT_ColorSpace> getColorSpaces() {
        return new ArrayList<CT_ColorSpace>(this.colorSpaceMap.values());
    }

    public List<CT_DrawParam> getDrawParams() {
        return new ArrayList<CT_DrawParam>(this.drawParamMap.values());
    }

    public List<CT_Font> getFonts() {
        return new ArrayList<CT_Font>(this.fontMap.values());
    }

    public List<CT_MultiMedia> getMultiMedias() {
        return new ArrayList<CT_MultiMedia>(this.multiMediaMap.values());
    }

    public List<CT_VectorG> getCompositeGraphicUnits() {
        return new ArrayList<CT_VectorG>(this.compositeGraphicUnitMap.values());
    }

    public OFDReader getOfdReader() {
        return this.ofdReader;
    }

    public OFDElement get(String id) {
        return this.allResMap.get(id);
    }
}

