/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.sign.stamppos;

import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.Page;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Box;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_RefID;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.appearance.StampAnnot;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.OFDReader;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.SignIDProvider;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.stamppos.CuttingRatio;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.stamppos.Side;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.stamppos.StampAppearance;
import java.util.ArrayList;
import java.util.List;

public class CuttingRideStampPos
implements StampAppearance {
    private Side side;
    private double width;
    private double height;
    private Double offset = null;
    private double margin = 0.0;
    private List<CuttingRatio> cuttingRatios;

    public CuttingRideStampPos(Side side, Double offset, double width, double height, double margin, List<CuttingRatio> cuttingRatios) {
        this.side = side;
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.margin = margin;
        this.cuttingRatios = cuttingRatios;
    }

    @Override
    public List<StampAnnot> getAppearance(OFDReader ctx, SignIDProvider idProvider) {
        ArrayList<StampAnnot> res;
        block13: {
            int numPage;
            block12: {
                numPage = ctx.getNumberOfPages();
                res = new ArrayList<StampAnnot>(numPage);
                if (this.side != Side.Right) break block12;
                double itemWith = this.width * 0.5;
                for (int i = 0; i < numPage; ++i) {
                    double x;
                    Page page = ctx.getPage(i + 1);
                    ST_Box pageSize = ctx.getPageSize(page);
                    ST_Box clip = null;
                    if (numPage - 1 != i) {
                        if (this.cuttingRatios != null && this.cuttingRatios.size() > 0) {
                            itemWith = this.width * this.cuttingRatios.get(i).getLeft();
                        }
                        x = pageSize.getWidth() - itemWith - this.margin;
                        clip = new ST_Box(0.0, 0.0, itemWith, this.height);
                    } else {
                        if (this.cuttingRatios != null && this.cuttingRatios.size() > 0) {
                            itemWith = this.width * this.cuttingRatios.get(i - 1).getRight();
                        }
                        x = 0.0 - (this.width - itemWith) + this.margin;
                        clip = new ST_Box(this.width - itemWith, 0.0, itemWith, this.height);
                    }
                    double y = this.offset == null ? pageSize.getHeight() / 2.0 - this.height / 2.0 : this.offset;
                    ST_RefID ref = ctx.getPageObjectId(i + 1).ref();
                    StampAnnot annot = new StampAnnot().setID(idProvider.incrementAndGet()).setBoundary(new ST_Box(x, y, this.width, this.height)).setPageRef(ref).setClip(clip);
                    res.add(annot);
                    if (0 == i || numPage - 1 == i) continue;
                    if (this.cuttingRatios != null && this.cuttingRatios.size() > 0) {
                        itemWith = this.width * this.cuttingRatios.get(i - 1).getRight();
                    }
                    x = 0.0 - (this.width - itemWith) + this.margin;
                    clip = new ST_Box(this.width - itemWith, 0.0, itemWith, this.height);
                    annot = new StampAnnot().setID(idProvider.incrementAndGet()).setBoundary(new ST_Box(x, y, this.width, this.height)).setPageRef(ref).setClip(clip);
                    res.add(annot);
                }
                break block13;
            }
            if (this.side != Side.Left) break block13;
            double itemWith = this.width * 0.5;
            for (int i = 0; i < numPage; ++i) {
                double x;
                Page page = ctx.getPage(i + 1);
                ST_Box pageSize = ctx.getPageSize(page);
                ST_Box clip = null;
                if (numPage - 1 != i) {
                    if (this.cuttingRatios != null && this.cuttingRatios.size() > 0) {
                        itemWith = this.width * this.cuttingRatios.get(i).getLeft();
                    }
                    x = 0.0 - (this.width - itemWith) + this.margin;
                    clip = new ST_Box(this.width - itemWith, 0.0, itemWith, this.height);
                } else {
                    if (this.cuttingRatios != null && this.cuttingRatios.size() > 0) {
                        itemWith = this.width * this.cuttingRatios.get(i - 1).getRight();
                    }
                    x = pageSize.getWidth() - itemWith - this.margin;
                    clip = new ST_Box(0.0, 0.0, itemWith, this.height);
                }
                double y = this.offset == null ? pageSize.getHeight() / 2.0 - this.height / 2.0 : this.offset;
                ST_RefID ref = ctx.getPageObjectId(i + 1).ref();
                StampAnnot annot = new StampAnnot().setID(idProvider.incrementAndGet()).setBoundary(new ST_Box(x, y, this.width, this.height)).setPageRef(ref).setClip(clip);
                res.add(annot);
                if (0 == i || numPage - 1 == i) continue;
                if (this.cuttingRatios != null && this.cuttingRatios.size() > 0) {
                    itemWith = this.width * this.cuttingRatios.get(i - 1).getRight();
                }
                x = pageSize.getWidth() - itemWith - this.margin;
                clip = new ST_Box(0.0, 0.0, itemWith, this.height);
                annot = new StampAnnot().setID(idProvider.incrementAndGet()).setBoundary(new ST_Box(x, y, this.width, this.height)).setPageRef(ref).setClip(clip);
                res.add(annot);
            }
        }
        return res;
    }
}

