/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public static Date getDate(String time) {
        try {
            return simpleDateFormat.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getSdfDate(String time) {
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getTimeStamp(String day) {
        try {
            return sdf.parse(day).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String simpleFormatDate(Date date) {
        return simpleDateFormat.format(date);
    }

    public static String formatDate(Date date) {
        return sdf.format(date);
    }

    public static String formatDate(long timestamp) {
        return simpleDateFormat.format(new Date(timestamp));
    }

    public static String getRecentFiveDayTimeStamp() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -4);
        Date d = c.getTime();
        return sdf.format(d);
    }

    public static long getRecentOneMinuteTimeStamp() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(12, -1);
        Date d = c.getTime();
        return d.getTime();
    }

    public static Date getYearAfterTomorrow() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        cal.set(1, year + 2);
        return cal.getTime();
    }

    public static Date getStartOfYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getEndOfYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 11);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getYearAfterTomorrow());
    }
}

