/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.bc;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;

public class EncryptedObjectStoreData
extends ASN1Object {
    private final AlgorithmIdentifier encryptionAlgorithm;
    private final ASN1OctetString encryptedContent;

    public EncryptedObjectStoreData(AlgorithmIdentifier encryptionAlgorithm, byte[] encryptedContent) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptedContent = new DEROctetString(encryptedContent);
    }

    private EncryptedObjectStoreData(ASN1Sequence seq) {
        this.encryptionAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.encryptedContent = ASN1OctetString.getInstance(seq.getObjectAt(1));
    }

    public static EncryptedObjectStoreData getInstance(Object o) {
        if (o instanceof EncryptedObjectStoreData) {
            return (EncryptedObjectStoreData)o;
        }
        if (o != null) {
            return new EncryptedObjectStoreData(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ASN1OctetString getEncryptedContent() {
        return this.encryptedContent;
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.encryptionAlgorithm);
        v.add(this.encryptedContent);
        return new DERSequence(v);
    }
}

