/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.esf;

import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.esf.CrlValidatedID;
import java.util.Enumeration;

public class CrlListID
extends ASN1Object {
    private ASN1Sequence crls;

    public static CrlListID getInstance(Object obj) {
        if (obj instanceof CrlListID) {
            return (CrlListID)obj;
        }
        if (obj != null) {
            return new CrlListID(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private CrlListID(ASN1Sequence seq) {
        this.crls = (ASN1Sequence)seq.getObjectAt(0);
        Enumeration e = this.crls.getObjects();
        while (e.hasMoreElements()) {
            CrlValidatedID.getInstance(e.nextElement());
        }
    }

    public CrlListID(CrlValidatedID[] crls) {
        this.crls = new DERSequence(crls);
    }

    public CrlValidatedID[] getCrls() {
        CrlValidatedID[] result = new CrlValidatedID[this.crls.size()];
        for (int idx = 0; idx < result.length; ++idx) {
            result[idx] = CrlValidatedID.getInstance(this.crls.getObjectAt(idx));
        }
        return result;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.crls);
    }
}

