/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.base;

import cn.org.bjca.gaia.assemb.base.FPEType;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.BjcaKeyPair;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public interface GaiaProvider {
    public BjcaKeyPair genKeyPair(AlgPolicy var1, int var2) throws PkiException;

    public BjcaKey genSymmKey(AlgPolicy var1, int var2) throws PkiException;

    public byte[] signHashedData(AlgPolicy var1, byte[] var2, BjcaKey var3) throws PkiException;

    public boolean verifySignHashedData(AlgPolicy var1, byte[] var2, byte[] var3, BjcaKey var4) throws PkiException;

    public byte[] signData(AlgPolicy var1, byte[] var2, BjcaKey var3) throws PkiException;

    public boolean verifySignData(AlgPolicy var1, byte[] var2, byte[] var3, BjcaKey var4) throws PkiException;

    public byte[] hash(AlgPolicy var1, byte[] var2) throws PkiException;

    public byte[] hash(AlgPolicy var1, InputStream var2, int var3) throws PkiException;

    public byte[] encrypt(AlgPolicy var1, BjcaKey var2, byte[] var3) throws PkiException;

    public boolean encrypt(AlgPolicy var1, BjcaKey var2, InputStream var3, OutputStream var4, int var5) throws PkiException;

    public byte[] decrypt(AlgPolicy var1, BjcaKey var2, byte[] var3) throws PkiException;

    public boolean decrypt(AlgPolicy var1, BjcaKey var2, InputStream var3, OutputStream var4, int var5) throws PkiException;

    public byte[] genRandom(int var1) throws PkiException;

    public byte[] backupAllKey(byte[] var1) throws PkiException;

    public boolean restoreAllKey(byte[] var1, byte[] var2) throws PkiException;

    public byte[] mac(AlgPolicy var1, byte[] var2, byte[] var3) throws PkiException;

    public byte[] mac(AlgPolicy var1, byte[] var2, InputStream var3, int var4) throws PkiException;

    public byte[] generateRangeRandom(byte[] var1);

    public byte[] bigIntegerModAdd(byte[] var1, byte[] var2, byte[] var3);

    public byte[] bigIntegerModSub(byte[] var1, byte[] var2, byte[] var3);

    public byte[] bigIntegerModMul(byte[] var1, byte[] var2, byte[] var3);

    public byte[] bigIntegerModExp(byte[] var1, byte[] var2, byte[] var3);

    public byte[] bigIntegerModInverse(byte[] var1, byte[] var2);

    public byte[] SM2PointMul(byte[] var1, byte[] var2);

    public byte[] SM2PointAdd(byte[] var1, byte[] var2);

    public byte[] SM2PointSub(byte[] var1, byte[] var2);

    public byte[] SemServerSM2SignFinal(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws PkiException;

    public byte[] SemServerGenerateSM2Key(byte[] var1, byte[] var2);

    public byte[] encrypt(AlgPolicy var1, BjcaKey var2, byte[] var3, int var4, byte[] var5, int var6) throws PkiException;

    public byte[] decrypt(AlgPolicy var1, BjcaKey var2, byte[] var3, int var4, byte[] var5, int var6) throws PkiException;

    public boolean encrypt(AlgPolicy var1, BjcaKey var2, InputStream var3, OutputStream var4, int var5, int var6, byte[] var7, int var8) throws PkiException;

    public boolean decrypt(AlgPolicy var1, BjcaKey var2, InputStream var3, OutputStream var4, int var5, int var6, byte[] var7, int var8) throws PkiException;

    public BjcaKeyPair genKeyPairSM9(AlgPolicy var1, byte[] var2) throws PkiException;

    public byte[] signDataSM9(AlgPolicy var1, byte[] var2, BjcaKeyPair var3) throws PkiException;

    public boolean verifySignDataSM9(AlgPolicy var1, byte[] var2, byte[] var3, BjcaKey var4) throws PkiException;

    public byte[] encryptSM9(AlgPolicy var1, BjcaKey var2, byte[] var3) throws PkiException;

    public byte[] decryptSM9(AlgPolicy var1, BjcaKeyPair var2, byte[] var3) throws PkiException;

    public byte[][] sm9WrapKey(BjcaKey var1, int var2) throws PkiException;

    public byte[] sm9UnWrapKey(BjcaKeyPair var1, int var2, byte[] var3) throws PkiException;

    public Map sm9ExchangeKeyInitiatorRequest(BjcaKeyPair var1, BjcaKey var2, int var3) throws PkiException;

    public byte[][] sm9ExchangeKeyResponder(BjcaKeyPair var1, BjcaKey var2, int var3, byte[] var4) throws PkiException;

    public byte[][] sm9ExchangeKeyInitiatorComputeKey(BjcaKeyPair var1, BjcaKey var2, int var3, byte[] var4, byte[] var5, Map var6) throws PkiException;

    public byte[] signDataED25519(AlgPolicy var1, byte[] var2, BjcaKey var3) throws PkiException;

    public boolean verifySignedDataED25519(AlgPolicy var1, byte[] var2, byte[] var3, BjcaKey var4) throws PkiException;

    public byte[] semV2ClientG1(byte[] var1, byte[] var2);

    public byte[] semV2ClientG2();

    public byte[] semV2ClientG3(byte[] var1, byte[] var2);

    public byte[] semV2ServerG4(byte[] var1, byte[] var2, byte[] var3);

    public byte[] semV2Client2CalcDCS(byte[] var1, byte[] var2);

    public byte[] semV2Server2CalcDSS(byte[] var1, byte[] var2);

    public String fpeEncrypt(AlgPolicy var1, BjcaKey var2, String var3, FPEType var4, byte[] var5) throws PkiException;

    public String fpeDecrypt(AlgPolicy var1, BjcaKey var2, String var3, FPEType var4, byte[] var5) throws PkiException;

    public int[] fpeEncrypt(AlgPolicy var1, BjcaKey var2, int[] var3, int var4, byte[] var5) throws PkiException;

    public int[] fpeDecrypt(AlgPolicy var1, BjcaKey var2, int[] var3, int var4, byte[] var5) throws PkiException;
}

