/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.constant;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.gm.GMObjectIdentifiers;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.asn1.oiw.OIWObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.KeyPurposeId;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class AlgConstant {
    public static final String RSA = "RSA";
    public static final String RSA_PKCS = "RSA/ECB/PKCS1PADDING";
    public static final String SM2 = "SM2";
    public static final String ED25519 = "ED25519";
    public static final String SM9_SIGN = "SM9_Sign";
    public static final String SM9_EXCHANGE = "SM9_Exchange";
    public static final String SM9_ENCRYPT = "SM9_Encrypt";
    public static final String SHA1 = "SHA1";
    public static final String SHA256 = "SHA256";
    public static final String SM3 = "SM3";
    public static final String SHA224 = "SHA224";
    public static final String SHA384 = "SHA384";
    public static final String SHA512 = "SHA512";
    public static final String HMAC_SHA1 = "HMac-SHA1";
    public static final String HMAC_SHA256 = "HMac-SHA256";
    public static final String HMAC_SM3 = "HMac-SM3";
    public static final String SM4_FPE = "SM4_FPE";
    public static final String SM1_FPE = "SM1_FPE";
    public static final String SSF33_FPE = "SSF33_FPE";
    public static final String AES_FPE = "AES_FPE";
    public static final String SHA1_WITH_RSA = "SHA1WithRSA";
    public static final String SHA256_WITH_RSA = "SHA256WithRSA";
    public static final String SM3_WITH_SM2 = "SM3WithSM2";
    public static final String SM3_WITH_SM9 = "SM3WithSM9";
    public static final String SHA224_WITH_RSA = "SHA224WithRSA";
    public static final String SHA384_WITH_RSA = "SHA384WithRSA";
    public static final String SHA512_WITH_RSA = "SHA512WithRSA";
    public static final String SM4 = "SM4";
    public static final String AES = "AES";
    public static final String DES3 = "DESede";
    public static final String ZUC = "ZUC";
    public static final String SM4_ECB_PKCS5PADDING = "SM4/ECB/PKCS5Padding";
    public static final String SM4_CBC_PKCS5PADDING = "SM4/CBC/PKCS5Padding";
    public static final String SM4_ECB_PKCS7PADDING = "SM4/ECB/PKCS7Padding";
    public static final String SM4_CBC_PKCS7PADDING = "SM4/CBC/PKCS7Padding";
    public static final String SM4_ECB_NOPADDING = "SM4/ECB/NoPadding";
    public static final String SM4_CBC_NOPADDING = "SM4/CBC/NoPadding";
    public static final String SM4_GCM_NOPADDING = "SM4/GCM/NoPadding";
    public static final String SM4_CCM_NOPADDING = "SM4/CCM/NoPadding";
    public static final String SM4_CTR_NOPADDING = "SM4/CTR/NoPadding";
    public static final String SM4_OFB_NOPADDING = "SM4/OFB/NoPadding";
    public static final String SM4_CFB_NOPADDING = "SM4/CFB/NoPadding";
    public static final String AES_ECB_PKCS5PADDING = "AES/ECB/PKCS5Padding";
    public static final String AES_CBC_PKCS5PADDING = "AES/CBC/PKCS5Padding";
    public static final String AES_ECB_PKCS7PADDING = "AES/ECB/PKCS7Padding";
    public static final String AES_CBC_PKCS7PADDING = "AES/CBC/PKCS7Padding";
    public static final String AES_ECB_NOPADDING = "AES/ECB/NoPadding";
    public static final String AES_CBC_NOPADDING = "AES/CBC/NoPadding";
    public static final String AES_GCM_NOPADDING = "AES/GCM/NoPadding";
    public static final String AES_CCM_NOPADDING = "AES/CCM/NoPadding";
    public static final String AES_CTR_NOPADDING = "AES/CTR/NoPadding";
    public static final String AES_OFB_NOPADDING = "AES/OFB/NoPadding";
    public static final String AES_CFB_NOPADDING = "AES/CFB/NoPadding";
    public static final String DES3_ECB_PKCS5PADDING = "DESede/ECB/PKCS5Padding";
    public static final String DES3_CBC_PKCS5PADDING = "DESede/CBC/PKCS5Padding";
    public static final String DES3_ECB_PKCS7PADDING = "DESede/ECB/PKCS7Padding";
    public static final String DES3_CBC_PKCS7PADDING = "DESede/CBC/PKCS7Padding";
    public static final String DES3_ECB_NOPADDING = "DESede/ECB/NoPadding";
    public static final String DES3_CBC_NOPADDING = "DESede/CBC/NoPadding";
    public static final String DES3_OFB_NOPADDING = "DESede/OFB/NoPadding";
    public static final String DES3_CFB_NOPADDING = "DESede/CFB/NoPadding";
    public static final String ZUC_EEA3_NOPADDING = "ZUC/EEA3/NoPadding";
    public static final String PKCS7_PADDING = "PKCS7Padding";
    public static final String PKCS5_PADDING = "PKCS5Padding";
    public static final String NO_PADDING = "NoPadding";
    public static final int SCF_SYMM_NOPADDING = 0;
    public static final int SCF_SYMM_PKCS5PADDING = 1;
    public static final int SCF_SYMM_PKCS7PADDING = 2;
    public static final int SGD_SM1_ECB = 257;
    public static final int SGD_SM1_CBC = 258;
    public static final int SGD_SM1_CFB = 260;
    public static final int SGD_SM1_OFB = 264;
    public static final int SGD_SM1_MAC = 272;
    public static final int SGD_SM1_CTR = 288;
    public static final int SGD_SSF33_ECB = 513;
    public static final int SGD_SSF33_CBC = 514;
    public static final int SGD_SSF33_CFB = 516;
    public static final int SGD_SSF33_OFB = 520;
    public static final int SGD_SSF33_MAC = 528;
    public static final int SGD_SSF33_CTR = 544;
    public static final int SGD_SM4_ECB = 1025;
    public static final int SGD_SM4_CBC = 1026;
    public static final int SGD_SM4_CFB = 1028;
    public static final int SGD_SM4_OFB = 1032;
    public static final int SGD_SM4_MAC = 1040;
    public static final int SGD_SM4_CTR = 1056;
    public static final int SGD_SM4_BC = 1088;
    public static final int SGD_SM4_OFBNLF = 1152;
    public static final int SGD_SM4_XTS = 0x1000400;
    public static final int SGD_SM4_GCM = 0x2000400;
    public static final int SGD_SM4_CCM = 0x4000400;
    public static final int SGD_ZUC_EEA3 = 2049;
    public static final int SGD_ZUC_EIA3 = 2050;
    public static final int SGD_AES_ECB = 0x10000401;
    public static final int SGD_AES_CBC = 268436482;
    public static final int SGD_AES_CFB = 0x10000404;
    public static final int SGD_AES_OFB = 268436488;
    public static final int SGD_AES_MAC = 0x10000410;
    public static final int SGD_AES_CTR = 268436512;
    public static final int SGD_AES_BC = 0x10000440;
    public static final int SGD_AES_OFBNLF = 268436608;
    public static final int SGD_AES_XTS = 0x11000400;
    public static final int SGD_AES_GCM = 301990912;
    public static final int SGD_AES_CCM = 0x14000400;
    public static final int SGD_3DES_ECB = 0x10000801;
    public static final int SGD_3DES_CBC = 268437506;
    public static final int SGD_3DES_CFB = 268437508;
    public static final int SGD_3DES_OFB = 0x10000808;
    public static final int SGD_3DES_MAC = 0x10000810;
    public static final int SGD_3DES_CTR = 268437536;
    public static final int SGD_RSA = 65536;
    public static final int SGD_SM2 = 131328;
    public static final int SGD_SM2_1 = 131584;
    public static final int SGD_SM2_2 = 132096;
    public static final int SGD_SM2_3 = 133120;
    public static final int SGD_SM9 = 262400;
    public static final int SGD_SM9_1 = 262656;
    public static final int SGD_SM9_2 = 263168;
    public static final int SGD_SM9_3 = 264192;
    public static final int SGD_SM3 = 1;
    public static final int SGD_SHA1 = 2;
    public static final int SGD_SHA256 = 4;
    public static final int SGD_SHA224 = 8;
    public static final int SGD_SHA384 = 16;
    public static final int SGD_SHA512 = 32;
    public static final int SGD_SM3_RSA = 65537;
    public static final int SGD_SHA1_RSA = 65538;
    public static final int SGD_SHA256_RSA = 65540;
    public static final int SGD_SM3_SM2 = 131585;
    public static final int SGD_SM3_SM9 = 262657;
    public static final int SGD_SHA224_RSA = 65544;
    public static final int SGD_SHA384_RSA = 65552;
    public static final int SGD_SHA512_RSA = 65568;
    public static final int SGD_SM1_FPE = 0x8000100;
    public static final int SGD_SSF33_FPE = 0x8000200;
    public static final int SGD_SM4_FPE = 0x8000400;
    public static final int SGD_AES_FPE = 402654208;
    public static int SGD_ED25519 = 0x10010000;
    private static final ConcurrentHashMap algMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap sigAlgName2OID = new ConcurrentHashMap();
    private static final ConcurrentHashMap oid2SigAlgName = new ConcurrentHashMap();
    private static final ConcurrentHashMap paddingMap = new ConcurrentHashMap();
    public static final List<String> rsaHashAlgs = new ArrayList<String>();
    public static final List<String> rsaSignAlgs = new ArrayList<String>();
    public static final List<String> sm2HashAlgs = new ArrayList<String>();
    public static final List<String> sm2SignAlgs = new ArrayList<String>();
    public static final List<String> hashAlgs = new ArrayList<String>();
    public static final List<String> signAlgs = new ArrayList<String>();
    public static final ASN1ObjectIdentifier TSA_POLICY_ID = KeyPurposeId.id_kp_timeStamping.toOID();

    private AlgConstant() {
    }

    public static ASN1ObjectIdentifier convertAlgToPkcs7DataOid(String algName) throws PkiException {
        if (!(algName.equals(SHA1_WITH_RSA) || algName.equals(SHA256_WITH_RSA) || algName.equals(SM3_WITH_SM2) || algName.equals(RSA_PKCS) || algName.equals(SM2))) {
            throw new PkiException("11007002\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362PKCS7_DATA_OID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        ASN1ObjectIdentifier p7DataOid = null;
        p7DataOid = SHA1_WITH_RSA.equals(algName) || SHA256_WITH_RSA.equals(algName) || RSA_PKCS.equals(algName) ? PKCSObjectIdentifiers.data : GMObjectIdentifiers.OID_CN_SM2_P7_DATA;
        return p7DataOid;
    }

    public static ASN1ObjectIdentifier convertAlgNameToPkcs7SignDataOid(String algName) throws PkiException {
        if (!(algName.equals(SHA1_WITH_RSA) || algName.equals(SHA256_WITH_RSA) || algName.equals(SM3_WITH_SM2))) {
            throw new PkiException("11007003\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362PKCS7_SIGNDATA_OID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        ASN1ObjectIdentifier p7SignDataOid = null;
        p7SignDataOid = SHA1_WITH_RSA.equals(algName) || SHA256_WITH_RSA.equals(algName) ? PKCSObjectIdentifiers.signedData : GMObjectIdentifiers.OID_CN_SM2_P7_SignedData;
        return p7SignDataOid;
    }

    public static ASN1ObjectIdentifier convertAlgToEnvelopedDataOid(String algName) throws PkiException {
        if (!(algName.equals(SHA1_WITH_RSA) || algName.equals(SHA256_WITH_RSA) || algName.equals(SM3_WITH_SM2) || algName.equals(RSA_PKCS) || algName.equals(SM2))) {
            throw new PkiException("11007002\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362PKCS7_DATA_OID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        ASN1ObjectIdentifier p7EnvelopedDataOid = null;
        p7EnvelopedDataOid = SHA1_WITH_RSA.equals(algName) || SHA256_WITH_RSA.equals(algName) || RSA_PKCS.equals(algName) ? PKCSObjectIdentifiers.envelopedData : GMObjectIdentifiers.OID_CN_SM2_P7_EnvelpedData;
        return p7EnvelopedDataOid;
    }

    public static ASN1ObjectIdentifier convertAlgNameToEncryptOid(String algName) throws PkiException {
        if (!(algName.equals(SHA1_WITH_RSA) || algName.equals(SHA256_WITH_RSA) || algName.equals(SM3_WITH_SM2) || algName.equals(RSA_PKCS) || algName.equals(SM2))) {
            throw new PkiException("11007004\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362ENCRYPT_OID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        ASN1ObjectIdentifier encryptOid = null;
        encryptOid = SHA1_WITH_RSA.equals(algName) || SHA256_WITH_RSA.equals(algName) || RSA_PKCS.equals(algName) ? PKCSObjectIdentifiers.rsaEncryption : GMObjectIdentifiers.sm2encrypt;
        return encryptOid;
    }

    public static ASN1ObjectIdentifier convertAlgNameToSignOid(String algName) throws PkiException {
        if (!(algName.equals(SHA1_WITH_RSA) || algName.equals(SHA256_WITH_RSA) || algName.equals(SM3_WITH_SM2) || algName.equals(RSA_PKCS) || algName.equals(SM2))) {
            throw new PkiException("11007004\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362ENCRYPT_OID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        ASN1ObjectIdentifier encryptOid = null;
        encryptOid = SHA1_WITH_RSA.equals(algName) || SHA256_WITH_RSA.equals(algName) || RSA_PKCS.equals(algName) ? PKCSObjectIdentifiers.rsaEncryption : GMObjectIdentifiers.sm2sign;
        return encryptOid;
    }

    public static AlgorithmIdentifier convertAlgorithmIdentifier(String alg) throws PkiException {
        AlgorithmIdentifier signAlgId;
        if (alg.toUpperCase().contains(SHA1)) {
            signAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, DERNull.INSTANCE);
        } else if (alg.toUpperCase().contains(SHA256) || alg.toUpperCase().contains(RSA)) {
            signAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption, DERNull.INSTANCE);
        } else if (alg.toUpperCase().contains(SM3) || alg.toUpperCase().contains(SM2)) {
            signAlgId = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3, DERNull.INSTANCE);
        } else {
            throw new PkiException("11007010", "\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362\u4e3a\u7b97\u6cd5\u6807\u8bc6OID\u5931\u8d25 :" + alg);
        }
        return signAlgId;
    }

    public static int convertAlgNameToJniId(String algName) throws PkiException {
        Object ob = algMap.get(algName);
        if (null == ob) {
            throw new PkiException("11007005\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362JNI_ID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        return (Integer)ob;
    }

    public static int convertAlgNameToJniPaddingId(String algName) throws PkiException {
        Object ob = paddingMap.get(algName);
        if (null == ob) {
            throw new PkiException("11007006\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362JNI_PADDINIG_ID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        return (Integer)ob;
    }

    public static String convertSignAlgToHashAlg(String algName) throws PkiException {
        if (!(algName.equals(SHA1_WITH_RSA) || algName.equals(SHA256_WITH_RSA) || algName.equals(SM3_WITH_SM2))) {
            throw new PkiException("11007007\u7b7e\u540d\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362\u4e3a\u6458\u8981\u7b97\u6cd5\u540d\u79f0\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        String hashAlgName = null;
        hashAlgName = SHA1_WITH_RSA.equals(algName) ? SHA1 : (SHA256_WITH_RSA.equals(algName) ? SHA256 : SM3);
        return hashAlgName;
    }

    public static String convertSignAlgToHashAlgc(String algName) throws PkiException {
        if (!signAlgs.contains(algName)) {
            throw new PkiException("11007007\u7b7e\u540d\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362\u4e3a\u6458\u8981\u7b97\u6cd5\u540d\u79f0\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        String hashAlgName = null;
        hashAlgName = SHA1_WITH_RSA.equals(algName) ? SHA1 : (SHA256_WITH_RSA.equals(algName) ? SHA256 : (SHA224_WITH_RSA.equals(algName) ? SHA224 : (SHA384_WITH_RSA.equals(algName) ? SHA384 : (SHA512_WITH_RSA.equals(algName) ? SHA512 : SM3))));
        return hashAlgName;
    }

    public static String convertHashAlgToSignAlg(String hashAlg) throws PkiException {
        if (!(hashAlg.equals(SHA1) || hashAlg.equals(SHA256) || hashAlg.equals(SM3))) {
            throw new PkiException("11007008\u6458\u8981\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362\u4e3a\u7b7e\u540d\u7b97\u6cd5\u540d\u79f0\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + hashAlg);
        }
        String signAlgName = null;
        signAlgName = SHA1.equals(hashAlg) ? SHA1_WITH_RSA : (SHA256.equals(hashAlg) ? SHA256_WITH_RSA : SM3_WITH_SM2);
        return signAlgName;
    }

    public static String convertSymmAlgToSymmKeyAlg(String symmAlg) throws PkiException {
        String symmKeyAlg = null;
        if (SM4_CBC_PKCS5PADDING.equals(symmAlg) || SM4_ECB_PKCS5PADDING.equals(symmAlg)) {
            symmKeyAlg = SM4;
        } else if (DES3_CBC_PKCS5PADDING.equals(symmAlg) || DES3_ECB_PKCS5PADDING.equals(symmAlg)) {
            symmKeyAlg = DES3;
        } else {
            throw new PkiException("11007011\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362\u4e3a\u5bc6\u94a5\u540d\u79f0\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 symmAlg = " + symmAlg);
        }
        return symmKeyAlg;
    }

    public static ASN1ObjectIdentifier convertAlgNameToOid(String algName) throws PkiException {
        Object ob = sigAlgName2OID.get(algName);
        if (null == ob) {
            throw new PkiException("11007010\u7b97\u6cd5\u540d\u79f0\u8f6c\u6362\u4e3a\u7b97\u6cd5\u6807\u8bc6OID\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algName);
        }
        return (ASN1ObjectIdentifier)ob;
    }

    public static String convertOidToAlgName(ASN1ObjectIdentifier algOid) throws PkiException {
        Object ob = oid2SigAlgName.get(algOid);
        if (null == ob) {
            throw new PkiException("11007009\u7b97\u6cd5\u6807\u8bc6OID\u8f6c\u6362\u4e3a\u7b97\u6cd5\u540d\u79f0\u5931\u8d25 \u6570\u636e\u8f6c\u6362\u4e0d\u652f\u6301 " + algOid.getId());
        }
        return (String)ob;
    }

    public static boolean checkSymmFPEAlg(String policyType) {
        return policyType.equals(SM1_FPE) || policyType.equals(AES_FPE) || policyType.equals(SM4_FPE) || policyType.equals(SSF33_FPE);
    }

    public static boolean checkSymmEncDecAlg(String policyType) {
        boolean ret = true;
        if (!(policyType.equals(SM4_ECB_PKCS5PADDING) || policyType.equals(SM4_CBC_PKCS5PADDING) || policyType.equals(SM4_ECB_PKCS7PADDING) || policyType.equals(SM4_CBC_PKCS7PADDING) || policyType.equals(SM4_CBC_NOPADDING) || policyType.equals(SM4_ECB_NOPADDING) || policyType.equals(SM4_GCM_NOPADDING) || policyType.equals(SM4_CCM_NOPADDING) || policyType.equals(SM4_CTR_NOPADDING) || policyType.equals(SM4_OFB_NOPADDING) || policyType.equals(SM4_CFB_NOPADDING) || policyType.equals(DES3_CBC_PKCS5PADDING) || policyType.equals(DES3_ECB_PKCS5PADDING) || policyType.equals(DES3_CBC_PKCS7PADDING) || policyType.equals(DES3_ECB_PKCS7PADDING) || policyType.equals(DES3_CBC_NOPADDING) || policyType.equals(DES3_ECB_NOPADDING) || policyType.equals(DES3_OFB_NOPADDING) || policyType.equals(DES3_CFB_NOPADDING) || policyType.equals(AES_ECB_PKCS5PADDING) || policyType.equals(AES_CBC_PKCS5PADDING) || policyType.equals(AES_ECB_PKCS7PADDING) || policyType.equals(AES_CBC_PKCS7PADDING) || policyType.equals(AES_ECB_NOPADDING) || policyType.equals(AES_GCM_NOPADDING) || policyType.equals(AES_CCM_NOPADDING) || policyType.equals(AES_CBC_NOPADDING) || policyType.equals(AES_CTR_NOPADDING) || policyType.equals(AES_OFB_NOPADDING) || policyType.equals(AES_CFB_NOPADDING) || policyType.equals(ZUC_EEA3_NOPADDING))) {
            ret = false;
        }
        return ret;
    }

    public static boolean checkEnvelopSymmEncDecAlg(String policyType) {
        boolean ret = true;
        if (!(policyType.equals(SM4_ECB_PKCS5PADDING) || policyType.equals(SM4_CBC_PKCS5PADDING) || policyType.equals(DES3_CBC_PKCS5PADDING))) {
            ret = false;
        }
        return ret;
    }

    public static boolean checkAsymEncDecAlg(String policyType) {
        boolean ret = true;
        if (!policyType.equals(RSA_PKCS) && !policyType.equals(SM2)) {
            ret = false;
        }
        return ret;
    }

    private static void initRsaAlgs() {
        rsaHashAlgs.add(SHA1);
        rsaHashAlgs.add(SHA224);
        rsaHashAlgs.add(SHA256);
        rsaHashAlgs.add(SHA384);
        rsaHashAlgs.add(SHA512);
        rsaSignAlgs.add(SHA1_WITH_RSA);
        rsaSignAlgs.add(SHA224_WITH_RSA);
        rsaSignAlgs.add(SHA256_WITH_RSA);
        rsaSignAlgs.add(SHA384_WITH_RSA);
        rsaSignAlgs.add(SHA512_WITH_RSA);
    }

    private static void initSm2Algs() {
        sm2HashAlgs.add(SM3);
        sm2SignAlgs.add(SM3_WITH_SM2);
    }

    private static void initAlgs() {
        hashAlgs.addAll(sm2HashAlgs);
        hashAlgs.addAll(rsaHashAlgs);
        signAlgs.addAll(sm2SignAlgs);
        signAlgs.addAll(rsaSignAlgs);
    }

    static {
        algMap.put(RSA_PKCS, 65536);
        algMap.put(RSA, 65536);
        algMap.put(SM2, 131328);
        algMap.put(ED25519, SGD_ED25519);
        algMap.put(SM9_SIGN, 262656);
        algMap.put(SM9_EXCHANGE, 263168);
        algMap.put(SM9_ENCRYPT, 264192);
        algMap.put(SM3, 1);
        algMap.put(SHA1, 2);
        algMap.put(SHA256, 4);
        algMap.put(SHA224, 8);
        algMap.put(SHA384, 16);
        algMap.put(SHA512, 32);
        algMap.put(SHA1_WITH_RSA, 65538);
        algMap.put(SHA256_WITH_RSA, 65540);
        algMap.put(SM3_WITH_SM2, 131585);
        algMap.put(SM3_WITH_SM9, 262657);
        algMap.put(SHA224_WITH_RSA, 65544);
        algMap.put(SHA384_WITH_RSA, 65552);
        algMap.put(SHA512_WITH_RSA, 65568);
        algMap.put(SM4, 1026);
        algMap.put(AES, 268436482);
        algMap.put(DES3, 268437506);
        algMap.put(ZUC, 2049);
        algMap.put(SM4_ECB_NOPADDING, 1025);
        algMap.put(SM4_CBC_NOPADDING, 1026);
        algMap.put(SM4_GCM_NOPADDING, 0x2000400);
        algMap.put(SM4_CCM_NOPADDING, 0x4000400);
        algMap.put(SM4_CTR_NOPADDING, 1056);
        algMap.put(SM4_OFB_NOPADDING, 1032);
        algMap.put(SM4_CFB_NOPADDING, 1028);
        algMap.put(SM4_ECB_PKCS5PADDING, 1025);
        algMap.put(SM4_CBC_PKCS5PADDING, 1026);
        algMap.put(SM4_ECB_PKCS7PADDING, 1025);
        algMap.put(SM4_CBC_PKCS7PADDING, 1026);
        algMap.put(AES_CBC_NOPADDING, 268436482);
        algMap.put(AES_ECB_NOPADDING, 0x10000401);
        algMap.put(AES_GCM_NOPADDING, 301990912);
        algMap.put(AES_CCM_NOPADDING, 0x14000400);
        algMap.put(AES_CTR_NOPADDING, 268436512);
        algMap.put(AES_OFB_NOPADDING, 268436488);
        algMap.put(AES_CFB_NOPADDING, 0x10000404);
        algMap.put(AES_CBC_PKCS5PADDING, 268436482);
        algMap.put(AES_ECB_PKCS5PADDING, 0x10000401);
        algMap.put(AES_CBC_PKCS7PADDING, 268436482);
        algMap.put(AES_ECB_PKCS7PADDING, 0x10000401);
        algMap.put(DES3_ECB_NOPADDING, 0x10000801);
        algMap.put(DES3_CBC_NOPADDING, 268437506);
        algMap.put(DES3_OFB_NOPADDING, 0x10000808);
        algMap.put(DES3_CFB_NOPADDING, 268437508);
        algMap.put(DES3_ECB_PKCS5PADDING, 0x10000801);
        algMap.put(DES3_CBC_PKCS5PADDING, 268437506);
        algMap.put(DES3_ECB_PKCS7PADDING, 0x10000801);
        algMap.put(DES3_CBC_PKCS7PADDING, 268437506);
        algMap.put(ZUC_EEA3_NOPADDING, 2049);
        algMap.put(HMAC_SM3, 1);
        algMap.put(HMAC_SHA1, 2);
        algMap.put(HMAC_SHA256, 4);
        algMap.put(SM1_FPE, 0x8000100);
        algMap.put(SSF33_FPE, 0x8000200);
        algMap.put(SM4_FPE, 0x8000400);
        algMap.put(AES_FPE, 402654208);
        paddingMap.put(SM4_ECB_NOPADDING, 0);
        paddingMap.put(SM4_CBC_NOPADDING, 0);
        paddingMap.put(SM4_GCM_NOPADDING, 0);
        paddingMap.put(SM4_CCM_NOPADDING, 0);
        paddingMap.put(SM4_CTR_NOPADDING, 0);
        paddingMap.put(SM4_OFB_NOPADDING, 0);
        paddingMap.put(SM4_CFB_NOPADDING, 0);
        paddingMap.put(SM4_ECB_PKCS5PADDING, 1);
        paddingMap.put(SM4_CBC_PKCS5PADDING, 1);
        paddingMap.put(SM4_ECB_PKCS7PADDING, 2);
        paddingMap.put(SM4_CBC_PKCS7PADDING, 2);
        paddingMap.put(AES_CBC_NOPADDING, 0);
        paddingMap.put(AES_ECB_NOPADDING, 0);
        paddingMap.put(AES_GCM_NOPADDING, 0);
        paddingMap.put(AES_CCM_NOPADDING, 0);
        paddingMap.put(AES_CTR_NOPADDING, 0);
        paddingMap.put(AES_OFB_NOPADDING, 0);
        paddingMap.put(AES_CFB_NOPADDING, 0);
        paddingMap.put(AES_CBC_PKCS5PADDING, 1);
        paddingMap.put(AES_ECB_PKCS5PADDING, 1);
        paddingMap.put(AES_CBC_PKCS7PADDING, 2);
        paddingMap.put(AES_ECB_PKCS7PADDING, 2);
        paddingMap.put(DES3_ECB_NOPADDING, 0);
        paddingMap.put(DES3_CBC_NOPADDING, 0);
        paddingMap.put(DES3_OFB_NOPADDING, 0);
        paddingMap.put(DES3_CFB_NOPADDING, 0);
        paddingMap.put(DES3_ECB_PKCS5PADDING, 1);
        paddingMap.put(DES3_CBC_PKCS5PADDING, 1);
        paddingMap.put(DES3_ECB_PKCS7PADDING, 2);
        paddingMap.put(DES3_CBC_PKCS7PADDING, 2);
        paddingMap.put(ZUC_EEA3_NOPADDING, 0);
        paddingMap.put(PKCS7_PADDING, 2);
        paddingMap.put(PKCS5_PADDING, 1);
        paddingMap.put(NO_PADDING, 0);
        sigAlgName2OID.put(SHA1_WITH_RSA, PKCSObjectIdentifiers.sha1WithRSAEncryption);
        sigAlgName2OID.put(SHA256_WITH_RSA, PKCSObjectIdentifiers.sha256WithRSAEncryption);
        sigAlgName2OID.put(SM3_WITH_SM2, GMObjectIdentifiers.sm2sign_with_sm3);
        sigAlgName2OID.put(SHA1, OIWObjectIdentifiers.idSHA1);
        sigAlgName2OID.put(SHA256, NISTObjectIdentifiers.id_sha256);
        sigAlgName2OID.put(SM3, GMObjectIdentifiers.sm3);
        sigAlgName2OID.put(SM4_ECB_PKCS5PADDING, GMObjectIdentifiers.sms4_ecb);
        sigAlgName2OID.put(SM4_CBC_PKCS5PADDING, GMObjectIdentifiers.sms4_cbc);
        sigAlgName2OID.put(SM2, GMObjectIdentifiers.sm2encrypt);
        sigAlgName2OID.put(RSA_PKCS, PKCSObjectIdentifiers.rsaEncryption);
        sigAlgName2OID.put(DES3_CBC_PKCS5PADDING, PKCSObjectIdentifiers.des_EDE3_CBC);
        oid2SigAlgName.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, SHA1_WITH_RSA);
        oid2SigAlgName.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, SHA256_WITH_RSA);
        oid2SigAlgName.put(GMObjectIdentifiers.sm2sign_with_sm3, SM3_WITH_SM2);
        oid2SigAlgName.put(OIWObjectIdentifiers.idSHA1, SHA1);
        oid2SigAlgName.put(NISTObjectIdentifiers.id_sha256, SHA256);
        oid2SigAlgName.put(GMObjectIdentifiers.sm3, SM3);
        oid2SigAlgName.put(new ASN1ObjectIdentifier("1.2.156.10197.1.401.1"), SM3);
        oid2SigAlgName.put(GMObjectIdentifiers.hmac_sm3, HMAC_SM3);
        oid2SigAlgName.put(GMObjectIdentifiers.sms4_ecb, SM4_ECB_PKCS5PADDING);
        oid2SigAlgName.put(GMObjectIdentifiers.sms4_cbc, SM4_CBC_PKCS5PADDING);
        oid2SigAlgName.put(new ASN1ObjectIdentifier("1.2.156.10197.1.104"), SM4_CBC_PKCS5PADDING);
        oid2SigAlgName.put(GMObjectIdentifiers.sm2encrypt, SM2);
        oid2SigAlgName.put(PKCSObjectIdentifiers.rsaEncryption, RSA_PKCS);
        oid2SigAlgName.put(PKCSObjectIdentifiers.des_EDE3_CBC, DES3_CBC_PKCS5PADDING);
        AlgConstant.initRsaAlgs();
        AlgConstant.initSm2Algs();
        AlgConstant.initAlgs();
    }
}

