/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.extension;

import cn.org.bjca.gaia.asn1.ASN1Boolean;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.DERIA5String;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERPrintableString;
import cn.org.bjca.gaia.asn1.DERUTF8String;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.extension.Extension;
import cn.org.bjca.gaia.util.encoders.Base64;
import cn.org.bjca.gaia.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class SelfDefExtension
implements Extension {
    public static final String PRINTABLESTRING = "Printable String";
    public static final String UTF8STRING = "UTF-8 String";
    public static final String USERDEFINED = "User Defined";
    public static final String INTEGER = "Integer";
    public static final String BOOLEAN = "Boolean";
    public static final String IA5STRING = "IA5 String";
    private String encodeType = null;
    private String extensionValue = null;
    private String OID = null;
    private boolean critical = false;

    public SelfDefExtension() {
    }

    public SelfDefExtension(String oid, byte[] extValue) throws PkiException {
        this.OID = oid;
        ASN1Primitive derObj = null;
        try {
            switch (extValue[0]) {
                case 1: {
                    this.encodeType = BOOLEAN;
                    derObj = this.byteToDERObject(extValue);
                    if (((ASN1Boolean)derObj).isTrue()) {
                        this.extensionValue = "true";
                        break;
                    }
                    this.extensionValue = "false";
                    break;
                }
                case 22: {
                    this.encodeType = IA5STRING;
                    derObj = this.byteToDERObject(extValue);
                    this.extensionValue = ((DERIA5String)derObj).getString();
                    break;
                }
                case 2: {
                    this.encodeType = INTEGER;
                    derObj = this.byteToDERObject(extValue);
                    this.extensionValue = String.valueOf(((ASN1Integer)derObj).getValue().longValue());
                    break;
                }
                case 19: {
                    this.encodeType = PRINTABLESTRING;
                    derObj = this.byteToDERObject(extValue);
                    this.extensionValue = ((DERPrintableString)derObj).getString();
                    break;
                }
                case 12: {
                    this.encodeType = UTF8STRING;
                    derObj = this.byteToDERObject(extValue);
                    this.extensionValue = ((DERUTF8String)derObj).getString();
                    break;
                }
                default: {
                    this.encodeType = USERDEFINED;
                    derObj = new DEROctetString(extValue);
                    byte[] octets = ((DEROctetString)derObj).getOctets();
                    this.extensionValue = Hex.toHexString(octets);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new PkiException("11020027", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25", e);
        }
    }

    public void setEncodeType(String encodeType) throws PkiException {
        if (encodeType == null || encodeType.equals("")) {
            throw new PkiException("11020025", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25,\u7f16\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.encodeType = encodeType;
    }

    public String getEncodeType() {
        return this.encodeType;
    }

    public void setOID(String oid) throws PkiException {
        if (oid == null || oid.equals("")) {
            throw new PkiException("11020014", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25\uff0c\u6269\u5c55\u57dfOID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.OID = oid;
    }

    @Override
    public String getOID() {
        return this.OID;
    }

    @Override
    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    @Override
    public boolean getCritical() {
        return this.critical;
    }

    public void setExtensionValue(String value) throws PkiException {
        if (value == null || value.equals("")) {
            throw new PkiException("11020026", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25,\u6269\u5c55\u57df\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.extensionValue = value;
    }

    public String getExtensionValue() {
        return this.extensionValue;
    }

    @Override
    public byte[] encode() throws PkiException {
        if (this.encodeType == null) {
            throw new PkiException("11020001", "\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7f16\u7801\u7c7b\u578b\u4e3a\u7a7a");
        }
        byte[] value = null;
        try {
            if (this.encodeType.equals(BOOLEAN)) {
                ASN1Boolean derBoolean = new ASN1Boolean(Boolean.valueOf(this.extensionValue));
                DEROctetString octetValue = new DEROctetString(derBoolean.toASN1Primitive());
                value = octetValue.getOctets();
                return value;
            }
            if (this.encodeType.equals(IA5STRING)) {
                DERIA5String ia5String = new DERIA5String(this.extensionValue);
                DEROctetString octetValue = new DEROctetString(ia5String.toASN1Primitive());
                value = octetValue.getOctets();
                return value;
            }
            if (this.encodeType.equals(INTEGER)) {
                ASN1Integer derInteger = new ASN1Integer(new BigInteger(this.extensionValue));
                DEROctetString octetValue = new DEROctetString(derInteger.toASN1Primitive());
                value = octetValue.getOctets();
                return value;
            }
            if (this.encodeType.equals(PRINTABLESTRING)) {
                DERPrintableString derPrintString = new DERPrintableString(this.extensionValue);
                DEROctetString octetValue = new DEROctetString(derPrintString.toASN1Primitive());
                value = octetValue.getOctets();
                return value;
            }
            if (this.encodeType.equals(USERDEFINED)) {
                DEROctetString octetValue = new DEROctetString(Base64.decode(this.extensionValue));
                value = octetValue.getOctets();
                return value;
            }
            if (this.encodeType.equals(UTF8STRING)) {
                DERUTF8String derUTF8String = new DERUTF8String(this.extensionValue);
                DEROctetString octetValue = new DEROctetString(derUTF8String.toASN1Primitive());
                value = octetValue.getOctets();
                return value;
            }
            throw new PkiException("11020002", "\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7f16\u7801\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        catch (IOException e) {
            throw new PkiException("11020027", "\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25");
        }
    }

    private ASN1Primitive byteToDERObject(byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream derIns = new ASN1InputStream(bis);
        return derIns.readObject();
    }
}

