/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.generator;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERGeneralizedTime;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DERSet;
import cn.org.bjca.gaia.asn1.DERTaggedObject;
import cn.org.bjca.gaia.asn1.DERUTCTime;
import cn.org.bjca.gaia.asn1.gm.GMObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.IssuerAndSerialNumber;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.asn1.x509.X509Name;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.tsp.TimeStampRequest;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;

public class TsGenerator {
    private int version;
    private int signerVersion = 1;
    private ASN1ObjectIdentifier originalDataDigestAlg;
    private ASN1ObjectIdentifier p7SignAlgOid;
    private Collection certs = new ArrayList();
    private Collection crls = new ArrayList();
    private Certificate signCert;
    private boolean isAttachServerCert = true;
    private Date signDate = null;
    private ASN1ObjectIdentifier digestEncryptionAlgorithm;
    private byte[] timeStampInfo = null;
    private DERSet tobeSignedOriginalSet = null;

    public byte[] getTimeStampInfo() {
        return this.timeStampInfo;
    }

    public TsGenerator(TimeStampRequest tsReq, Certificate[] certChain) throws Exception {
        this.originalDataDigestAlg = tsReq.getMessageImprintAlgOID();
        if (this.originalDataDigestAlg.getId().equals(GMObjectIdentifiers.sm3.getId()) || "1.2.156.10197.1.401.1".equals(this.originalDataDigestAlg.getId())) {
            this.digestEncryptionAlgorithm = GMObjectIdentifiers.sm2sign;
            this.p7SignAlgOid = GMObjectIdentifiers.OID_CN_SM2_P7_SignedData;
            this.version = 1;
        } else {
            this.digestEncryptionAlgorithm = PKCSObjectIdentifiers.rsaEncryption;
            this.p7SignAlgOid = PKCSObjectIdentifiers.signedData;
            this.version = 3;
        }
        this.signCert = certChain[0];
        for (int i = 0; i < certChain.length; ++i) {
            this.certs.add(certChain[i]);
        }
        this.isAttachServerCert = tsReq.getCertReq();
        BigInteger serialNum = new BigInteger("100000001");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        TimeZone tz = TimeZone.getTimeZone("Zulu");
        dateformat.setTimeZone(tz);
        this.signDate = new Date();
        String nowTime = dateformat.format(this.signDate);
        ASN1EncodableVector tstInfoV = new ASN1EncodableVector();
        ASN1Integer tstVersion = new ASN1Integer(1L);
        ASN1ObjectIdentifier tsaPolicyId = AlgConstant.TSA_POLICY_ID;
        ASN1EncodableVector msImprintOidV = new ASN1EncodableVector();
        msImprintOidV.add(tsReq.getMessageImprintAlgOID());
        DERSequence msImprintOidSeq = new DERSequence(msImprintOidV);
        ASN1EncodableVector msImprintV = new ASN1EncodableVector();
        msImprintV.add(msImprintOidSeq);
        DEROctetString digest = new DEROctetString(tsReq.getMessageImprintDigest());
        msImprintV.add(digest);
        DERSequence msImprintSeq = new DERSequence(msImprintV);
        ASN1Integer serialNumInt = new ASN1Integer(serialNum);
        DERGeneralizedTime generalizedTime = new DERGeneralizedTime(nowTime);
        tstInfoV.add(tstVersion);
        tstInfoV.add(tsaPolicyId);
        tstInfoV.add(msImprintSeq);
        tstInfoV.add(serialNumInt);
        tstInfoV.add(generalizedTime);
        if (tsReq.getNonce() != null) {
            tstInfoV.add(new ASN1Integer(tsReq.getNonce()));
        }
        DERSequence timeStampOriginalDataSequence = new DERSequence(tstInfoV);
        this.timeStampInfo = timeStampOriginalDataSequence.getEncoded();
    }

    public byte[] assembAttr(byte[] tsInfoDigest, byte[] certDigest) throws Exception {
        ASN1EncodableVector contentinfo1V = new ASN1EncodableVector();
        ASN1ObjectIdentifier contentTypeIden = PKCSObjectIdentifiers.pkcs_9_at_contentType;
        ASN1ObjectIdentifier tstInfoIden = PKCSObjectIdentifiers.id_ct_TSTInfo;
        ASN1EncodableVector tstInfoV = new ASN1EncodableVector();
        tstInfoV.add(tstInfoIden);
        DERSet tstInfoSet = new DERSet(tstInfoV);
        contentinfo1V.add(contentTypeIden);
        contentinfo1V.add(tstInfoSet);
        DERSequence contentinfo1 = new DERSequence(contentinfo1V);
        ASN1EncodableVector contentinfo2V = new ASN1EncodableVector();
        ASN1ObjectIdentifier signingTimeIden = PKCSObjectIdentifiers.pkcs_9_at_signingTime;
        ASN1EncodableVector utcTimeV = new ASN1EncodableVector();
        DERUTCTime utcTime = new DERUTCTime(this.signDate);
        utcTimeV.add(utcTime);
        DERSet utcTimeSet = new DERSet(utcTimeV);
        contentinfo2V.add(signingTimeIden);
        contentinfo2V.add(utcTimeSet);
        DERSequence contentinfo2 = new DERSequence(contentinfo2V);
        ASN1EncodableVector contentinfo3V = new ASN1EncodableVector();
        ASN1ObjectIdentifier tsDigestIden = PKCSObjectIdentifiers.pkcs_9_at_messageDigest;
        ASN1EncodableVector digestSetV = new ASN1EncodableVector();
        DEROctetString tsInfoDigestStr = new DEROctetString(tsInfoDigest);
        digestSetV.add(tsInfoDigestStr);
        DERSet digestSet = new DERSet(digestSetV);
        contentinfo3V.add(tsDigestIden);
        contentinfo3V.add(digestSet);
        DERSequence contentinfo3 = new DERSequence(contentinfo3V);
        ASN1EncodableVector contentinfo4V = new ASN1EncodableVector();
        ASN1ObjectIdentifier signingCertificateSn = PKCSObjectIdentifiers.id_aa_signingCertificate;
        ASN1EncodableVector snV = new ASN1EncodableVector();
        DEROctetString snOct = new DEROctetString(certDigest);
        snV.add(snOct);
        DERSequence derSequence = new DERSequence(snV);
        DERSequence derSequence1 = new DERSequence(derSequence);
        DERSequence derSequence2 = new DERSequence(derSequence1);
        DERSet snSet = new DERSet(derSequence2);
        contentinfo4V.add(signingCertificateSn);
        contentinfo4V.add(snSet);
        DERSequence contentinfo4 = new DERSequence(contentinfo4V);
        ASN1EncodableVector tobeSignedOriginalSetV = new ASN1EncodableVector();
        tobeSignedOriginalSetV.add(contentinfo1);
        tobeSignedOriginalSetV.add(contentinfo2);
        tobeSignedOriginalSetV.add(contentinfo3);
        tobeSignedOriginalSetV.add(contentinfo4);
        this.tobeSignedOriginalSet = new DERSet(tobeSignedOriginalSetV);
        return this.tobeSignedOriginalSet.getEncoded();
    }

    public byte[] getEncoded(byte[] signValue) throws Exception {
        ASN1EncodableVector signerinfoV = new ASN1EncodableVector();
        signerinfoV.add(new ASN1Integer(this.signerVersion));
        byte[] bsIssuer = this.signCert.getIssuer().getEncoded();
        ASN1InputStream ans = new ASN1InputStream(bsIssuer);
        ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
        IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), this.signCert.getSerialNumber());
        signerinfoV.add(isAnds);
        AlgorithmIdentifier originalDataDigestAlgOid = new AlgorithmIdentifier(this.originalDataDigestAlg, DERNull.INSTANCE);
        signerinfoV.add(originalDataDigestAlgOid);
        byte[] tobeWriteOrigianlDataByte = this.tobeSignedOriginalSet.getEncoded();
        tobeWriteOrigianlDataByte[0] = -96;
        ByteArrayInputStream tobeWriteArrayIn = new ByteArrayInputStream(tobeWriteOrigianlDataByte);
        ASN1InputStream tobeWriteIn = new ASN1InputStream(tobeWriteArrayIn);
        ASN1Primitive tobeWriteDer = tobeWriteIn.readObject();
        signerinfoV.add(tobeWriteDer);
        AlgorithmIdentifier digestEncryptionAlgOid = new AlgorithmIdentifier(this.digestEncryptionAlgorithm, DERNull.INSTANCE);
        signerinfoV.add(digestEncryptionAlgOid);
        DEROctetString signValueOct = new DEROctetString(signValue);
        signerinfoV.add(signValueOct);
        DERSequence signInfo = new DERSequence(signerinfoV);
        ASN1EncodableVector bodyV = new ASN1EncodableVector();
        bodyV.add(new ASN1Integer(this.version));
        ASN1EncodableVector digestSetV = new ASN1EncodableVector();
        AlgorithmIdentifier digestAlgOid = new AlgorithmIdentifier(this.originalDataDigestAlg, DERNull.INSTANCE);
        digestSetV.add(digestAlgOid);
        DERSet digestSet = new DERSet(digestSetV);
        bodyV.add(digestSet);
        ASN1EncodableVector contentInfoV = new ASN1EncodableVector();
        contentInfoV.add(PKCSObjectIdentifiers.id_ct_TSTInfo);
        DEROctetString octets = new DEROctetString(this.timeStampInfo);
        DERTaggedObject tagged = new DERTaggedObject(0, octets);
        contentInfoV.add(tagged);
        DERSequence contentInfo = new DERSequence(contentInfoV);
        bodyV.add(contentInfo);
        if (this.isAttachServerCert) {
            ASN1EncodableVector dercertificatesV = new ASN1EncodableVector();
            for (Certificate tempCert : this.certs) {
                dercertificatesV.add(tempCert);
            }
            DERSet dercertificates = new DERSet(dercertificatesV);
            bodyV.add(new DERTaggedObject(false, 0, dercertificates));
        }
        ASN1EncodableVector signerinfosV = new ASN1EncodableVector();
        signerinfosV.add(signInfo);
        DERSet signerinfos = new DERSet(signerinfosV);
        bodyV.add(signerinfos);
        DERSequence body = new DERSequence(bodyV);
        ASN1EncodableVector wholeV = new ASN1EncodableVector();
        wholeV.add(this.p7SignAlgOid);
        wholeV.add(new DERTaggedObject(0, body));
        DERSequence whole = new DERSequence(wholeV);
        return whole.getEncoded();
    }
}

