/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteArrayUtil {
    private ByteArrayUtil() {
    }

    public static byte[] intToByte(int inData) {
        ByteBuffer byteBuf = ByteBuffer.allocate(4);
        byteBuf.putInt(inData);
        byte[] outData = byteBuf.array();
        return outData;
    }

    public static int getFirstIntFromByteArray(byte[] buffer, int offset) {
        int num = 0;
        for (int i = 0; i < 4; ++i) {
            num = (int)((long)num + ((0xFFL & (long)buffer[i + offset]) << i * 8));
        }
        return num;
    }

    public static int byteToInt(byte[] inData) {
        ByteBuffer byteBuf = ByteBuffer.allocate(4);
        byteBuf.put(inData);
        int outData = byteBuf.getInt(0);
        return outData;
    }

    public static byte[] bigInteger2ByteArray(BigInteger b) {
        if (b == null) {
            return new byte[0];
        }
        byte[] array = b.toByteArray();
        return array;
    }

    public static byte[] bigInteger2ByteArray(BigInteger b, int size) {
        if (b == null) {
            return new byte[0];
        }
        byte[] array = b.toByteArray();
        byte[] retarray = new byte[size];
        if (array.length > size) {
            System.arraycopy(array, array.length - size, retarray, 0, size);
            return retarray;
        }
        if (array.length < size) {
            System.arraycopy(array, 0, retarray, size - array.length, array.length);
            return retarray;
        }
        return array;
    }

    public static BigInteger byteArray2BigInteger(byte[] array) {
        if (array == null || array.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(1, array);
    }

    public static boolean equalValue(byte[] r1, byte[] r2) {
        if (r1 == null && r2 != null) {
            return false;
        }
        if (r1 != null && r2 == null) {
            return false;
        }
        BigInteger b1 = ByteArrayUtil.byteArray2BigInteger(r1);
        BigInteger b2 = ByteArrayUtil.byteArray2BigInteger(r2);
        return b1.equals(b2);
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public static boolean isEqual(byte[] source, byte[] goal) {
        if (source == null && goal == null) {
            return true;
        }
        return ByteArrayUtil.equalValue(source, goal);
    }

    public static byte[] mergeBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }

    public static byte[][] splitBytes(byte[] bytes, int tagLen) {
        byte[][] result = new byte[][]{Arrays.copyOfRange(bytes, 0, bytes.length - tagLen), Arrays.copyOfRange(bytes, bytes.length - tagLen, bytes.length)};
        return result;
    }
}

