/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class CRLUtil {
    public static boolean verifyCertFromCrl(byte[] crlBytes, byte[] certBytes) throws PkiException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BJCAJE");
            CRL crl = factory.generateCRL(new ASN1InputStream(crlBytes));
            Certificate certificate = factory.generateCertificate(new ASN1InputStream(certBytes));
            return crl.isRevoked(certificate);
        }
        catch (Exception e) {
            throw new PkiException("11023001", "\u89e3\u6790CRL\u5931\u8d25", e);
        }
    }

    public static boolean verifyCertFromCrl(InputStream in, byte[] certBytes) throws PkiException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BJCAJE");
            CRL crl = factory.generateCRL(in);
            Certificate certificate = factory.generateCertificate(new ASN1InputStream(certBytes));
            return crl.isRevoked(certificate);
        }
        catch (Exception e) {
            throw new PkiException("11023001", "\u89e3\u6790CRL\u5931\u8d25", e);
        }
    }
}

