/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.x9.ECNamedCurveTable;
import cn.org.bjca.gaia.asn1.x9.X9ECParameters;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.BjcaKeyPair;
import cn.org.bjca.gaia.assemb.param.IVParam;
import cn.org.bjca.gaia.assemb.util.ByteArrayUtil;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import cn.org.bjca.gaia.math.ec.ECCurve;
import cn.org.bjca.gaia.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.NumberFormat;

public class CollaborateUtil {
    private final GaiaProvider provider;
    private final AlgPolicy SM4_CBC_PKCS5PADDING;
    private final BigInteger x9N;
    private final ECCurve curve;

    public CollaborateUtil(GaiaProvider provider) {
        this.provider = provider;
        IVParam ivParam = new IVParam();
        ivParam.setIv(new byte[]{15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0});
        this.SM4_CBC_PKCS5PADDING = new AlgPolicy("SM4/CBC/PKCS5Padding", ivParam);
        X9ECParameters x9ECParameters = ECNamedCurveTable.getByName("sm2p256v1");
        this.x9N = x9ECParameters.getN();
        this.curve = x9ECParameters.getCurve();
    }

    public byte[][] genRSAKeyPair(int keySize, byte[] random) throws PkiException {
        BjcaKeyPair bjcaKeyPair = this.provider.genKeyPair(new AlgPolicy("RSA"), keySize);
        byte[] pub = bjcaKeyPair.getPublicKey().getKey();
        PrivateKey privateKey = KeyPairUtil.convertPrivateKey(bjcaKeyPair.getPrivateKey());
        BCRSAPrivateCrtKey bcRsaPrivateCrtKey = (BCRSAPrivateCrtKey)privateKey;
        BigInteger d = bcRsaPrivateCrtKey.getPrivateExponent();
        if (!ByteArrayUtil.isEmpty(random)) {
            d = d.subtract(ByteArrayUtil.byteArray2BigInteger(random));
        }
        return new byte[][]{ByteArrayUtil.bigInteger2ByteArray(d, keySize >> 3), pub};
    }

    public byte[] sha256Hash(byte[] data) throws PkiException {
        return this.provider.hash(new AlgPolicy("SHA256"), data);
    }

    public byte[] sha1Hash(byte[] data) throws PkiException {
        return this.provider.hash(new AlgPolicy("SHA1"), data);
    }

    public String genOTP(byte[] rand) throws PkiException {
        byte[] hash = this.sha1Hash(rand);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumIntegerDigits(6);
        nf.setGroupingUsed(false);
        return nf.format(binary %= 1000000);
    }

    public byte[] decryptByOTP(byte[] otp, byte[] encData, BjcaKey pri) throws PkiException {
        byte[] decData = this.provider.decrypt(new AlgPolicy("SM2"), pri, encData);
        byte[] otpHash = this.sha1Hash(otp);
        byte[] key = new byte[16];
        System.arraycopy(otpHash, 0, key, 0, 16);
        BjcaKey otpKey = new BjcaKey("SM4", key);
        byte[] d = this.sm4Decrypt(otpKey, decData);
        byte[] cHash = new byte[20];
        System.arraycopy(d, 0, cHash, 0, cHash.length);
        byte[] data = new byte[d.length - cHash.length];
        System.arraycopy(d, cHash.length, data, 0, data.length);
        byte[] dHash = this.sha1Hash(data);
        if (!ByteArrayUtil.isEqual(cHash, dHash)) {
            throw new PkiException("otp not match");
        }
        return data;
    }

    public PublicKey point2PublicKey(ECPoint pubPoint) {
        BigInteger x = pubPoint.getAffineXCoord().toBigInteger();
        BigInteger y = pubPoint.getAffineYCoord().toBigInteger();
        return KeyPairUtil.getPublickeyFromXY(x, y);
    }

    public byte[] generateSM2PublicKeyPoint(byte[] d) {
        byte[] x9NBytes = this.x9N.toByteArray();
        byte[] k = this.provider.bigIntegerModInverse(d, x9NBytes);
        return this.provider.SM2PointMul(null, k);
    }

    public byte[][] serverSemSign(byte[] q1, byte[] clientPri, byte[] textHash) throws PkiException {
        byte[] K2Bytes = this.provider.generateRangeRandom(null);
        byte[] K3Bytes = this.provider.generateRangeRandom(null);
        byte[] kq = this.provider.SM2PointMul(q1, K2Bytes);
        byte[] kg = this.provider.SM2PointMul(null, K3Bytes);
        byte[] qBytes = this.provider.SM2PointAdd(kq, kg);
        ECPoint q = this.pack2Point(qBytes);
        BigInteger x1 = q.getAffineXCoord().toBigInteger();
        byte[] r = this.bigIntegerModAdd(x1.toByteArray(), textHash, this.x9N.toByteArray());
        byte[] s2 = this.bigIntegerModMul(clientPri, K2Bytes, this.x9N.toByteArray());
        BigInteger k3 = ByteArrayUtil.byteArray2BigInteger(K3Bytes);
        BigInteger rb = ByteArrayUtil.byteArray2BigInteger(r);
        byte[] s3 = this.bigIntegerModMul(clientPri, rb.add(k3).toByteArray(), this.x9N.toByteArray());
        return new byte[][]{r, s2, s3};
    }

    private byte[] bigIntegerModMul(byte[] a, byte[] b, byte[] m) {
        BigInteger dc = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger k2 = ByteArrayUtil.byteArray2BigInteger(b);
        BigInteger x9N = ByteArrayUtil.byteArray2BigInteger(m);
        return dc.multiply(k2).mod(x9N).toByteArray();
    }

    public byte[] clientSemSign(byte[] signDataR, byte[] signDataRS2, byte[] signDataRS3, byte[] priDs, byte[] priK1) throws PkiException {
        return this.provider.SemServerSM2SignFinal(priDs, priK1, signDataR, signDataRS2, signDataRS3);
    }

    private byte[] bigIntegerModSub(byte[] a, byte[] b, byte[] m) {
        BigInteger a1 = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger r = ByteArrayUtil.byteArray2BigInteger(b);
        BigInteger x9N = ByteArrayUtil.byteArray2BigInteger(m);
        BigInteger s = a1.subtract(r).mod(x9N);
        return s.toByteArray();
    }

    private byte[] bigIntegerModAdd(byte[] a, byte[] b, byte[] m) {
        BigInteger x1 = ByteArrayUtil.byteArray2BigInteger(a);
        BigInteger e = ByteArrayUtil.byteArray2BigInteger(b);
        BigInteger x9N = ByteArrayUtil.byteArray2BigInteger(m);
        BigInteger r = x1.add(e).mod(x9N);
        return r.toByteArray();
    }

    public byte[] generateSM2PublicKey2(byte[] dsem, byte[] clientP) {
        return this.provider.SemServerGenerateSM2Key(dsem, clientP);
    }

    public ECPoint pack2Point(byte[] data) {
        return this.curve.decodePoint(data);
    }

    public BigInteger genRandom(int bytes) {
        byte[] random;
        if (bytes == 32) {
            random = this.provider.generateRangeRandom(null);
        } else {
            byte[] maxRange = new byte[bytes];
            for (int i = 0; i < bytes; ++i) {
                maxRange[i] = 127;
            }
            random = this.provider.generateRangeRandom(maxRange);
        }
        return ByteArrayUtil.byteArray2BigInteger(random);
    }

    public byte[] calckG(byte[] k) {
        return this.provider.SM2PointMul(null, k);
    }

    public byte[] sm4Decrypt(BjcaKey bjcaKey, byte[] data) throws PkiException {
        return this.provider.decrypt(this.SM4_CBC_PKCS5PADDING, bjcaKey, data);
    }

    public byte[] sm4Encrypt(BjcaKey bjcaKey, byte[] data) throws PkiException {
        return this.provider.encrypt(this.SM4_CBC_PKCS5PADDING, bjcaKey, data);
    }

    public byte[] decPart(byte[] encData, byte[] dPart, PublicKey pub) throws PkiException {
        if (!(pub instanceof RSAPublicKey)) {
            throw new PkiException("PublicKey not instanceof RSAPublicKey");
        }
        RSAPublicKey rsaPub = (RSAPublicKey)pub;
        BigInteger pubKeyModule = rsaPub.getModulus();
        if (pubKeyModule.equals(BigInteger.ZERO)) {
            throw new PkiException("modulus cannot be zero");
        }
        return this.provider.bigIntegerModExp(encData, dPart, pubKeyModule.toByteArray());
    }

    public static byte[] unPKCS11Padding(byte[] in) throws PkiException {
        byte pad;
        int start;
        byte type = in[0];
        if (type != 2) {
            throw new PkiException("unknown block type,must be 2");
        }
        for (start = 1; start != in.length && (pad = in[start]) != 0; ++start) {
        }
        if (++start <= in.length && start >= 10) {
            byte[] result = new byte[in.length - start];
            System.arraycopy(in, start, result, 0, result.length);
            return result;
        }
        throw new PkiException("no data in block");
    }

    public byte[] combileRSASign(byte[] cs, byte[] ss, BjcaKey pub) throws PkiException {
        RSAPublicKey publicKey = (RSAPublicKey)KeyPairUtil.convertPublicKey(pub);
        BigInteger n = publicKey.getModulus();
        byte[] sBytes = this.bigIntegerModMul(cs, ss, n.toByteArray());
        BigInteger s = ByteArrayUtil.byteArray2BigInteger(sBytes);
        return ByteArrayUtil.bigInteger2ByteArray(s, n.bitLength() + 7 >> 3);
    }

    public byte[] semSign(String alg, byte[] dsem, BjcaKey pub, byte[] tbs) throws PkiException {
        if (alg != null && alg.toUpperCase().contains("RSA")) {
            byte[] dInfo = this.packDigestInfo(alg, tbs);
            RSAPublicKey publicKey = (RSAPublicKey)KeyPairUtil.convertPublicKey(pub);
            BigInteger n = publicKey.getModulus();
            byte[] tbs2 = this.pkcs1EncodingForSign(dInfo, n.bitLength());
            byte[] rBytes = this.provider.bigIntegerModExp(tbs2, dsem, n.toByteArray());
            BigInteger r = ByteArrayUtil.byteArray2BigInteger(rBytes);
            return ByteArrayUtil.bigInteger2ByteArray(r, n.bitLength() + 7 >> 3);
        }
        if (alg != null && alg.toUpperCase().contains("SM2")) {
            return new byte[0];
        }
        throw new PkiException("11001099", "\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b:" + alg);
    }

    public byte[] pkcs1EncodingForSign(byte[] t1, int keyBits) throws PkiException {
        int rLen = t1.length;
        int fLen = (keyBits + 7 >> 3) - 1;
        if (rLen >= fLen) {
            throw new PkiException("input data to padding too long,keySize=" + fLen + " , dataLen=" + rLen);
        }
        byte[] block = new byte[fLen];
        block[0] = 1;
        for (int i = 1; i != block.length - rLen - 1; ++i) {
            block[i] = -1;
        }
        block[block.length - rLen - 1] = 0;
        System.arraycopy(t1, 0, block, block.length - rLen, rLen);
        return block;
    }

    public byte[] packDigestInfo(String alg, byte[] hash) throws PkiException {
        if (alg.toUpperCase().contains("SHA1")) {
            if (hash.length == 20) {
                byte[] sha1Head = new BigInteger("3021300906052b0e03021a05000414", 16).toByteArray();
                byte[] h = new byte[35];
                System.arraycopy(sha1Head, 0, h, 0, 15);
                System.arraycopy(hash, 0, h, 15, 20);
                return h;
            }
            if (hash.length == 35) {
                return hash;
            }
            throw new PkiException("hash length error,length=" + hash.length);
        }
        if (alg.toUpperCase().contains("SHA256")) {
            if (hash.length == 32) {
                byte[] sha1Head = new BigInteger("3031300d060960864801650304020105000420", 16).toByteArray();
                byte[] h = new byte[51];
                System.arraycopy(sha1Head, 0, h, 0, 19);
                System.arraycopy(hash, 0, h, 19, 32);
                return h;
            }
            if (hash.length == 51) {
                return hash;
            }
            throw new PkiException("hash length error,length=" + hash.length);
        }
        throw new PkiException("11001099", "\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
    }

    public byte[] sign(BjcaKey pri, byte[] hash) throws PkiException {
        return this.provider.signHashedData(new AlgPolicy("SM3WithSM2"), hash, pri);
    }

    public byte[] genDirectorAuthorize(byte[] dc, byte[] r) {
        return this.provider.semV2ClientG1(dc, r);
    }

    public byte[] genRandomPrivateKey() {
        return this.provider.semV2ClientG2();
    }

    public byte[] genAuthorizedKey(byte[] dcc, byte[] t) {
        return this.provider.semV2ClientG3(dcc, t);
    }

    public byte[] genServerKeyByOthers(byte[] w, byte[] r, byte[] ds) {
        return this.provider.semV2ServerG4(w, r, ds);
    }

    public byte[] directorAuthorizeOthers(byte[] dc, byte[] dcc) {
        return this.provider.semV2Client2CalcDCS(dc, dcc);
    }

    public byte[] genServerKeyByDirector(byte[] ds, byte[] dcs) {
        return this.provider.semV2Server2CalcDSS(ds, dcs);
    }
}

