/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.BERTaggedObject;
import cn.org.bjca.gaia.asn1.DERBitString;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DERSet;
import cn.org.bjca.gaia.asn1.DERTaggedObject;
import cn.org.bjca.gaia.asn1.DLSequence;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.cms.EncryptedContentInfo;
import cn.org.bjca.gaia.asn1.cms.EnvelopedData;
import cn.org.bjca.gaia.asn1.cms.KeyTransRecipientInfo;
import cn.org.bjca.gaia.asn1.cms.RecipientInfo;
import cn.org.bjca.gaia.asn1.gm.GMObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.IssuerAndSerialNumber;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.BjcaKeyPair;
import cn.org.bjca.gaia.assemb.param.IVParam;
import cn.org.bjca.gaia.assemb.param.SymmCipherParam;
import cn.org.bjca.gaia.assemb.structure.BjcaEnvelop;
import cn.org.bjca.gaia.assemb.util.ByteArrayUtil;
import cn.org.bjca.gaia.assemb.util.CertificateUtil;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.util.Pack;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Enumeration;

public class EnvelopUtil {
    private GaiaProvider provider = null;

    public EnvelopUtil(GaiaProvider provider) {
        this.provider = provider;
    }

    public byte[] encodeEnvelop(AlgPolicy asymPolicy, AlgPolicy symmPolicy, String userCert, byte[] dataInput) throws PkiException {
        if (!AlgConstant.checkEnvelopSymmEncDecAlg(symmPolicy.getPolicyType()) || !AlgConstant.checkAsymEncDecAlg(asymPolicy.getPolicyType())) {
            throw new PkiException("11013001", "\u6570\u5b57\u4fe1\u5c01\u52a0\u5bc6\u5931\u8d25 \u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b asymPolicy= " + asymPolicy.getPolicyType() + " symmPolicy= " + symmPolicy.getPolicyType());
        }
        byte[] p7Envelop = null;
        try {
            if (symmPolicy.getParam() == null) {
                throw new PkiException("11013001", "\u6570\u5b57\u4fe1\u5c01\u52a0\u5bc6\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef SymmCipherParam is null");
            }
            SymmCipherParam symmCipherParam = (SymmCipherParam)symmPolicy.getParam();
            String symmKeyAlg = AlgConstant.convertSymmAlgToSymmKeyAlg(symmPolicy.getPolicyType());
            AlgPolicy genKey = new AlgPolicy(symmKeyAlg, symmCipherParam.getGenKeyParam());
            BjcaKey symmKey = this.provider.genSymmKey(genKey, symmCipherParam.getKeyLen());
            AlgPolicy encryptPolicy = new AlgPolicy(symmPolicy.getPolicyType(), symmCipherParam.getIvParam());
            byte[] encdata = this.provider.encrypt(encryptPolicy, symmKey, dataInput);
            BjcaKey publicKey = KeyPairUtil.certToKey(Base64.decode(userCert));
            byte[] encKey = this.provider.encrypt(asymPolicy, publicKey, symmKey.getKey());
            ASN1Integer version = new ASN1Integer(0L);
            ASN1Integer recpientver = new ASN1Integer(0L);
            Certificate certOb = CertificateUtil.convertToCertificate(Base64.decode(userCert));
            IssuerAndSerialNumber isAndSN = new IssuerAndSerialNumber(certOb.getIssuer(), certOb.getSerialNumber().getPositiveValue());
            AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(AlgConstant.convertAlgNameToEncryptOid(asymPolicy.getPolicyType()), DERNull.INSTANCE);
            DEROctetString derEncKey = new DEROctetString(encKey);
            ASN1EncodableVector recipientVector = new ASN1EncodableVector();
            recipientVector.add(recpientver);
            recipientVector.add(isAndSN);
            recipientVector.add(derAlgEncKey);
            recipientVector.add(derEncKey);
            DERSequence recipientInfo = new DERSequence(recipientVector);
            ASN1Primitive sIV = DERNull.INSTANCE;
            if (symmPolicy.getPolicyType().contains("CBC")) {
                sIV = new DEROctetString(symmCipherParam.getIvParam().getIv());
            }
            AlgorithmIdentifier derAlg = new AlgorithmIdentifier(AlgConstant.convertAlgNameToOid(symmPolicy.getPolicyType()), sIV);
            DERSet recipientInfos = new DERSet(recipientInfo);
            ASN1ObjectIdentifier contentType = AlgConstant.convertAlgToPkcs7DataOid(asymPolicy.getPolicyType());
            DEROctetString encContent = new DEROctetString(encdata);
            BERTaggedObject berTag = new BERTaggedObject(false, 0, encContent);
            ASN1EncodableVector contVector = new ASN1EncodableVector();
            contVector.add(contentType);
            contVector.add(derAlg);
            contVector.add(berTag);
            DERSequence cont = new DERSequence(contVector);
            ASN1EncodableVector envVector = new ASN1EncodableVector();
            envVector.add(version);
            envVector.add(recipientInfos);
            envVector.add(cont);
            DERSequence env = new DERSequence(envVector);
            ASN1EncodableVector p7Vector = new ASN1EncodableVector();
            p7Vector.add(AlgConstant.convertAlgToEnvelopedDataOid(asymPolicy.getPolicyType()));
            DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
            p7Vector.add(dtCont);
            DERSequence p7 = new DERSequence(p7Vector);
            p7Envelop = p7.getEncoded();
        }
        catch (Exception e) {
            throw new PkiException("11013001", "\u6570\u5b57\u4fe1\u5c01\u52a0\u5bc6\u5931\u8d25", e);
        }
        return p7Envelop;
    }

    public byte[] decodeEnvelop(BjcaKey privateKey, byte[] envelop) throws PkiException {
        byte[] ori = null;
        try {
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(envelop));
            ContentInfo info = ContentInfo.getInstance(aIn.readObject());
            EnvelopedData envData = EnvelopedData.getInstance(info.getContent());
            ASN1Set recipientInfoSet = envData.getRecipientInfos();
            Enumeration recipientInfoEnum = recipientInfoSet.getObjects();
            RecipientInfo recipientInfo = RecipientInfo.getInstance(recipientInfoEnum.nextElement());
            KeyTransRecipientInfo keyTransRecipientInfo = (KeyTransRecipientInfo)recipientInfo.getInfo();
            ASN1ObjectIdentifier algorithm = keyTransRecipientInfo.getKeyEncryptionAlgorithm().getAlgorithm();
            String asymAlg = AlgConstant.convertOidToAlgName(algorithm);
            AlgPolicy asymAlgPolicy = new AlgPolicy(asymAlg);
            byte[] kek = keyTransRecipientInfo.getEncryptedKey().getOctets();
            byte[] key = this.provider.decrypt(asymAlgPolicy, privateKey, kek);
            EncryptedContentInfo encryptedContentInfo = envData.getEncryptedContentInfo();
            AlgorithmIdentifier algorithmIdentifier = encryptedContentInfo.getContentEncryptionAlgorithm();
            String symmEncAlg = AlgConstant.convertOidToAlgName(algorithmIdentifier.getAlgorithm());
            AlgPolicy decPolicy = new AlgPolicy(symmEncAlg);
            ASN1Encodable encParam = algorithmIdentifier.getParameters();
            if (symmEncAlg.contains("CBC")) {
                if (encParam == null) {
                    throw new PkiException("11013002", "\u6570\u5b57\u4fe1\u5c01\u89e3\u5bc6\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef CBC Mode lack Iv param");
                }
                DEROctetString ivDer = (DEROctetString)encParam;
                IVParam ivParam = new IVParam();
                ivParam.setIv(ivDer.getOctets());
                decPolicy.setParam(ivParam);
            }
            String keyTpye = AlgConstant.convertSymmAlgToSymmKeyAlg(symmEncAlg);
            BjcaKey symmKey = new BjcaKey(keyTpye, key);
            byte[] encContent = encryptedContentInfo.getEncryptedContent().getOctets();
            ori = this.provider.decrypt(decPolicy, symmKey, encContent);
        }
        catch (Exception e) {
            throw new PkiException("11013002", "\u6570\u5b57\u4fe1\u5c01\u89e3\u5bc6\u5931\u8d25", e);
        }
        return ori;
    }

    public BjcaEnvelop parseEnvelopStructure(byte[] envelop) throws PkiException {
        BjcaEnvelop bjcaEnvelop = new BjcaEnvelop(envelop);
        return bjcaEnvelop;
    }

    public byte[] sm2EnvelopedKey(PublicKey publicKey, PrivateKey privateKey) throws PkiException {
        BjcaKey pubKey = KeyPairUtil.subjectPubKeyInfo2Key(publicKey.getEncoded());
        BjcaKey priKey = KeyPairUtil.convertSm2Prikey(privateKey);
        return this.sm2EnvelopedKey(pubKey, priKey);
    }

    public byte[] sm2EnvelopedKey(BjcaKey publicKey, BjcaKey privateKey) throws PkiException {
        try {
            BjcaKey sm4Key = this.provider.genSymmKey(new AlgPolicy("SM4"), 128);
            byte[] realKey = privateKey.getKey();
            byte[] encPri = this.provider.encrypt(new AlgPolicy("SM4/ECB/NoPadding"), sm4Key, realKey);
            byte[] encSm4Key = this.provider.encrypt(new AlgPolicy("SM2"), publicKey, sm4Key.getKey());
            ASN1ObjectIdentifier oid = GMObjectIdentifiers.sms4_ecb;
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add(new AlgorithmIdentifier(oid, DERNull.INSTANCE).toASN1Primitive());
            vector.add(DLSequence.fromByteArray(encSm4Key));
            vector.add(new DERBitString(publicKey.getKey()));
            vector.add(new DERBitString(encPri));
            return new DERSequence(vector).getEncoded();
        }
        catch (IOException e) {
            throw new PkiException("11013005", "SM2\u4fdd\u62a4\u5bc6\u94a5\u89e3\u6790\u5931\u8d25", e);
        }
    }

    public BjcaKeyPair decodeSM2EnvelopedKey(byte[] envelopedKey, BjcaKey privateKey) throws PkiException {
        try {
            DLSequence data = (DLSequence)DLSequence.fromByteArray(envelopedKey);
            AlgorithmIdentifier oid = AlgorithmIdentifier.getInstance(data.getObjectAt(0));
            if (!oid.getAlgorithm().equals(GMObjectIdentifiers.sms4_ecb)) {
                throw new PkiException("11013007", "SM2\u4fdd\u62a4\u5bc6\u94a5\u7b97\u6cd5\u6807\u8bc6\u4e0d\u5339\u914d");
            }
            ASN1Encodable encSm4Key = data.getObjectAt(1);
            DERBitString sm2Pub = (DERBitString)data.getObjectAt(2);
            DERBitString encSm2Pri = (DERBitString)data.getObjectAt(3);
            byte[] sm4Key = this.provider.decrypt(new AlgPolicy("SM2"), privateKey, encSm4Key.toASN1Primitive().getEncoded());
            byte[] realPri = this.provider.decrypt(new AlgPolicy("SM4/ECB/NoPadding"), new BjcaKey("SM4", sm4Key), encSm2Pri.getOctets());
            BjcaKey pubKey = new BjcaKey("SM2_Public", sm2Pub.getOctets());
            BjcaKey priKey = new BjcaKey("SM2_Private", realPri);
            return new BjcaKeyPair(pubKey, priKey);
        }
        catch (IOException e) {
            throw new PkiException("11013006", "SM2\u4fdd\u62a4\u5bc6\u94a5\u89e3\u6790\u5931\u8d25", e);
        }
    }

    public KeyPair decodeSM2EnvelopedKey(byte[] envelopedKey, PrivateKey privateKey) throws PkiException {
        BjcaKeyPair bjcaKeyPair = this.decodeSM2EnvelopedKey(envelopedKey, KeyPairUtil.convertSm2Prikey(privateKey));
        PublicKey pubKey = KeyPairUtil.convertPublicKey(bjcaKeyPair.getPublicKey());
        PrivateKey priKey = KeyPairUtil.convertPrivateKey(bjcaKeyPair.getPrivateKey());
        return new KeyPair(pubKey, priKey);
    }

    public byte[][] parseCASm2PriKeyEnvelop(byte[] data) throws Exception {
        int BASELENTH = 2;
        byte[] totalLen = new byte[BASELENTH];
        byte[] version = new byte[BASELENTH];
        byte[] algID = new byte[BASELENTH];
        byte[] bits = new byte[BASELENTH];
        byte[] prikeyLen = new byte[BASELENTH];
        byte[] pubkeyLen = new byte[BASELENTH];
        byte[] cipherLen = new byte[BASELENTH];
        byte[] XLen = new byte[BASELENTH];
        byte[] YLen = new byte[BASELENTH];
        byte[] MLen = new byte[BASELENTH];
        byte[] CLen = new byte[BASELENTH];
        System.arraycopy(data, 0, totalLen, 0, BASELENTH);
        System.arraycopy(data, BASELENTH, version, 0, BASELENTH);
        System.arraycopy(data, BASELENTH * 2, algID, 0, BASELENTH);
        System.arraycopy(data, BASELENTH * 3, bits, 0, BASELENTH);
        System.arraycopy(data, BASELENTH * 4, prikeyLen, 0, BASELENTH);
        int prikeyLen10 = EnvelopUtil.bigEndianByteToInt(prikeyLen);
        byte[] cipherPrikey = new byte[prikeyLen10];
        System.arraycopy(data, BASELENTH * 5, cipherPrikey, 0, prikeyLen10);
        System.arraycopy(data, BASELENTH * 5 + prikeyLen10, pubkeyLen, 0, BASELENTH);
        int pubkeyLen10 = EnvelopUtil.bigEndianByteToInt(pubkeyLen);
        byte[] pubkey = new byte[pubkeyLen10];
        System.arraycopy(data, BASELENTH * 6 + prikeyLen10, pubkey, 0, pubkeyLen10);
        System.arraycopy(data, BASELENTH * 6 + prikeyLen10 + pubkeyLen10, cipherLen, 0, BASELENTH);
        System.arraycopy(data, BASELENTH * 7 + prikeyLen10 + pubkeyLen10, XLen, 0, BASELENTH);
        int XLen10 = EnvelopUtil.bigEndianByteToInt(XLen);
        byte[] X = new byte[XLen10];
        System.arraycopy(data, BASELENTH * 8 + prikeyLen10 + pubkeyLen10, X, 0, XLen10);
        System.arraycopy(data, BASELENTH * 8 + prikeyLen10 + pubkeyLen10 + XLen10, YLen, 0, BASELENTH);
        int YLen10 = EnvelopUtil.bigEndianByteToInt(YLen);
        byte[] Y = new byte[YLen10];
        System.arraycopy(data, BASELENTH * 9 + prikeyLen10 + pubkeyLen10 + XLen10, Y, 0, YLen10);
        System.arraycopy(data, BASELENTH * 9 + prikeyLen10 + pubkeyLen10 + XLen10 + YLen10, MLen, 0, BASELENTH);
        int MLen10 = EnvelopUtil.bigEndianByteToInt(MLen);
        byte[] M = new byte[MLen10];
        System.arraycopy(data, BASELENTH * 10 + prikeyLen10 + pubkeyLen10 + XLen10 + YLen10, M, 0, MLen10);
        System.arraycopy(data, BASELENTH * 10 + prikeyLen10 + pubkeyLen10 + XLen10 + YLen10 + MLen10, CLen, 0, BASELENTH);
        int CLen10 = EnvelopUtil.bigEndianByteToInt(CLen);
        byte[] C = new byte[CLen10];
        System.arraycopy(data, BASELENTH * 11 + prikeyLen10 + pubkeyLen10 + XLen10 + YLen10 + MLen10, C, 0, CLen10);
        ASN1EncodableVector enVector = new ASN1EncodableVector();
        ASN1Integer x = new ASN1Integer(ByteArrayUtil.byteArray2BigInteger(X));
        ASN1Integer y = new ASN1Integer(ByteArrayUtil.byteArray2BigInteger(Y));
        DEROctetString hashOctStr = new DEROctetString(M);
        DEROctetString enOctStr = new DEROctetString(C);
        enVector.add(x);
        enVector.add(y);
        enVector.add(hashOctStr);
        enVector.add(enOctStr);
        byte[] derBytes = new DERSequence(enVector).getEncoded();
        byte[][] retBytes = new byte[][]{cipherPrikey, derBytes, algID};
        return retBytes;
    }

    public byte[][] parseCARsaPriKeyEnvelop(byte[] rsaEnvelop) throws PkiException {
        int baseLen = 4;
        byte[] littleEndiaKeyLen = new byte[baseLen];
        System.arraycopy(rsaEnvelop, 0, littleEndiaKeyLen, 0, baseLen);
        int totalLength = Pack.littleEndianToInt(littleEndiaKeyLen, 0);
        if (totalLength + baseLen != rsaEnvelop.length) {
            throw new PkiException("11013002", "\u6570\u5b57\u4fe1\u5c01\u89e3\u5bc6\u5931\u8d25");
        }
        System.arraycopy(rsaEnvelop, baseLen, littleEndiaKeyLen, 0, baseLen);
        int encSymmKeyLen = Pack.littleEndianToInt(littleEndiaKeyLen, 0);
        byte[] encSymmKey = new byte[encSymmKeyLen];
        System.arraycopy(rsaEnvelop, baseLen * 2, encSymmKey, 0, encSymmKeyLen);
        int encPriKeyLen = totalLength - encSymmKeyLen - baseLen;
        byte[] encPriKey = new byte[encPriKeyLen];
        System.arraycopy(rsaEnvelop, baseLen * 2 + encSymmKeyLen, encPriKey, 0, encPriKeyLen);
        byte[][] retBytes = new byte[][]{encPriKey, encSymmKey};
        return retBytes;
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return EnvelopUtil.ByteToInt(EnvelopUtil.back(bytes));
    }

    public static int ByteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        if (bytes.length > 2) {
            temp = (0xFF & bytes[2]) << 16;
            num |= temp;
        }
        if (bytes.length > 3) {
            temp = (0xFF & bytes[3]) << 24;
            num |= temp;
        }
        return num;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[out.length - i - 1];
        }
        return out;
    }
}

