/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DEROutputStream;
import cn.org.bjca.gaia.asn1.DLSequence;
import cn.org.bjca.gaia.asn1.gm.GMNamedCurves;
import cn.org.bjca.gaia.asn1.gm.GMObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PrivateKeyInfo;
import cn.org.bjca.gaia.asn1.pkcs.RSAPrivateKey;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.asn1.x9.X9ECParameters;
import cn.org.bjca.gaia.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.util.KeyUtil;
import cn.org.bjca.gaia.jce.provider.BJCAJEProvider;
import cn.org.bjca.gaia.jce.spec.ECNamedCurveParameterSpec;
import cn.org.bjca.gaia.jce.spec.ECParameterSpec;
import cn.org.bjca.gaia.jce.spec.ECPrivateKeySpec;
import cn.org.bjca.gaia.jce.spec.ECPublicKeySpec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyPairUtil {
    public static final X9ECParameters x9ECParameters = GMNamedCurves.getByName("sm2p256v1");
    public static final ECDomainParameters ecDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    public static final ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    public static final ECNamedCurveParameterSpec sm2Spec = new ECNamedCurveParameterSpec(GMObjectIdentifiers.sm2p256v1.toString(), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
    private static final int XY_RS_LEN = 32;

    public static Key convertKey(BjcaKey bjcaKey) throws PkiException {
        String keyType = bjcaKey.getKeyType();
        if (keyType.equals("DESede") || keyType.equals("AES") || keyType.equals("SM4")) {
            return KeyPairUtil.convertSecretKey(bjcaKey);
        }
        if (keyType.equals("RSA_Private") || keyType.equals("SM2_Private")) {
            return KeyPairUtil.convertPrivateKey(bjcaKey);
        }
        if (keyType.equals("RSA_Public") || keyType.equals("SM2_Public")) {
            return KeyPairUtil.convertPublicKey(bjcaKey);
        }
        throw new PkiException("11005001", "\u5bc6\u94a5\u8f6c\u6362\u64cd\u4f5c\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
    }

    public static PrivateKey convertPrivateKey(BjcaKey jkey) throws PkiException {
        String keyType = jkey.getKeyType();
        if (!keyType.equals("RSA_Private") && !keyType.equals("SM2_Private")) {
            throw new PkiException("11005003", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
        }
        PrivateKey prvKey = null;
        try {
            if (keyType.equals("RSA_Private")) {
                KeyFactory kf = KeyFactory.getInstance(keyType.substring(0, keyType.indexOf("_")), "BJCAJE");
                PKCS8EncodedKeySpec p8KeySpec = new PKCS8EncodedKeySpec(jkey.getKey());
                prvKey = kf.generatePrivate(p8KeySpec);
            } else if (keyType.equals("SM2_Private")) {
                prvKey = KeyPairUtil.convertSm2Privatekey(jkey.getKey());
            }
            return prvKey;
        }
        catch (Exception ex) {
            throw new PkiException("11005003", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25", ex);
        }
    }

    public static PublicKey convertPublicKey(BjcaKey jkey) throws PkiException {
        String keyType = jkey.getKeyType();
        if (!keyType.equals("RSA_Public") && !keyType.equals("SM2_Public")) {
            throw new PkiException("11005004", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
        }
        PublicKey pubKey = null;
        try {
            if (keyType.equals("RSA_Public")) {
                KeyFactory kf = KeyFactory.getInstance(keyType.substring(0, keyType.indexOf("_")), "BJCAJE");
                X509EncodedKeySpec x509spec = new X509EncodedKeySpec(jkey.getKey());
                pubKey = kf.generatePublic(x509spec);
            } else if (keyType.equals("SM2_Public")) {
                pubKey = KeyPairUtil.convertSm2Publickey(jkey.getKey());
            }
            return pubKey;
        }
        catch (Exception ex) {
            throw new PkiException("11005004", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25", ex);
        }
    }

    public static SecretKey convertSecretKey(BjcaKey jkey) throws PkiException {
        String keyType = jkey.getKeyType();
        if (!(keyType.equals("DESede") || keyType.equals("AES") || keyType.equals("SM4"))) {
            throw new PkiException("11005002", "\u5bf9\u79f0\u5bc6\u94a5\u8f6c\u6362\u5931\u8d25 \u5bc6\u94a5\u7c7b\u578b\u4e0d\u5408\u6cd5 " + keyType);
        }
        try {
            return new SecretKeySpec(jkey.getKey(), jkey.getKeyType());
        }
        catch (Exception ex) {
            throw new PkiException("11005002", "\u5bf9\u79f0\u5bc6\u94a5\u8f6c\u6362\u5931\u8d25", ex);
        }
    }

    private static BCECPrivateKey convertSm2Privatekey(byte[] privateKey) {
        BigInteger d = new BigInteger(1, privateKey);
        return KeyPairUtil.getSm2PrivatekeyFromD(d);
    }

    private static BCECPrivateKey getSm2PrivatekeyFromD(BigInteger d) {
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(d, sm2Spec);
        return new BCECPrivateKey("EC", ecPrivateKeySpec, BJCAJEProvider.CONFIGURATION);
    }

    private static BCECPublicKey convertSm2Publickey(byte[] publicKey) {
        if (publicKey.length == 65) {
            publicKey = KeyPairUtil.getPublickeyFromDer(publicKey);
        }
        byte[] xByte = new byte[32];
        byte[] yByte = new byte[32];
        System.arraycopy(publicKey, 0, xByte, 0, 32);
        System.arraycopy(publicKey, 32, yByte, 0, 32);
        BigInteger affineX = new BigInteger(1, xByte);
        BigInteger affineY = new BigInteger(1, yByte);
        return KeyPairUtil.getPublickeyFromXY(affineX, affineY);
    }

    public static BCECPublicKey getPublickeyFromXY(BigInteger x, BigInteger y) {
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(x9ECParameters.getCurve().createPoint(x, y), sm2Spec);
        return new BCECPublicKey("EC", ecPublicKeySpec, BJCAJEProvider.CONFIGURATION);
    }

    public static byte[] getPublickeyFromDer(byte[] publicKey) {
        if (publicKey.length != 65) {
            return null;
        }
        byte[] pubKey = new byte[64];
        System.arraycopy(publicKey, 1, pubKey, 0, 64);
        return pubKey;
    }

    public static byte[] getDerPublickey(byte[] publicKey) {
        if (publicKey.length == 65) {
            return publicKey;
        }
        byte[] pubKey = new byte[65];
        byte[] first = new byte[]{4};
        System.arraycopy(first, 0, pubKey, 0, 1);
        System.arraycopy(publicKey, 0, pubKey, 1, 64);
        return pubKey;
    }

    public static byte[] convertRsaP8PubKeyToP1(byte[] key) throws PkiException {
        byte[] ret = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(key);
            SubjectPublicKeyInfo pub = SubjectPublicKeyInfo.getInstance(seq);
            ret = pub.parsePublicKey().getEncoded();
        }
        catch (Exception e) {
            throw new PkiException("11005004", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25", e);
        }
        return ret;
    }

    public static byte[] convertRsaP1PriKeyToP8(byte[] key) throws PkiException {
        byte[] p8Key = null;
        try {
            ASN1Sequence p1Seq = (ASN1Sequence)ASN1Util.checkAndGetASN1Object(key);
            p8Key = KeyUtil.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), RSAPrivateKey.getInstance(p1Seq));
        }
        catch (Exception e) {
            throw new PkiException("11005003", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25", e);
        }
        return p8Key;
    }

    public static byte[] convertRsaP8PriKeyToP1(byte[] key) throws PkiException {
        byte[] p1Key = null;
        try {
            PrivateKeyInfo p8Key = PrivateKeyInfo.getInstance(ASN1Util.checkAndGetASN1Object(key));
            ASN1Sequence p1Seq = (ASN1Sequence)p8Key.parsePrivateKey();
            p1Key = p1Seq.getEncoded();
        }
        catch (Exception e) {
            throw new PkiException("11005003", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25", e);
        }
        return p1Key;
    }

    public static BjcaKey convertSM2P8PriKeyToBjcaKey(byte[] priKeyEncoded) throws PkiException {
        try {
            DLSequence dlSequence = (DLSequence)DLSequence.fromByteArray(priKeyEncoded);
            byte[] priKeys = ((DEROctetString)dlSequence.getObjectAt(2)).getOctets();
            dlSequence = (DLSequence)DLSequence.fromByteArray(priKeys);
            DEROctetString derPriKey = (DEROctetString)dlSequence.getObjectAt(1);
            return new BjcaKey("SM2_Private", derPriKey.getOctets());
        }
        catch (IOException e) {
            throw new PkiException("11005003", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    public static BjcaKey convertSm2Prikey(PrivateKey privateKey) throws PkiException {
        BjcaKey bjcaKey;
        try {
            if (privateKey.getAlgorithm().equals("RSA")) {
                bjcaKey = new BjcaKey("RSA_Private", privateKey.getEncoded());
            } else {
                byte[] priKeyEncoded = privateKey.getEncoded();
                if (priKeyEncoded.length <= 33) {
                    bjcaKey = new BjcaKey("SM2_Private", priKeyEncoded);
                } else {
                    DLSequence dlSequence = (DLSequence)DLSequence.fromByteArray(priKeyEncoded);
                    byte[] priKeys = ((DEROctetString)dlSequence.getObjectAt(2)).getOctets();
                    dlSequence = (DLSequence)DLSequence.fromByteArray(priKeys);
                    DEROctetString derPriKey = (DEROctetString)dlSequence.getObjectAt(1);
                    bjcaKey = new BjcaKey("SM2_Private", derPriKey.getOctets());
                }
            }
        }
        catch (Exception e) {
            throw new PkiException("11005003", "\u79c1\u94a5\u8f6c\u6362\u5931\u8d25", e);
        }
        return bjcaKey;
    }

    public static byte[] convertRsaP1PubKeyToP8(byte[] key) throws PkiException {
        byte[] p8Key = null;
        try {
            ASN1Sequence p1Seq = (ASN1Sequence)ASN1Util.checkAndGetASN1Object(key);
            p8Key = KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), p1Seq);
        }
        catch (Exception e) {
            throw new PkiException("11005004", "\u516c\u94a5\u8f6c\u6362\u5931\u8d25", e);
        }
        return p8Key;
    }

    public static BjcaKey certToKey(byte[] usrCert) throws PkiException {
        ASN1Object pkcs = ASN1Util.checkAndGetASN1Object(usrCert);
        Certificate cert = Certificate.getInstance(pkcs);
        return KeyPairUtil.subjectPubKeyInfo2Key(cert.getSubjectPublicKeyInfo());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BjcaKey subjectPubKeyInfo2Key(SubjectPublicKeyInfo spki) throws PkiException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(spki.toASN1Primitive());
            byte[] key = bos.toByteArray();
            if (spki.getAlgorithm().getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption)) {
                BjcaKey bjcaKey = new BjcaKey("RSA_Public", key);
                return bjcaKey;
            }
            if (spki.getAlgorithm().getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
                ASN1ObjectIdentifier algId = ASN1ObjectIdentifier.getInstance(spki.getAlgorithm().getParameters());
                if (null != algId && algId.equals(GMObjectIdentifiers.sm2p256v1)) {
                    BjcaKey bjcaKey = new BjcaKey("SM2_Public", spki.getPublicKeyData().getBytes());
                    return bjcaKey;
                }
                BjcaKey bjcaKey = new BjcaKey("EC_Public", key);
                return bjcaKey;
            }
            throw new PkiException("11007001", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25:\u4e0d\u652f\u6301\u7684\u516c\u94a5\u7c7b\u578b");
        }
        catch (Exception ex) {
            throw new PkiException("11007001", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", ex);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static BjcaKey subjectPubKeyInfo2Key(byte[] spki) throws PkiException {
        try {
            ASN1Object asn1Object = ASN1Util.checkAndGetASN1Object(spki);
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(asn1Object);
            return KeyPairUtil.subjectPubKeyInfo2Key(subjectPublicKeyInfo);
        }
        catch (Exception ex) {
            throw new PkiException("11007001", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", ex);
        }
    }

    static {
        if (Security.getProvider("BJCAJE") == null) {
            Security.addProvider(new BJCAJEProvider());
        }
    }
}

