/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.asn1.oiw.OIWObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.DigestInfo;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.util.ByteArrayUtil;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.InvalidCipherTextException;
import cn.org.bjca.gaia.crypto.paddings.PKCS7Padding;
import cn.org.bjca.gaia.jce.provider.BJCAJEProvider;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.Security;

public class PaddingUtil {
    public static byte[] encodePkcs1Padding(byte[] data, boolean isPrivate, int modulusLength, AlgPolicy algPolicy) throws PkiException {
        try {
            if (modulusLength % 1024 == 0) {
                modulusLength /= 8;
            }
            if (modulusLength % 128 != 0) {
                throw new PkiException("11007017", "PKCS\u586b\u5145\u53c2\u6570\u9519\u8bef");
            }
            String policyType = algPolicy.getPolicyType();
            ASN1ObjectIdentifier hashOid = null;
            if ("SHA256".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha256;
            } else if ("SHA1".equals(policyType)) {
                hashOid = OIWObjectIdentifiers.idSHA1;
            } else if ("SHA224".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha224;
            } else if ("SHA384".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha384;
            } else if ("SHA512".equals(policyType)) {
                hashOid = NISTObjectIdentifiers.id_sha512;
            }
            MessageDigest digest = MessageDigest.getInstance(policyType);
            digest.update(data);
            byte[] hash = digest.digest();
            int T = hash.length;
            int emLen = modulusLength - 1;
            if (emLen < T + 10) {
                throw new PkiException("11007017", "PKCS\u586b\u5145\u53c2\u6570\u9519\u8bef");
            }
            int psLength = Math.max(emLen - T - 2, 8);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(hashOid, DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algorithmIdentifier, hash);
            byte[] in = dInfo.getEncoded("DER");
            SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
            byte[] block = new byte[3 + psLength + T];
            int inLen = in.length;
            if (isPrivate) {
                block[1] = 1;
                for (int i = 2; i != block.length - inLen; ++i) {
                    block[i] = -1;
                }
            } else {
                random.nextBytes(block);
                block[0] = 0;
                block[1] = 2;
                for (int i = 2; i != block.length - inLen; ++i) {
                    while (block[i] == 0) {
                        block[i] = (byte)random.nextInt();
                    }
                }
            }
            block[block.length - inLen - 1] = 0;
            System.arraycopy(in, 0, block, block.length - inLen, inLen);
            return block;
        }
        catch (Exception e) {
            throw new PkiException("11007016", "PKCS7\u7f16\u7801\u5931\u8d25");
        }
    }

    public static byte[] encodePkcs5Padding(byte[] data) {
        return PaddingUtil.encodePkcs7Padding(data, 8);
    }

    public static byte[] decodePkcs5Padding(byte[] data) throws PkiException {
        return PaddingUtil.decodePkcs7Padding(data);
    }

    public static byte[] encodePkcs7Padding(byte[] data, int groupLength) {
        PKCS7Padding pkcs7Padding = new PKCS7Padding();
        byte[] result = data.length % groupLength == 0 ? new byte[data.length + groupLength] : new byte[(data.length + groupLength) / groupLength * groupLength];
        System.arraycopy(data, 0, result, 0, data.length);
        pkcs7Padding.addPadding(result, data.length);
        return result;
    }

    public static byte[] decodePkcs7Padding(byte[] data) throws PkiException {
        byte[] result = new byte[]{};
        try {
            PKCS7Padding pkcs7Padding = new PKCS7Padding();
            int paddingCode = pkcs7Padding.padCount(data);
            result = new byte[data.length - paddingCode];
            System.arraycopy(data, 0, result, 0, result.length);
        }
        catch (InvalidCipherTextException e) {
            throw new PkiException("11007014", "PKCS7\u7f16\u7801\u5931\u8d25");
        }
        return result;
    }

    public static DigestInfo decodePkcs1Padding(byte[] data) throws PkiException {
        byte tag = data[1];
        if (data[0] != 0 || tag != 1 && data[1] != 2) {
            throw new PkiException("11007013", "PKCS1\u6570\u636e\u7ed3\u6784\u9519\u8bef");
        }
        for (int i = 2; i < data.length; ++i) {
            if (data[i] != 0) continue;
            byte[] hash = new byte[data.length - i - 1];
            System.arraycopy(data, i + 1, hash, 0, hash.length);
            return DigestInfo.getInstance(hash);
        }
        throw new PkiException("11007013", "PKCS1\u6570\u636e\u7ed3\u6784\u9519\u8bef");
    }

    public static byte[] encodeISO7816Padding(byte[] data) {
        int length = data.length;
        int paddingLength = 16;
        paddingLength = length > paddingLength ? length % 16 : (paddingLength -= length % 16);
        byte[] padding = new byte[paddingLength == 0 ? 16 : paddingLength];
        padding[0] = -128;
        return ByteArrayUtil.mergeBytes(data, padding);
    }

    public static byte[] decodeISO7816Padding(byte[] data) {
        byte[] result = null;
        for (int i = data.length - 1; i >= 0; --i) {
            if (data[i] != -128) continue;
            result = new byte[i];
            System.arraycopy(data, 0, result, 0, i);
            return result;
        }
        return new byte[0];
    }

    static {
        Security.addProvider(new BJCAJEProvider());
    }
}

