/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DLSequence;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.util.FileUtil;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cn.org.bjca.gaia.jce.provider.BJCAJEProvider;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class Pkcs12Util {
    public void p12Generator(String filePath, String p12Alias, BjcaKey privateKey, String storePassword, String keyPassword, String cert) throws PkiException {
        if (!privateKey.getKeyType().equals("RSA_Private")) {
            throw new PkiException("11010001", "\u6784\u9020P12\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b" + privateKey.getKeyType());
        }
        ByteArrayInputStream inStream = null;
        X509Certificate x509Cert = null;
        try {
            inStream = new ByteArrayInputStream(Base64.decode(cert));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            throw new PkiException("11010001", "\u6784\u9020P12\u5931\u8d25 \u89e3\u6790\u8bc1\u4e66\u5931\u8d25", e);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Key key = KeyPairUtil.convertKey(privateKey);
        FileOutputStream fos = null;
        try {
            Certificate[] caCertChain = new X509Certificate[]{x509Cert};
            KeyStore ks1 = KeyStore.getInstance("PKCS12", "BJCAJE");
            ks1.load(null, null);
            ks1.setKeyEntry(p12Alias, key, keyPassword.toCharArray(), caCertChain);
            String dirPath = FileUtil.getDirPathFromFilePath(filePath);
            FileUtil.confirmDir(dirPath);
            fos = new FileOutputStream(filePath);
            ks1.store(fos, storePassword.toCharArray());
        }
        catch (Exception e) {
            throw new PkiException("11010001", "\u6784\u9020P12\u5931\u8d25 ", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public byte[] p12Generator(String p12Alias, BjcaKey privateKey, String storePassword, String keyPassword, String cert) throws PkiException {
        if (!privateKey.getKeyType().equals("RSA_Private")) {
            throw new PkiException("11010001", "\u6784\u9020P12\u5931\u8d25\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b" + privateKey.getKeyType());
        }
        ByteArrayInputStream inStream = null;
        X509Certificate x509Cert = null;
        try {
            inStream = new ByteArrayInputStream(Base64.decode(cert));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            throw new PkiException("11010001", "\u6784\u9020P12\u5931\u8d25 \u89e3\u6790\u8bc1\u4e66\u5931\u8d25", e);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Key key = KeyPairUtil.convertKey(privateKey);
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] pfxCxt = null;
        try {
            Certificate[] caCertChain = new X509Certificate[]{x509Cert};
            KeyStore ks1 = null;
            ks1 = KeyStore.getInstance("PKCS12", "BJCAJE");
            ks1.load(null, null);
            ks1.setKeyEntry(p12Alias, key, keyPassword.toCharArray(), caCertChain);
            byteArrayOutputStream = new ByteArrayOutputStream();
            ks1.store(byteArrayOutputStream, storePassword.toCharArray());
            pfxCxt = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new PkiException("11010001", "\u6784\u9020P12\u5931\u8d25 ", e);
        }
        return pfxCxt;
    }

    public String exportP12Certificate(byte[] p12Byte, String storePassword) throws PkiException {
        Certificate bjcaCert = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BJCAJE");
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(p12Byte);
            keyStore.load(byteInStream, storePassword.toCharArray());
            Enumeration<String> aliaseList = keyStore.aliases();
            String olnyAlias = "";
            while (aliaseList.hasMoreElements()) {
                String alis;
                olnyAlias = alis = aliaseList.nextElement();
            }
            bjcaCert = keyStore.getCertificate(olnyAlias);
            return Base64.toBase64String(bjcaCert.getEncoded());
        }
        catch (Exception e) {
            throw new PkiException("11010003", "\u4eceP12\u4e2d\u89e3\u6790\u8bc1\u4e66 ", e);
        }
    }

    public BjcaKey exportP12Key(byte[] p12Byte, String storePassword, String keyPassword) throws PkiException {
        BjcaKey bjcaKey = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BJCAJE");
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(p12Byte);
            keyStore.load(byteInStream, storePassword.toCharArray());
            Enumeration<String> aliaseList = keyStore.aliases();
            String olnyAlias = "";
            while (aliaseList.hasMoreElements()) {
                String alis;
                olnyAlias = alis = aliaseList.nextElement();
            }
            PrivateKey priKey = (PrivateKey)keyStore.getKey(olnyAlias, keyPassword.toCharArray());
            if (priKey.getAlgorithm().equals("RSA")) {
                bjcaKey = new BjcaKey("RSA_Private", priKey.getEncoded());
            } else {
                byte[] priKeyEncoded = priKey.getEncoded();
                if (priKeyEncoded.length <= 33) {
                    bjcaKey = new BjcaKey("SM2_Private", priKeyEncoded);
                } else {
                    if (priKey instanceof BCECPrivateKey) {
                        return new BjcaKey("SM2_Private", ((BCECPrivateKey)priKey).getD().toByteArray());
                    }
                    DLSequence dlSequence = (DLSequence)DLSequence.fromByteArray(priKeyEncoded);
                    byte[] priKeys = ((DEROctetString)dlSequence.getObjectAt(2)).getOctets();
                    dlSequence = (DLSequence)DLSequence.fromByteArray(priKeys);
                    DEROctetString derPriKey = (DEROctetString)dlSequence.getObjectAt(1);
                    bjcaKey = new BjcaKey("SM2_Private", derPriKey.getOctets());
                }
            }
        }
        catch (Exception e) {
            throw new PkiException("11010003", "\u4eceP12\u4e2d\u89e3\u6790\u8bc1\u4e66 ", e);
        }
        return bjcaKey;
    }

    public static void main(String[] args) throws PkiException {
        String privateKey = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCvpE6jzsechBEBSb838u4rppy5JMoftWCAjkQcGyX8IhO10vo1WL5BXcLUq/OJ+3/SmsvOCnxPzSCIETvvxHrMQ/7bheRF9pXAx//UTt1aRpbICzBQWShr6uoTwZtRdbuUSgb5hea6GM9weCWTbhwlnUfuKvz3tbpLz6qjYk2G92xVmwu3/aTzKFzigWsV6G/Z2bEyqZuYYHJhxU3lZbFYNoRVX6AKyc5Qs+yF3FokPJWlf+mVwBWcJR06vXZYuqR38cR04j/HADMmh35QLeu8wj5JOb5sfGIoNlYxSxdgR42gxCLtHKEW08KhbFmNwNfHp0eKSf2lqnEIojbY8hafAgMBAAECggEALzeKdHrYKnlOYPxETXQfFtj5dMQxGgkWYjjcknmx4m/+wHhxDvpGWygrgiSfmc5kdGdstn0XIhTQ1ANeC3zUTilRUA5UaYJ6i5K4cYip9OTZD/oCCPeO6EQEnT8E1AdEX/7ulRGsDwcwbNm/sDx/kJURizM/QhA2fr7a7oU0tj1GrYbBJ0Oa0HPU09Fe3p5QVTAViyOEX0ikg6Nxs1l+iTPrjm1fqpAl+mPHQI+oOTyrW59rcmxs8sxCYWhJHhupl0VYrWG7b166lSbRp6q/hrELzqgV+kAkiRYDgkwyjC5VacL+bKLQGtrhRGEAzTk+X8GvEars2quAmfSp7NkXQQKBgQDu8oAMDQuMef7BbZBmVGzaUyH9T7JeZN/itBjmK2JFlaB+sYin6VBlSqGHqonvVlfKb3HvF2cfb3J8rdyXhq9fKaGGqNRzFuAV5VR9aMlpO3NnIYUjNxXJE9bctdUKOMINsUKOE/6LEVMaJquQS8SJljIfN6XlhO9M9PahuWIdzwKBgQC8LTv5KGROD7CqQQkKzPlJ+XHx+PqPJGApNF9nE2Nh9NOBJR6THW/8jz6DmTk9ItsMtfh8mk5keRxzbFH4CjU9TO8XMXi0LGOCAvV4Ioa5/bXpyaLPxoBkk8TrItQrFPe3Uyas4xi6Xgmmme6KVkUFuqeYgif3YbxX0Em8N7n+MQKBgQCjwJrSJ2p/tedJxf1Ms5T5tjk38RMrL3RjV8ssihTJ3TXlPWOKtxE6qX+zisMGu6RkfiWVlfM9DtJl8XyYd1veGpiwwSj/SnD9cHGLlHFbZbu7tLQaIxkR+T+peA9s9uK+IXmcBsXNpmzOIiw3MkWZiM4GqMtPVN/uXH5c7L/57wKBgB1T13L/jpJz8461UBl01K1oyQ9zRGmmu63wUaYY6XZM1+HazScUgW2VTaLo8HjMw+L5QV76FZmnHn4Gtce4n4+MO/8bYLqD6IZMu8EbcG/wULe9CzjisQP728bhyLtmKy1RMkfjpOj22v4yI3E//MXlz1T/hAcUHmx5M+S3sq8hAoGBANPv5+gE8B7ARhhlO0lh06VepeYRpO0Swxy471F3KYehSlG9jyeEORpIGa94ONWFNGbfqtLc+MZFFZ4/GMeL1a8D0+L2j/eAA6X7cEyOX5d4b22xGJj3rwmcTFVTqqlLbVlQvJyKW95iNn5rI3HAZZdT/Gf5mDxqMAS35kKrdpR9";
        String cert = "MIIE8DCCA9igAwIBAgIKG0AAAAAAAAXcSzANBgkqhkiG9w0BAQsFADBSMQswCQYDVQQGEwJDTjENMAsGA1UECgwEQkpDQTEYMBYGA1UECwwPUHVibGljIFRydXN0IENBMRowGAYDVQQDDBFQdWJsaWMgVHJ1c3QgQ0EtMjAeFw0xNzExMTkxNjAwMDBaFw0yMDExMjAxNTU5NTlaMEExCzAJBgNVBAYTAkNOMQ8wDQYDVQQKDAYxMjM0NTYxDzANBgNVBAsMBjEyMzQ1NjEQMA4GA1UEAwwHcnNhMjA0ODCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK+kTqPOx5yEEQFJvzfy7iumnLkkyh+1YICORBwbJfwiE7XS+jVYvkFdwtSr84n7f9Kay84KfE/NIIgRO+/EesxD/tuF5EX2lcDH/9RO3VpGlsgLMFBZKGvq6hPBm1F1u5RKBvmF5roYz3B4JZNuHCWdR+4q/Pe1ukvPqqNiTYb3bFWbC7f9pPMoXOKBaxXob9nZsTKpm5hgcmHFTeVlsVg2hFVfoArJzlCz7IXcWiQ8laV/6ZXAFZwlHTq9dli6pHfxxHTiP8cAMyaHflAt67zCPkk5vmx8Yig2VjFLF2BHjaDEIu0coRbTwqFsWY3A18enR4pJ/aWqcQiiNtjyFp8CAwEAAaOCAdcwggHTMB8GA1UdIwQYMBaAFPu31FYXWIwjfdX4QgHU7XebV+vpMIGtBgNVHR8EgaUwgaIwbKBqoGikZjBkMQswCQYDVQQGEwJDTjENMAsGA1UECgwEQkpDQTEYMBYGA1UECwwPUHVibGljIFRydXN0IENBMRowGAYDVQQDDBFQdWJsaWMgVHJ1c3QgQ0EtMjEQMA4GA1UEAxMHY2E0Y3JsMjAyoDCgLoYsaHR0cDovL2xkYXAuYmpjYS5vcmcuY24vY3JsL3B0Y2EvY2E0Y3JsMi5jcmwwCQYDVR0TBAIwADARBglghkgBhvhCAQEEBAMCAP8wEQYIYIZIAYb4RAIEBUpK5pegMBsGCCpWhkgBgTABBA8xMDIwMDAwMDcwMjMyNjEwDgYFKlYLBwkEBUpK5pegMBIGBipWCwcBCAQIOUNASkrml6AwKgYLYIZIAWUDAgEwCQoEG2h0dHA6Ly9iamNhLm9yZy5jbi9iamNhLmNydDBABgNVHSAEOTA3MDUGCSqBHIbvMgICATAoMCYGCCsGAQUFBwIBFhpodHRwOi8vd3d3LmJqY2Eub3JnLmNuL2NwczALBgNVHQ8EBAMCA/gwEwYKKoEchu8yAgEBHgQFDAM2NTQwDQYJKoZIhvcNAQELBQADggEBAIi6kNILnLRTKu+xszcTrBKps0XazNx/GKlV46nyXfpV3NTAUxr+OHQBkhX167++r/ndyxdk4AV2Y94L0pWcdt9ybOc4vDAJC3hhChxC2rvt7hM21Ptl6epK+SyZ0WqamdYXOZici/Kr6uDzyBS7m8cq9uLj4JVdpOtAhflr2ays03M5c3F2RKWj6AMu9uNziOoGm9DMP5+F9Y9IJs0wu1GC3ys8H5lHYxCY+FBE+GSh2qQlLACgkEuoclXiKDmt68JVpMpnKZ3pDHJPAsEVc5ENqqu6WJjskHN00DzsUZ0GOhRRONvxJqv9GR3V+vfvwX/ZETKPKDRuGsepKYm5suA=";
        BjcaKey bjcaKey = new BjcaKey("RSA_Private", Base64.decode(privateKey));
        String storePw = "12345678";
        String keyPw = "87654321";
        Pkcs12Util pkcs12Util = new Pkcs12Util();
        pkcs12Util.p12Generator("ddd.pfx", "eeeeee", bjcaKey, storePw, keyPw, cert);
    }

    static {
        if (Security.getProvider("BJCAJE") == null) {
            Security.addProvider(new BJCAJEProvider());
        }
    }
}

