/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.crmf;

import cn.org.bjca.gaia.asn1.cmp.PBMParameter;
import cn.org.bjca.gaia.asn1.crmf.PKMACValue;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.cert.crmf.CRMFException;
import cn.org.bjca.gaia.cert.crmf.PKMACBuilder;
import cn.org.bjca.gaia.operator.MacCalculator;
import cn.org.bjca.gaia.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.constantTimeAreEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

