/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.path.validations;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1Null;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.cert.CertException;
import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cert.X509ContentVerifierProviderBuilder;
import cn.org.bjca.gaia.cert.path.CertPathValidation;
import cn.org.bjca.gaia.cert.path.CertPathValidationContext;
import cn.org.bjca.gaia.cert.path.CertPathValidationException;
import cn.org.bjca.gaia.operator.OperatorCreationException;
import cn.org.bjca.gaia.util.Memoable;
import java.io.IOException;

public class ParentCertIssuedValidation
implements CertPathValidation {
    private X509ContentVerifierProviderBuilder contentVerifierProvider;
    private X500Name workingIssuerName;
    private SubjectPublicKeyInfo workingPublicKey;
    private AlgorithmIdentifier workingAlgId;

    public ParentCertIssuedValidation(X509ContentVerifierProviderBuilder contentVerifierProvider) {
        this.contentVerifierProvider = contentVerifierProvider;
    }

    @Override
    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        if (this.workingIssuerName != null && !this.workingIssuerName.equals(certificate.getIssuer())) {
            throw new CertPathValidationException("Certificate issue does not match parent");
        }
        if (this.workingPublicKey != null) {
            try {
                SubjectPublicKeyInfo validatingKeyInfo = this.workingPublicKey.getAlgorithm().equals(this.workingAlgId) ? this.workingPublicKey : new SubjectPublicKeyInfo(this.workingAlgId, this.workingPublicKey.parsePublicKey());
                if (!certificate.isSignatureValid(this.contentVerifierProvider.build(validatingKeyInfo))) {
                    throw new CertPathValidationException("Certificate signature not for public key in parent");
                }
            }
            catch (OperatorCreationException e) {
                throw new CertPathValidationException("Unable to create verifier: " + e.getMessage(), e);
            }
            catch (CertException e) {
                throw new CertPathValidationException("Unable to validate signature: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new CertPathValidationException("Unable to build public key: " + e.getMessage(), e);
            }
        }
        this.workingIssuerName = certificate.getSubject();
        this.workingPublicKey = certificate.getSubjectPublicKeyInfo();
        if (this.workingAlgId != null) {
            if (this.workingPublicKey.getAlgorithm().getAlgorithm().equals(this.workingAlgId.getAlgorithm())) {
                if (!this.isNull(this.workingPublicKey.getAlgorithm().getParameters())) {
                    this.workingAlgId = this.workingPublicKey.getAlgorithm();
                }
            } else {
                this.workingAlgId = this.workingPublicKey.getAlgorithm();
            }
        } else {
            this.workingAlgId = this.workingPublicKey.getAlgorithm();
        }
    }

    private boolean isNull(ASN1Encodable obj) {
        return obj == null || obj instanceof ASN1Null;
    }

    @Override
    public Memoable copy() {
        ParentCertIssuedValidation v = new ParentCertIssuedValidation(this.contentVerifierProvider);
        v.workingAlgId = this.workingAlgId;
        v.workingIssuerName = this.workingIssuerName;
        v.workingPublicKey = this.workingPublicKey;
        return v;
    }

    @Override
    public void reset(Memoable other) {
        ParentCertIssuedValidation v = (ParentCertIssuedValidation)other;
        this.contentVerifierProvider = v.contentVerifierProvider;
        this.workingAlgId = v.workingAlgId;
        this.workingIssuerName = v.workingIssuerName;
        this.workingPublicKey = v.workingPublicKey;
    }
}

