/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms;

import cn.org.bjca.gaia.asn1.cms.OriginatorInfo;
import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.CMSUtils;
import cn.org.bjca.gaia.cms.OriginatorInformation;
import cn.org.bjca.gaia.util.Store;
import java.util.ArrayList;
import java.util.List;

public class OriginatorInfoGenerator {
    private final List origCerts;
    private final List origCRLs;

    public OriginatorInfoGenerator(X509CertificateHolder origCert) {
        this.origCerts = new ArrayList(1);
        this.origCRLs = null;
        this.origCerts.add(origCert.toASN1Structure());
    }

    public OriginatorInfoGenerator(Store origCerts) throws CMSException {
        this(origCerts, null);
    }

    public OriginatorInfoGenerator(Store origCerts, Store origCRLs) throws CMSException {
        this.origCerts = CMSUtils.getCertificatesFromStore(origCerts);
        this.origCRLs = origCRLs != null ? CMSUtils.getCRLsFromStore(origCRLs) : null;
    }

    public OriginatorInformation generate() {
        if (this.origCRLs != null) {
            return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), CMSUtils.createDerSetFromList(this.origCRLs)));
        }
        return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), null));
    }
}

