/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms.bc;

import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.RecipientOperator;
import cn.org.bjca.gaia.cms.bc.BcKeyTransRecipient;
import cn.org.bjca.gaia.cms.bc.EnvelopedDataHelper;
import cn.org.bjca.gaia.crypto.BufferedBlockCipher;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.StreamCipher;
import cn.org.bjca.gaia.crypto.io.CipherInputStream;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.operator.InputDecryptor;
import java.io.InputStream;

public class BcRSAKeyTransEnvelopedRecipient
extends BcKeyTransRecipient {
    public BcRSAKeyTransEnvelopedRecipient(AsymmetricKeyParameter key) {
        super(key);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        CipherParameters secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataIn) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataIn, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataIn, (StreamCipher)dataCipher);
            }
        });
    }
}

