/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.agreement;

import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.RawAgreement;
import cn.org.bjca.gaia.crypto.params.XDHUPrivateParameters;
import cn.org.bjca.gaia.crypto.params.XDHUPublicParameters;

public class XDHUnifiedAgreement
implements RawAgreement {
    private final RawAgreement xAgreement;
    private XDHUPrivateParameters privParams;

    public XDHUnifiedAgreement(RawAgreement xAgreement) {
        this.xAgreement = xAgreement;
    }

    @Override
    public void init(CipherParameters key) {
        this.privParams = (XDHUPrivateParameters)key;
    }

    @Override
    public int getAgreementSize() {
        return this.xAgreement.getAgreementSize() * 2;
    }

    @Override
    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        XDHUPublicParameters pubParams = (XDHUPublicParameters)publicKey;
        this.xAgreement.init(this.privParams.getEphemeralPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getEphemeralPublicKey(), buf, off);
        this.xAgreement.init(this.privParams.getStaticPrivateKey());
        this.xAgreement.calculateAgreement(pubParams.getStaticPublicKey(), buf, off + this.xAgreement.getAgreementSize());
    }
}

