/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.generators;

import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPairGenerator;
import cn.org.bjca.gaia.crypto.KeyGenerationParameters;
import cn.org.bjca.gaia.crypto.generators.DHKeyGeneratorHelper;
import cn.org.bjca.gaia.crypto.params.DHKeyGenerationParameters;
import cn.org.bjca.gaia.crypto.params.DHParameters;
import cn.org.bjca.gaia.crypto.params.DHPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

