/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.parsers;

import cn.org.bjca.gaia.crypto.KeyParser;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;

public class ECIESPublicKeyParser
implements KeyParser {
    private ECDomainParameters ecParams;

    public ECIESPublicKeyParser(ECDomainParameters ecParams) {
        this.ecParams = ecParams;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream stream) throws IOException {
        byte[] V;
        int first = stream.read();
        switch (first) {
            case 0: {
                throw new IOException("Sender's public key invalid.");
            }
            case 2: 
            case 3: {
                V = new byte[1 + (this.ecParams.getCurve().getFieldSize() + 7) / 8];
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                V = new byte[1 + 2 * ((this.ecParams.getCurve().getFieldSize() + 7) / 8)];
                break;
            }
            default: {
                throw new IOException("Sender's public key has invalid point encoding 0x" + Integer.toString(first, 16));
            }
        }
        V[0] = (byte)first;
        Streams.readFully(stream, V, 1, V.length - 1);
        return new ECPublicKeyParameters(this.ecParams.getCurve().decodePoint(V), this.ecParams);
    }
}

