/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.dvcs;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.cms.SignedData;
import cn.org.bjca.gaia.asn1.dvcs.DVCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.dvcs.ServiceType;
import cn.org.bjca.gaia.asn1.x509.GeneralName;
import cn.org.bjca.gaia.cms.CMSSignedData;
import cn.org.bjca.gaia.dvcs.CCPDRequestData;
import cn.org.bjca.gaia.dvcs.CPDRequestData;
import cn.org.bjca.gaia.dvcs.DVCSConstructionException;
import cn.org.bjca.gaia.dvcs.DVCSMessage;
import cn.org.bjca.gaia.dvcs.DVCSRequestData;
import cn.org.bjca.gaia.dvcs.DVCSRequestInfo;
import cn.org.bjca.gaia.dvcs.VPKCRequestData;
import cn.org.bjca.gaia.dvcs.VSDRequestData;

public class DVCSRequest
extends DVCSMessage {
    private cn.org.bjca.gaia.asn1.dvcs.DVCSRequest asn1;
    private DVCSRequestInfo reqInfo;
    private DVCSRequestData data;

    public DVCSRequest(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSRequest(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSRequestData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? cn.org.bjca.gaia.asn1.dvcs.DVCSRequest.getInstance(contentInfo.getContent()) : cn.org.bjca.gaia.asn1.dvcs.DVCSRequest.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
        this.reqInfo = new DVCSRequestInfo(this.asn1.getRequestInformation());
        int service = this.reqInfo.getServiceType();
        if (service == ServiceType.CPD.getValue().intValue()) {
            this.data = new CPDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VSD.getValue().intValue()) {
            this.data = new VSDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VPKC.getValue().intValue()) {
            this.data = new VPKCRequestData(this.asn1.getData());
        } else if (service == ServiceType.CCPD.getValue().intValue()) {
            this.data = new CCPDRequestData(this.asn1.getData());
        } else {
            throw new DVCSConstructionException("Unknown service type: " + service);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }

    public DVCSRequestInfo getRequestInfo() {
        return this.reqInfo;
    }

    public DVCSRequestData getData() {
        return this.data;
    }

    public GeneralName getTransactionIdentifier() {
        return this.asn1.getTransactionIdentifier();
    }
}

