/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.dvcs;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.dvcs.DVCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.dvcs.DVCSRequestInformationBuilder;
import cn.org.bjca.gaia.asn1.dvcs.Data;
import cn.org.bjca.gaia.asn1.x509.ExtensionsGenerator;
import cn.org.bjca.gaia.asn1.x509.GeneralName;
import cn.org.bjca.gaia.asn1.x509.GeneralNames;
import cn.org.bjca.gaia.cms.CMSSignedDataGenerator;
import cn.org.bjca.gaia.dvcs.DVCSException;
import cn.org.bjca.gaia.dvcs.DVCSRequest;
import java.io.IOException;
import java.math.BigInteger;

public abstract class DVCSRequestBuilder {
    private final ExtensionsGenerator extGenerator = new ExtensionsGenerator();
    private final CMSSignedDataGenerator signedDataGen = new CMSSignedDataGenerator();
    protected final DVCSRequestInformationBuilder requestInformationBuilder;

    protected DVCSRequestBuilder(DVCSRequestInformationBuilder requestInformationBuilder) {
        this.requestInformationBuilder = requestInformationBuilder;
    }

    public void setNonce(BigInteger nonce) {
        this.requestInformationBuilder.setNonce(nonce);
    }

    public void setRequester(GeneralName requester) {
        this.requestInformationBuilder.setRequester(requester);
    }

    public void setDVCS(GeneralName dvcs) {
        this.requestInformationBuilder.setDVCS(dvcs);
    }

    public void setDVCS(GeneralNames dvcs) {
        this.requestInformationBuilder.setDVCS(dvcs);
    }

    public void setDataLocations(GeneralName dataLocation) {
        this.requestInformationBuilder.setDataLocations(dataLocation);
    }

    public void setDataLocations(GeneralNames dataLocations) {
        this.requestInformationBuilder.setDataLocations(dataLocations);
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws DVCSException {
        try {
            this.extGenerator.addExtension(oid, isCritical, value);
        }
        catch (IOException e) {
            throw new DVCSException("cannot encode extension: " + e.getMessage(), e);
        }
    }

    protected DVCSRequest createDVCRequest(Data data) throws DVCSException {
        if (!this.extGenerator.isEmpty()) {
            this.requestInformationBuilder.setExtensions(this.extGenerator.generate());
        }
        cn.org.bjca.gaia.asn1.dvcs.DVCSRequest request = new cn.org.bjca.gaia.asn1.dvcs.DVCSRequest(this.requestInformationBuilder.build(), data);
        return new DVCSRequest(new ContentInfo(DVCSObjectIdentifiers.id_ct_DVCSRequestData, request));
    }
}

