/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.dvcs;

import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.CMSProcessableByteArray;
import cn.org.bjca.gaia.cms.CMSSignedData;
import cn.org.bjca.gaia.cms.CMSSignedDataGenerator;
import cn.org.bjca.gaia.dvcs.DVCSException;
import cn.org.bjca.gaia.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator signedDataGen) {
        this.signedDataGen = signedDataGen;
    }

    public CMSSignedData build(DVCSMessage message) throws DVCSException {
        try {
            byte[] encapsulatedData = message.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(message.getContentType(), encapsulatedData), true);
        }
        catch (CMSException e) {
            throw new DVCSException("Could not sign DVCS request", e);
        }
        catch (IOException e) {
            throw new DVCSException("Could not encode DVCS request", e);
        }
    }
}

