/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.est;

import cn.org.bjca.gaia.cert.X509CRLHolder;
import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.est.ESTRequest;
import cn.org.bjca.gaia.est.Source;
import cn.org.bjca.gaia.util.Store;

public class CACertsResponse {
    private final Store<X509CertificateHolder> store;
    private Store<X509CRLHolder> crlHolderStore;
    private final ESTRequest requestToRetry;
    private final Source session;
    private final boolean trusted;

    public CACertsResponse(Store<X509CertificateHolder> store, Store<X509CRLHolder> crlHolderStore, ESTRequest requestToRetry, Source session, boolean trusted) {
        this.store = store;
        this.requestToRetry = requestToRetry;
        this.session = session;
        this.trusted = trusted;
        this.crlHolderStore = crlHolderStore;
    }

    public boolean hasCertificates() {
        return this.store != null;
    }

    public Store<X509CertificateHolder> getCertificateStore() {
        if (this.store == null) {
            throw new IllegalStateException("Response has no certificates.");
        }
        return this.store;
    }

    public boolean hasCRLs() {
        return this.crlHolderStore != null;
    }

    public Store<X509CRLHolder> getCrlStore() {
        if (this.crlHolderStore == null) {
            throw new IllegalStateException("Response has no CRLs.");
        }
        return this.crlHolderStore;
    }

    public ESTRequest getRequestToRetry() {
        return this.requestToRetry;
    }

    public Object getSession() {
        return this.session.getSession();
    }

    public boolean isTrusted() {
        return this.trusted;
    }
}

