/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.openssl.jcajce;

import cn.org.bjca.gaia.asn1.pkcs.EncryptionScheme;
import cn.org.bjca.gaia.asn1.pkcs.KeyDerivationFunc;
import cn.org.bjca.gaia.asn1.pkcs.PBEParameter;
import cn.org.bjca.gaia.asn1.pkcs.PBES2Parameters;
import cn.org.bjca.gaia.asn1.pkcs.PBKDF2Params;
import cn.org.bjca.gaia.asn1.pkcs.PKCS12PBEParams;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.crypto.CharToByteConverter;
import cn.org.bjca.gaia.jcajce.PBKDF1KeyWithParameters;
import cn.org.bjca.gaia.jcajce.PKCS12KeyWithParameters;
import cn.org.bjca.gaia.jcajce.io.CipherInputStream;
import cn.org.bjca.gaia.jcajce.util.DefaultJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.JcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.NamedJcaJceHelper;
import cn.org.bjca.gaia.jcajce.util.ProviderJcaJceHelper;
import cn.org.bjca.gaia.openssl.PEMException;
import cn.org.bjca.gaia.openssl.jcajce.PEMUtilities;
import cn.org.bjca.gaia.operator.InputDecryptor;
import cn.org.bjca.gaia.operator.InputDecryptorProvider;
import cn.org.bjca.gaia.operator.OperatorCreationException;
import cn.org.bjca.gaia.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] password) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (PEMUtilities.isPKCS5Scheme2(algorithm.getAlgorithm())) {
                        PBES2Parameters params = PBES2Parameters.getInstance(algorithm.getParameters());
                        KeyDerivationFunc func = params.getKeyDerivationFunc();
                        EncryptionScheme scheme = params.getEncryptionScheme();
                        PBKDF2Params defParams = (PBKDF2Params)func.getParameters();
                        int iterationCount = defParams.getIterationCount().intValue();
                        byte[] salt = defParams.getSalt();
                        String oid = scheme.getAlgorithm().getId();
                        SecretKey key = PEMUtilities.isHmacSHA1(defParams.getPrf()) ? PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, oid, password, salt, iterationCount) : PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, oid, password, salt, iterationCount, defParams.getPrf());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(oid);
                        AlgorithmParameters algParams = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(oid);
                        algParams.init(scheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)key, algParams);
                    } else if (PEMUtilities.isPKCS12(algorithm.getAlgorithm())) {
                        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algorithm.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, new PKCS12KeyWithParameters(password, params.getIV(), params.getIterations().intValue()));
                    } else if (PEMUtilities.isPKCS5Scheme1(algorithm.getAlgorithm())) {
                        PBEParameter params = PBEParameter.getInstance(algorithm.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithm.getAlgorithm().getId());
                        cipher.init(2, new PBKDF1KeyWithParameters(password, new CharToByteConverter(){

                            @Override
                            public String getType() {
                                return "ASCII";
                            }

                            @Override
                            public byte[] convert(char[] password) {
                                return Strings.toByteArray(password);
                            }
                        }, params.getSalt(), params.getIterationCount().intValue()));
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithm.getAlgorithm());
                    }
                    return new InputDecryptor(){

                        @Override
                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return algorithm;
                        }

                        @Override
                        public InputStream getInputStream(InputStream encIn) {
                            return new CipherInputStream(encIn, cipher);
                        }
                    };
                }
                catch (IOException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
            }
        };
    }
}

