/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.operator.bc;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.crypto.AsymmetricBlockCipher;
import cn.org.bjca.gaia.crypto.InvalidCipherTextException;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.operator.AsymmetricKeyUnwrapper;
import cn.org.bjca.gaia.operator.GenericKey;
import cn.org.bjca.gaia.operator.OperatorException;

public abstract class BcAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private AsymmetricKeyParameter privateKey;

    public BcAsymmetricKeyUnwrapper(AlgorithmIdentifier encAlgId, AsymmetricKeyParameter privateKey) {
        super(encAlgId);
        this.privateKey = privateKey;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        AsymmetricBlockCipher keyCipher = this.createAsymmetricUnwrapper(this.getAlgorithmIdentifier().getAlgorithm());
        keyCipher.init(false, this.privateKey);
        try {
            byte[] key = keyCipher.processBlock(encryptedKey, 0, encryptedKey.length);
            if (encryptedKeyAlgorithm.getAlgorithm().equals(PKCSObjectIdentifiers.des_EDE3_CBC)) {
                return new GenericKey(encryptedKeyAlgorithm, key);
            }
            return new GenericKey(encryptedKeyAlgorithm, key);
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to recover secret key: " + e.getMessage(), e);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricUnwrapper(ASN1ObjectIdentifier var1);
}

