/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pkcs.bc;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.pkcs.PKCS12PBEParams;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.crypto.BlockCipher;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.ExtendedDigest;
import cn.org.bjca.gaia.crypto.engines.DESedeEngine;
import cn.org.bjca.gaia.crypto.engines.RC2Engine;
import cn.org.bjca.gaia.crypto.generators.PKCS12ParametersGenerator;
import cn.org.bjca.gaia.crypto.io.MacOutputStream;
import cn.org.bjca.gaia.crypto.macs.HMac;
import cn.org.bjca.gaia.crypto.modes.CBCBlockCipher;
import cn.org.bjca.gaia.crypto.paddings.PKCS7Padding;
import cn.org.bjca.gaia.crypto.paddings.PaddedBufferedBlockCipher;
import cn.org.bjca.gaia.crypto.params.DESedeParameters;
import cn.org.bjca.gaia.crypto.params.KeyParameter;
import cn.org.bjca.gaia.crypto.params.ParametersWithIV;
import cn.org.bjca.gaia.operator.GenericKey;
import cn.org.bjca.gaia.operator.MacCalculator;
import cn.org.bjca.gaia.util.Integers;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PKCS12PBEUtils {
    private static Map keySizes = new HashMap();
    private static Set noIvAlgs = new HashSet();
    private static Set desAlgs = new HashSet();

    PKCS12PBEUtils() {
    }

    static int getKeySize(ASN1ObjectIdentifier algorithm) {
        return (Integer)keySizes.get(algorithm);
    }

    static boolean hasNoIv(ASN1ObjectIdentifier algorithm) {
        return noIvAlgs.contains(algorithm);
    }

    static boolean isDesAlg(ASN1ObjectIdentifier algorithm) {
        return desAlgs.contains(algorithm);
    }

    static PaddedBufferedBlockCipher getEngine(ASN1ObjectIdentifier algorithm) {
        BlockCipher engine;
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            engine = new DESedeEngine();
        } else if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC)) {
            engine = new RC2Engine();
        } else {
            throw new IllegalStateException("unknown algorithm");
        }
        return new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
    }

    static MacCalculator createMacCalculator(final ASN1ObjectIdentifier digestAlgorithm, ExtendedDigest digest, final PKCS12PBEParams pbeParams, final char[] password) {
        PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator(digest);
        pGen.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password), pbeParams.getIV(), pbeParams.getIterations().intValue());
        KeyParameter keyParam = (KeyParameter)pGen.generateDerivedMacParameters(digest.getDigestSize() * 8);
        final HMac hMac = new HMac(digest);
        hMac.init(keyParam);
        return new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(digestAlgorithm, pbeParams);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(hMac);
            }

            @Override
            public byte[] getMac() {
                byte[] res = new byte[hMac.getMacSize()];
                hMac.doFinal(res, 0);
                return res;
            }

            @Override
            public GenericKey getKey() {
                return new GenericKey(this.getAlgorithmIdentifier(), PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
            }
        };
    }

    static CipherParameters createCipherParameters(ASN1ObjectIdentifier algorithm, ExtendedDigest digest, int blockSize, PKCS12PBEParams pbeParams, char[] password) {
        CipherParameters params;
        PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator(digest);
        pGen.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password), pbeParams.getIV(), pbeParams.getIterations().intValue());
        if (PKCS12PBEUtils.hasNoIv(algorithm)) {
            params = pGen.generateDerivedParameters(PKCS12PBEUtils.getKeySize(algorithm));
        } else {
            params = pGen.generateDerivedParameters(PKCS12PBEUtils.getKeySize(algorithm), blockSize * 8);
            if (PKCS12PBEUtils.isDesAlg(algorithm)) {
                DESedeParameters.setOddParity(((KeyParameter)((ParametersWithIV)params).getParameters()).getKey());
            }
        }
        return params;
    }

    static {
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4, Integers.valueOf(128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4, Integers.valueOf(40));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, Integers.valueOf(192));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC, Integers.valueOf(128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, Integers.valueOf(128));
        keySizes.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, Integers.valueOf(40));
        noIvAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4);
        noIvAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4);
        desAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
        desAlgs.add(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
    }
}

