/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pkcs.jcajce;

import cn.org.bjca.gaia.asn1.pkcs.PrivateKeyInfo;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.operator.OutputEncryptor;
import cn.org.bjca.gaia.pkcs.PKCS12SafeBagBuilder;
import cn.org.bjca.gaia.pkcs.PKCSIOException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaPKCS12SafeBagBuilder
extends PKCS12SafeBagBuilder {
    public JcaPKCS12SafeBagBuilder(X509Certificate certificate) throws IOException {
        super(JcaPKCS12SafeBagBuilder.convertCert(certificate));
    }

    private static Certificate convertCert(X509Certificate certificate) throws IOException {
        try {
            return Certificate.getInstance(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new PKCSIOException("cannot encode certificate: " + e.getMessage(), e);
        }
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey, OutputEncryptor encryptor) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()), encryptor);
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

