/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.util;

import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.pqc.asn1.PQCObjectIdentifiers;
import cn.org.bjca.gaia.pqc.asn1.SPHINCS256KeyParams;
import cn.org.bjca.gaia.pqc.asn1.XMSSKeyParams;
import cn.org.bjca.gaia.pqc.asn1.XMSSMTKeyParams;
import cn.org.bjca.gaia.pqc.asn1.XMSSMTPublicKey;
import cn.org.bjca.gaia.pqc.asn1.XMSSPublicKey;
import cn.org.bjca.gaia.pqc.crypto.newhope.NHPublicKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.util.Utils;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSPublicKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof QTESLAPublicKeyParameters) {
            QTESLAPublicKeyParameters keyParams = (QTESLAPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(keyParams.getSecurityCategory());
            return new SubjectPublicKeyInfo(algorithmIdentifier, keyParams.getPublicData());
        }
        if (publicKey instanceof SPHINCSPublicKeyParameters) {
            SPHINCSPublicKeyParameters params = (SPHINCSPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(params.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, params.getKeyData());
        }
        if (publicKey instanceof NHPublicKeyParameters) {
            NHPublicKeyParameters params = (NHPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier, params.getPubData());
        }
        if (publicKey instanceof XMSSPublicKeyParameters) {
            XMSSPublicKeyParameters keyParams = (XMSSPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(keyParams.getParameters().getHeight(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(keyParams.getPublicSeed(), keyParams.getRoot()));
        }
        if (publicKey instanceof XMSSMTPublicKeyParameters) {
            XMSSMTPublicKeyParameters keyParams = (XMSSMTPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(keyParams.getParameters().getHeight(), keyParams.getParameters().getLayers(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSMTPublicKey(keyParams.getPublicSeed(), keyParams.getRoot()));
        }
        throw new IOException("key parameters not recognized");
    }
}

