/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.xmss;

import cn.org.bjca.gaia.pqc.crypto.xmss.WOTSPlusParameters;
import cn.org.bjca.gaia.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusSignature {
    private byte[][] signature;

    protected WOTSPlusSignature(WOTSPlusParameters params, byte[][] signature) {
        if (params == null) {
            throw new NullPointerException("params == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (XMSSUtil.hasNullPointer(signature)) {
            throw new NullPointerException("signature byte array == null");
        }
        if (signature.length != params.getLen()) {
            throw new IllegalArgumentException("wrong signature size");
        }
        for (int i = 0; i < signature.length; ++i) {
            if (signature[i].length == params.getDigestSize()) continue;
            throw new IllegalArgumentException("wrong signature format");
        }
        this.signature = XMSSUtil.cloneArray(signature);
    }

    public byte[][] toByteArray() {
        return XMSSUtil.cloneArray(this.signature);
    }
}

