/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.jcajce.provider.newhope;

import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.pqc.crypto.newhope.NHPublicKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.util.PublicKeyFactory;
import cn.org.bjca.gaia.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import cn.org.bjca.gaia.pqc.jcajce.interfaces.NHPublicKey;
import cn.org.bjca.gaia.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCNHPublicKey
implements NHPublicKey {
    private static final long serialVersionUID = 1L;
    private transient NHPublicKeyParameters params;

    public BCNHPublicKey(NHPublicKeyParameters params) {
        this.params = params;
    }

    public BCNHPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.params = (NHPublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BCNHPublicKey)) {
            return false;
        }
        BCNHPublicKey otherKey = (BCNHPublicKey)o;
        return Arrays.areEqual(this.params.getPubData(), otherKey.params.getPubData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getPubData());
    }

    @Override
    public final String getAlgorithm() {
        return "NH";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getPublicData() {
        return this.params.getPubData();
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

