/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.jcajce.provider.sphincs;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.Digest;
import cn.org.bjca.gaia.crypto.digests.SHA3Digest;
import cn.org.bjca.gaia.crypto.digests.SHA512Digest;
import cn.org.bjca.gaia.crypto.digests.SHA512tDigest;
import cn.org.bjca.gaia.pqc.crypto.sphincs.SPHINCS256Signer;
import cn.org.bjca.gaia.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import cn.org.bjca.gaia.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi {
    private final ASN1ObjectIdentifier treeDigest;
    private Digest digest;
    private SPHINCS256Signer signer;
    private SecureRandom random;

    protected SignatureSpi(Digest digest, ASN1ObjectIdentifier treeDigest, SPHINCS256Signer signer) {
        this.digest = digest;
        this.treeDigest = treeDigest;
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        BCSphincs256PublicKey key;
        if (publicKey instanceof BCSphincs256PublicKey) {
            key = (BCSphincs256PublicKey)publicKey;
            if (!this.treeDigest.equals(key.getTreeDigest())) {
                throw new InvalidKeyException("SPHINCS-256 signature for tree digest: " + key.getTreeDigest());
            }
        } else {
            throw new InvalidKeyException("unknown public key passed to SPHINCS-256");
        }
        CipherParameters param = key.getKeyParams();
        this.digest.reset();
        this.signer.init(false, param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        BCSphincs256PrivateKey key;
        if (privateKey instanceof BCSphincs256PrivateKey) {
            key = (BCSphincs256PrivateKey)privateKey;
            if (!this.treeDigest.equals(key.getTreeDigest())) {
                throw new InvalidKeyException("SPHINCS-256 signature for tree digest: " + key.getTreeDigest());
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to SPHINCS-256");
        }
        CipherParameters param = key.getKeyParams();
        this.digest.reset();
        this.signer.init(true, param);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            byte[] sig = this.signer.generateSignature(hash);
            return sig;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return this.signer.verifySignature(hash, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class withSha3_512
    extends SignatureSpi {
        public withSha3_512() {
            super(new SHA3Digest(512), NISTObjectIdentifiers.id_sha3_256, new SPHINCS256Signer(new SHA3Digest(256), new SHA3Digest(512)));
        }
    }

    public static class withSha512
    extends SignatureSpi {
        public withSha512() {
            super(new SHA512Digest(), NISTObjectIdentifiers.id_sha512_256, new SPHINCS256Signer(new SHA512tDigest(256), new SHA512Digest()));
        }
    }
}

