/*
 * Decompiled with CFR 0.152.
 */
package com.uccs;

import com.uccs.AppContext;
import com.uccs.KeyInfo;
import com.uccs.PreRouteUtils;
import com.xjyb.ca.SecureService;
import com.xjyb.config.PasswordServiceConfig;
import com.xjyb.exception.CertificateAPIException;
import com.xjyb.exception.ConfigException;
import com.xjyb.exception.SecureException;
import com.xjyb.model.RcvRouteData;
import com.xjyb.model.SignatureInfo;
import com.xjyb.util.SecureCommonUtil;
import xjyb.com.alibaba.fastjson.JSONObject;

public class SessionEncKeyImpl {
    private final String appId = PasswordServiceConfig.getInstance().getAppid();
    private final String preId = PasswordServiceConfig.getInstance().getPreid();
    private final SecureService secureService = AppContext.getInstance().getSecureService();

    private SessionEncKeyImpl() {
    }

    public static final SessionEncKeyImpl getInstance() {
        return Holder.instance;
    }

    public String initSecureKey(String transId) {
        JSONObject res = new JSONObject(4);
        try {
            if (!this.secureService.checkCertExists()) {
                throw new CertificateAPIException("0101001004001", "\u8bc1\u4e66\u8bfb\u53d6\u5931\u8d25\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\uff01");
            }
            this.initKey(transId);
            res.put("transId", (Object)transId);
            res.put("status", (Object)"0");
            res.put("message", (Object)"success");
        }
        catch (SecureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException("0101001003004", e.getMessage(), e);
        }
        return JSONObject.toJSONString(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKey(String transId) throws SecureException {
        SecureCommonUtil.checkTransId(transId);
        AppContext appContext = AppContext.getInstance();
        SessionEncKeyImpl sessionEncKeyImpl = this;
        synchronized (sessionEncKeyImpl) {
            this.initSecureKey(appContext, transId);
        }
    }

    private void initSecureKey(AppContext appContext, String transId) {
        String random = PreRouteUtils.requestRandom(this.appId, this.preId, transId);
        String signMsg = this.secureService.signatureByPreIDP12(random);
        String encCert = this.secureService.getEncryptCert();
        SignatureInfo si = SignatureInfo.createSM4(signMsg, encCert);
        RcvRouteData resRouteData = PreRouteUtils.requestSymKey(this.appId, this.preId, transId, si);
        resRouteData.checkStatusOk().checkDataNonNull();
        KeyInfo secureKey = KeyInfo.create(resRouteData.getData(), this.secureService);
        appContext.initCurrentKey(secureKey);
    }

    private static final class Holder {
        private static final SessionEncKeyImpl instance = new SessionEncKeyImpl();

        private Holder() {
        }
    }
}

