/*
 * Decompiled with CFR 0.152.
 */
package com.xjyb;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import xjyb.com.alibaba.fastjson.JSONObject;
import xjyb.jarinjarloader.Loader;
import xjyb.net.lingala.zip4j.core.ZipFile;
import xjyb.net.lingala.zip4j.io.ZipInputStream;
import xjyb.net.lingala.zip4j.model.FileHeader;
import xjyb.net.lingala.zip4j.model.ZipParameters;

public class PrePasswordServiceApplication {
    public static void main(String[] args) {
        try {
            if (PrePasswordServiceApplication.checkArgs(args)) {
                PrePasswordServiceApplication.handleArgs(args[0]);
            } else {
                Map<String, String> map = PrePasswordServiceApplication.parseMap(args);
                PrePasswordServiceApplication.updateConfig(map);
                System.out.println("\u66f4\u65b0\u914d\u7f6e\u6587\u4ef6\u6210\u529f\uff0c5\u79d2\u540e\u81ea\u52a8\u5173\u95ed\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void handleArgs(String arg) throws Exception {
        if ("-version".equals(arg) || "-v".equals(arg)) {
            String ver = PrePasswordServiceApplication.class.getPackage().getImplementationVersion();
            System.out.println("cryptofront version: " + ver);
        }
        if ("-properties".equals(arg) || "-p".equals(arg)) {
            PrePasswordServiceApplication.readConfig();
        }
        if ("-properties-all".equals(arg) || "-pa".equals(arg)) {
            PrePasswordServiceApplication.readConfigAll();
        }
        if ("-test".equals(arg) || "-t".equals(arg)) {
            PrePasswordServiceApplication.testInit();
        }
    }

    private static boolean checkArgs(String[] args) {
        if (args != null && args.length == 1) {
            return args[0].startsWith("-");
        }
        return false;
    }

    private static void testInit() throws Exception {
        Thread.currentThread().setContextClassLoader(Loader.getClassLoader());
        Class<?> c = Class.forName("com.uccs.SessionEncKeyImpl", false, Loader.getClassLoader());
        Method getInstanceMethod = c.getMethod("getInstance", new Class[0]);
        Object sek = getInstanceMethod.invoke(null, new Object[0]);
        Method initSecureKey = sek.getClass().getMethod("initSecureKey", String.class);
        String value = (String)initSecureKey.invoke(sek, "00000000000000000000000000000001");
        JSONObject json = JSONObject.parseObject(value);
        int status = json.getIntValue("status");
        if (status == 0) {
            System.out.println("\u521d\u59cb\u5316\u6210\u529f\uff01");
        } else {
            System.out.println("\u521d\u59cb\u5316\u5931\u8d25\uff01");
        }
        System.exit(0);
    }

    private static void readConfig() throws Exception {
        String configName = "config.properties";
        String separator = System.getProperty("line.separator");
        String properties = "";
        String jarPath = URLDecoder.decode(PrePasswordServiceApplication.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
        ZipFile zipFile = new ZipFile(jarPath);
        FileHeader configHeader = zipFile.getFileHeader(configName);
        try (ZipInputStream in = zipFile.getInputStream(configHeader);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line == null || line.trim().length() <= 0 || line.startsWith("#")) continue;
                String key = line.split("=")[0].trim();
                String value = line.substring(line.indexOf("=") + 1, line.length()).trim();
                if ("appid".equalsIgnoreCase(key) || "preid".equalsIgnoreCase(key)) {
                    value = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
                } else if ("certPreKey".equalsIgnoreCase(key) || "certEncryptKey".equalsIgnoreCase(key)) {
                    Class<?> c = Class.forName("com.xjyb.util.SecureCommonUtil", false, Loader.getClassLoader());
                    Method encCertKeyMethod = c.getMethod("decCertKey", String.class);
                    value = (String)encCertKeyMethod.invoke(null, value);
                } else if (!"gateurl".equalsIgnoreCase(key) && !"certurl".equalsIgnoreCase(key) && !"certPreName".equalsIgnoreCase(key) && !"certEncryptName".equalsIgnoreCase(key)) continue;
                line = key + "=" + value;
                properties = properties + line + separator;
            }
        }
        System.out.println(properties);
    }

    private static void readConfigAll() throws Exception {
        String configName = "config.properties";
        String separator = System.getProperty("line.separator");
        String properties = "";
        String jarPath = URLDecoder.decode(PrePasswordServiceApplication.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
        ZipFile zipFile = new ZipFile(jarPath);
        FileHeader configHeader = zipFile.getFileHeader(configName);
        try (ZipInputStream in = zipFile.getInputStream(configHeader);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line == null || line.trim().length() <= 0 || line.startsWith("#")) continue;
                String key = line.split("=")[0].trim();
                String value = line.substring(line.indexOf("=") + 1, line.length()).trim();
                if ("appid".equalsIgnoreCase(key) || "preid".equalsIgnoreCase(key)) {
                    value = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
                }
                if ("certPreKey".equalsIgnoreCase(key) || "certEncryptKey".equalsIgnoreCase(key)) {
                    Class<?> c = Class.forName("com.xjyb.util.SecureCommonUtil", false, Loader.getClassLoader());
                    Method encCertKeyMethod = c.getMethod("decCertKey", String.class);
                    value = (String)encCertKeyMethod.invoke(null, value);
                }
                line = key + "=" + value;
                properties = properties + line + separator;
            }
        }
        System.out.println(properties);
    }

    private static void updateConfig(Map<String, String> map) throws Exception {
        String configName = "config.properties";
        byte[] lineSeparator = System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
        String jarPath = URLDecoder.decode(PrePasswordServiceApplication.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
        ZipFile zipFile = new ZipFile(jarPath);
        FileHeader configHeader = zipFile.getFileHeader(configName);
        ZipParameters parameters = PrePasswordServiceApplication.createZipParameters(configName);
        ByteArrayInputStream bais = null;
        try (ZipInputStream in = zipFile.getInputStream(configHeader);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8));){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line == null || line.trim().length() <= 0) continue;
                String key = line.split("=")[0].trim();
                if (map.containsKey(key)) {
                    String value = map.get(key);
                    PrePasswordServiceApplication.checkKey(key, value);
                    if ("appid".equalsIgnoreCase(key) || "preid".equalsIgnoreCase(key)) {
                        value = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
                    }
                    if ("certPreKey".equalsIgnoreCase(key) || "certEncryptKey".equalsIgnoreCase(key)) {
                        Class<?> c = Class.forName("com.xjyb.util.SecureCommonUtil", false, Loader.getClassLoader());
                        Method encCertKeyMethod = c.getMethod("encCertKey", String.class);
                        value = (String)encCertKeyMethod.invoke(null, value);
                    }
                    line = key + "=" + value;
                }
                baos.write(line.getBytes(StandardCharsets.UTF_8));
                baos.write(lineSeparator);
            }
            bais = new ByteArrayInputStream(baos.toByteArray());
        }
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            zipFile.removeFile(configName);
        }
        zipFile.addStream(bais, parameters);
    }

    private static ZipParameters createZipParameters(String name) {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setSourceExternalStream(true);
        parameters.setFileNameInZip(name);
        return parameters;
    }

    private static Map<String, String> parseMap(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            throw new Exception("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u6b63\u786e\u53c2\u6570\u683c\u5f0f\u3010key1=value1 key2=value2\u3011");
        }
        String[] keyVals = args;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keyVal : keyVals) {
            if (keyVal == null || keyVal.trim().length() == 0) continue;
            String[] tmp = keyVal.trim().split("=");
            if (tmp.length == 1) {
                map.put(tmp[0], "");
                continue;
            }
            if (tmp.length == 2) {
                map.put(tmp[0], keyVal.trim().substring(keyVal.trim().indexOf("=") + 1));
                continue;
            }
            throw new Exception("\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff01\u6b63\u786e\u53c2\u6570\u683c\u5f0f\u3010key1=value1 key2=value2\u3011");
        }
        return map;
    }

    private static void checkKey(String key, String value) {
        switch (key) {
            case "appid": {
                if (value.length() != 32) {
                    throw new IllegalArgumentException("appid\u957f\u5ea6\u5fc5\u987b\u662f32\u4f4d\uff01");
                }
                if (value.matches("^[0-9a-fA-F]{32}$")) break;
                throw new IllegalArgumentException("appid\u5fc5\u987b\u662f16\u8fdb\u5236\u5b57\u7b26\u4e32\uff01");
            }
            case "preid": {
                if (value.length() != 32) {
                    throw new IllegalArgumentException("preid\u957f\u5ea6\u5fc5\u987b\u662f32\u4f4d\uff01");
                }
                if (value.matches("^[0-9a-fA-F]{32}$")) break;
                throw new IllegalArgumentException("preid\u5fc5\u987b\u662f16\u8fdb\u5236\u5b57\u7b26\u4e32\uff01");
            }
            case "gateurl": {
                if (value.startsWith("http://") || value.startsWith("https://")) break;
                throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684gateurl\u5730\u5740\uff01");
            }
        }
    }
}

