/*
 * Decompiled with CFR 0.152.
 */
package com.xjyb.ca.sansec;

import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.cert.BjcaCert;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.security.Gaia;
import cn.org.bjca.gaia.assemb.util.CertificateUtil;
import cn.org.bjca.gaia.assemb.util.Pkcs7Util;
import com.owca.asn1.ASN1Boolean;
import com.owca.asn1.ASN1Encodable;
import com.owca.asn1.ASN1EncodableVector;
import com.owca.asn1.ASN1GeneralizedTime;
import com.owca.asn1.ASN1InputStream;
import com.owca.asn1.ASN1Integer;
import com.owca.asn1.ASN1ObjectIdentifier;
import com.owca.asn1.ASN1OctetString;
import com.owca.asn1.ASN1Primitive;
import com.owca.asn1.ASN1Sequence;
import com.owca.asn1.ASN1SequenceParser;
import com.owca.asn1.ASN1Set;
import com.owca.asn1.ASN1TaggedObject;
import com.owca.asn1.ASN1UTCTime;
import com.owca.asn1.DERBoolean;
import com.owca.asn1.DERNull;
import com.owca.asn1.DEROctetString;
import com.owca.asn1.DERPrintableString;
import com.owca.asn1.DERSequence;
import com.owca.asn1.DERUTF8String;
import com.owca.asn1.gm.GMObjectIdentifiers;
import com.owca.cert.jcajce.JcaCertStore;
import com.owca.cms.CMSProcessableByteArray;
import com.owca.cms.CMSSignedData;
import com.owca.cms.CMSSignedDataGenerator;
import com.owca.cms.CMSTypedData;
import com.owca.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.owca.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.owca.jce.provider.BouncyCastleProvider;
import com.owca.math.ec.ECPoint;
import com.owca.operator.ContentSigner;
import com.owca.operator.jcajce.JcaContentSignerBuilder;
import com.owca.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import com.owca.util.Store;
import com.owca.util.encoders.Base64;
import com.xjyb.ca.SecureService;
import com.xjyb.ca.sansec.SansecCertificateConfig;
import com.xjyb.ca.sansec.WrapCardUtil;
import com.xjyb.ca.sansec.restful.CreateTsRequest;
import com.xjyb.ca.sansec.util.Util;
import com.xjyb.config.PasswordServiceConfig;
import com.xjyb.exception.CertificateAPIException;
import com.xjyb.exception.InvalidArgumentException;
import com.xjyb.util.SecureCommonUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javassist.bytecode.ClassFile;
import org.cn.sansec.define.CNInterface;
import org.cn.sansec.define.CNInterfaceimpl;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import xjyb.cn.org.bjca.security.SecurityUtil;

public class SansecSecureServiceImpl
implements SecureService {
    private final SansecCertificateConfig certificateInfo;
    private final CNInterface cnInterface = new CNInterfaceimpl();
    private final SecurityUtil bjcaInstance = SecurityUtil.getInstance();
    public static final String iv = "00000000000000000000000000000000";

    public SansecSecureServiceImpl(SansecCertificateConfig certificateConfig) {
        this.certificateInfo = certificateConfig;
    }

    @Override
    public boolean validateSignature(String plainData, String signData) throws CertificateAPIException {
        try {
            return this.cnInterface.verifySignWithCert(plainData.getBytes(StandardCharsets.UTF_8), signData, "CERT_PRE_ID_P12");
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String signatureByUKey(String json) throws CertificateAPIException {
        return json;
    }

    @Override
    public String signatureByPreIDP12(String data) throws CertificateAPIException {
        try {
            String signData = this.cnInterface.p7Sign(data.getBytes(StandardCharsets.UTF_8), "CERT_PRE_ID_P12");
            return signData;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] decryptByEncryptP12(byte[] key) throws CertificateAPIException {
        try {
            byte[] resultDecry = this.cnInterface.decryptWithCert("CERT_ENCRYPT_KEY_P12", key);
            return resultDecry;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] decryptByKey(byte[] key, byte[] encd, byte[] iv) throws CertificateAPIException {
        try {
            byte[] decryBytes = this.cnInterface.symmetryDecryptByte(key, "2", "2", iv, encd, true);
            return decryBytes;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String decryptByEnck(byte[] enck, String data, byte[] iv) throws CertificateAPIException {
        byte[] dataBytes = java.util.Base64.getDecoder().decode(data);
        try {
            byte[] decryBytes = this.cnInterface.symmetryDecryptByte(enck, "2", "2", iv, dataBytes, true);
            return new String(decryBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encryptByEncryptKeyP12(byte[] key) throws CertificateAPIException {
        try {
            byte[] resultEncry = this.cnInterface.encryptWithCert("CERT_ENCRYPT_KEY_P12", key);
            return resultEncry;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String encryptByEnck(byte[] enck, String data, byte[] iv) throws CertificateAPIException {
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] encryptData = this.cnInterface.symmetryEncryptByte(enck, "2", "2", iv, dataBytes, true);
            return java.util.Base64.getEncoder().encodeToString(encryptData);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String encryptByMak(byte[] mak, String data, byte[] iv) throws CertificateAPIException {
        try {
            byte[] calculateMAC = this.cnInterface.calculateMACByte(mak, "2", "2", iv, java.util.Base64.getDecoder().decode(data));
            return SecureCommonUtil.bytesToHexString(calculateMAC);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    public boolean verifyMAC(byte[] mak, String macData, byte[] iv, String mac) {
        try {
            byte[] macBytes = SecureCommonUtil.stringToBytes(mac);
            return this.cnInterface.verifyMACByte(mak, "2", "2", iv, macData.getBytes(StandardCharsets.UTF_8), macBytes);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String encryptByKey(byte[] key, String encd, byte[] iv) throws CertificateAPIException {
        byte[] encdData = encd.getBytes(StandardCharsets.UTF_8);
        try {
            return java.util.Base64.getEncoder().encodeToString(this.cnInterface.symmetryEncryptByte(key, "2", "2", iv, encdData, true));
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encryptBySessionKeyP12(byte[] key) {
        try {
            byte[] resultEncry = this.cnInterface.encryptWithCert("CERT_SESSION_KEY_P12", key);
            return resultEncry;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String createCsr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSessionPk() {
        try {
            return this.cnInterface.getPubKeyWithCert("CERT_SESSION_KEY_P12");
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String getEncryptPk() {
        try {
            return this.cnInterface.getPubKeyWithCert("CERT_ENCRYPT_KEY_P12");
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public boolean checkCertExists() {
        try {
            PasswordServiceConfig config = PasswordServiceConfig.getInstance();
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (config.getCerturl().equals("classpath/") || config.getCerturl().equals("classpath\\")) {
                this.cnInterface.initLoadCert(SansecSecureServiceImpl.readFileByBytes(this.certificateInfo.getCertPrePath()), this.certificateInfo.getCertPreKey(), "CERT_PRE_ID_P12");
                this.cnInterface.initLoadCert(SansecSecureServiceImpl.readFileByBytes(this.certificateInfo.getCertEncryptPath()), this.certificateInfo.getCertEncryptKey(), "CERT_ENCRYPT_KEY_P12");
            } else {
                this.cnInterface.initLoadCert(this.certificateInfo.getCertPrePath(), this.certificateInfo.getCertPreKey(), "CERT_PRE_ID_P12");
                this.cnInterface.initLoadCert(this.certificateInfo.getCertEncryptPath(), this.certificateInfo.getCertEncryptKey(), "CERT_ENCRYPT_KEY_P12");
            }
            return true;
        }
        catch (Exception e) {
            throw new CertificateAPIException("0101001004001", "\u8bc1\u4e66\u8bfb\u53d6\u5931\u8d25\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\uff01", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileByBytes(String fileName) throws IOException {
        InputStream fstream = ClassFile.class.getClassLoader().getResourceAsStream(fileName);
        int localAvailable = fstream.available();
        byte[] data = new byte[localAvailable];
        try {
            fstream.read(data);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fstream.close();
            }
            catch (IOException iOException) {}
        }
        return data;
    }

    @Override
    public String getEncryptCert() {
        try {
            return this.cnInterface.getCertWithType("CERT_ENCRYPT_KEY_P12");
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] decryptKey(byte[] key, String transId) {
        try {
            return this.cnInterface.deriveKey(key, transId, 1);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public boolean verifyMAC(byte[] key, byte[] iv, String macData, String mac) {
        try {
            byte[] macDataBytes = java.util.Base64.getDecoder().decode(macData);
            byte[] macBytes = SecureCommonUtil.stringToBytes(mac);
            return this.cnInterface.verifyMACByte(key, "2", "2", iv, macDataBytes, macBytes);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] decryptKeyBLob(byte[] key) throws CertificateAPIException {
        try {
            byte[] resultDecry = this.cnInterface.pkcs7Decrypt(key, "CERT_ENCRYPT_KEY_P12");
            return resultDecry;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String calcHash(String file) {
        try {
            byte[] sm3s = this.bjcaInstance.hash_byte(java.util.Base64.getDecoder().decode(file), "SM3");
            return java.util.Base64.getEncoder().encodeToString(sm3s);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String calcHash(String file, String pubKey) {
        try {
            byte[] bytes = this.bjcaInstance.hash_byte(java.util.Base64.getDecoder().decode(file), java.util.Base64.getDecoder().decode(pubKey));
            return java.util.Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String getPubKey(String cert) {
        String pubKey;
        try {
            pubKey = this.bjcaInstance.getCertInfo(cert, 30);
        }
        catch (Exception e) {
            throw new InvalidArgumentException("\u8bc1\u4e66\uff1a\u3010" + cert + "\u3011\u975e\u6cd5\uff0c\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u8bc1\u4e66\u4fe1\u606f\uff01", e);
        }
        if (pubKey == null) {
            throw new InvalidArgumentException("\u8bc1\u4e66\uff1a\u3010" + cert + "\u3011\u975e\u6cd5\uff0c\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u8bc1\u4e66\u4fe1\u606f\uff01");
        }
        return pubKey;
    }

    @Override
    public String envelopedData(String p12Cert, String jsonData) {
        try {
            String p7Envelop = this.bjcaInstance.encodeP7EnvelopedData(p12Cert, jsonData.getBytes(StandardCharsets.UTF_8));
            return p7Envelop;
        }
        catch (Exception e) {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String p10GeneratorHash(String dn, String pubKey) {
        try {
            byte[] publicKey = java.util.Base64.getDecoder().decode(pubKey);
            WrapCardUtil util = new WrapCardUtil();
            String strBase64P10 = util.p10GeneratorHash(dn, null, publicKey);
            return strBase64P10;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String p10GeneratorString(String dn, String pubKey, String sign) {
        try {
            byte[] publicKey = java.util.Base64.getDecoder().decode(pubKey);
            WrapCardUtil util = new WrapCardUtil();
            String strBase64P10 = util.p10GeneratorString_SM2ForDZHT(dn, publicKey, sign);
            return strBase64P10;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String[] getGenKeyPairs() {
        try {
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
            kpg.initialize(sm2Spec);
            kpg.initialize(sm2Spec, new SecureRandom());
            KeyPair keyPair = kpg.generateKeyPair();
            PublicKey pubKey = keyPair.getPublic();
            PrivateKey priKey = keyPair.getPrivate();
            BCECPublicKey ecpub = (BCECPublicKey)pubKey;
            ECPoint publicKey = ecpub.getQ();
            byte[] pubbytes = publicKey.getEncoded(false);
            if (pubbytes.length == 65) {
                pubbytes = Arrays.copyOfRange(pubbytes, 1, pubbytes.length);
            }
            String pubstr = java.util.Base64.getEncoder().encodeToString(pubbytes);
            String pristr = java.util.Base64.getEncoder().encodeToString(priKey.getEncoded());
            String[] genKeyPairs = new String[]{pubstr, pristr};
            return genKeyPairs;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String getSignHash(String privateKey, String hash) {
        try {
            byte[] makePrivateKey = java.util.Base64.getDecoder().decode(privateKey);
            KeyFactory keyFact = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
            PrivateKey priv = keyFact.generatePrivate(new PKCS8EncodedKeySpec(makePrivateKey));
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)new BouncyCastleProvider());
            signature.initSign(priv);
            signature.update(java.util.Base64.getDecoder().decode(hash));
            byte[] signatureValue = signature.sign();
            String signHash = java.util.Base64.getEncoder().encodeToString(signatureValue);
            return signHash;
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    @Override
    public String getGenPkcs7(String newP10, String cst, String privateKey) {
        try {
            byte[] data = newP10.getBytes(StandardCharsets.UTF_8);
            KeyFactory keyFact = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
            PrivateKey priv = keyFact.generatePrivate(new PKCS8EncodedKeySpec(java.util.Base64.getDecoder().decode(privateKey)));
            CertificateFactory fact = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            ByteArrayInputStream sbs = new ByteArrayInputStream(java.util.Base64.getDecoder().decode(cst));
            X509Certificate cerx509 = (X509Certificate)fact.generateCertificate(sbs);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(cerx509);
            JcaCertStore certs = new JcaCertStore(certList);
            ContentSigner contentSigner = new JcaContentSignerBuilder(cerx509.getSigAlgName()).setProvider((Provider)new BouncyCastleProvider()).build(priv);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build()).setDirectSignature(true).build(contentSigner, cerx509));
            gen.addCertificates((Store)certs);
            CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
            CMSSignedData sigData = gen.generate((CMSTypedData)msg, true);
            return java.util.Base64.getEncoder().encodeToString(sigData.toASN1Structure().getEncoded("DER"));
        }
        catch (Exception e) {
            throw new CertificateAPIException(e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getDecryptPrivateKey(String signCertPrivateKey, String encPrivateKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getCreateTsRequest(String requestType, String hashAlgorithm, String inData) {
        Integer id = 1;
        Integer ran = 1;
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            ran = random.nextInt(10000);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        Boolean bl = false;
        if (requestType.equals("1")) {
            bl = true;
        }
        String s = null;
        if (hashAlgorithm.equals("0")) {
            s = "1.2.156.10197.1.401";
        } else if (hashAlgorithm.equals("3")) {
            s = "1.3.14.3.2.26";
        } else if (hashAlgorithm.equals("4")) {
            s = "2.16.840.1.101.3.4.2.1";
        }
        String s1 = "1.3.6.1.4.1.6449.2.1.1";
        String data = null;
        try {
            Oid o = new Oid(s);
            o = new Oid(o.getDER());
            s = o.toString();
            Oid o1 = new Oid(s1);
            o1 = new Oid(o1.getDER());
            s1 = o1.toString();
            ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
            asn1EncodableVector.add((ASN1Encodable)new ASN1ObjectIdentifier(s));
            asn1EncodableVector.add((ASN1Encodable)new DERNull());
            ASN1EncodableVector asn1EncodableVector2 = new ASN1EncodableVector();
            asn1EncodableVector2.add((ASN1Encodable)new DERSequence(asn1EncodableVector));
            byte[] arg0 = java.util.Base64.getDecoder().decode(inData);
            asn1EncodableVector2.add((ASN1Encodable)new DEROctetString(arg0));
            CreateTsRequest ctr = new CreateTsRequest(new ASN1Integer((long)id.intValue()), (ASN1Sequence)new DERSequence(asn1EncodableVector2), new ASN1ObjectIdentifier(s1), new ASN1Integer((long)ran.intValue()), (ASN1Boolean)new DERBoolean(bl.booleanValue()));
            data = Base64.toBase64String((byte[])ctr.getEncoded());
        }
        catch (GSSException e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public String getVerifyTsValidity(String timestampResponse, String hashAlgorithm, String signAlgorithm) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTsInfo(String timestampResponse) {
        ArrayList<String> list = new ArrayList<String>();
        String utctime = "";
        String tsa = "";
        byte[] data = Base64.decode((String)timestampResponse);
        ASN1InputStream ais = new ASN1InputStream(data);
        ASN1Primitive primitive = null;
        ASN1InputStream a = null;
        try {
            while ((primitive = ais.readObject()) != null) {
                if (!(primitive instanceof ASN1Sequence)) continue;
                ASN1Sequence sequence = (ASN1Sequence)primitive;
                ASN1SequenceParser parser = sequence.parser();
                ASN1Encodable encodable = null;
                while ((encodable = parser.readObject()) != null) {
                    primitive = encodable.toASN1Primitive();
                    if (!(primitive instanceof ASN1Sequence)) continue;
                    ASN1Sequence sequence1 = (ASN1Sequence)primitive;
                    ASN1SequenceParser parser1 = sequence1.parser();
                    ASN1Encodable encodable1 = null;
                    while ((encodable1 = parser1.readObject()) != null) {
                        primitive = encodable1.toASN1Primitive();
                        if (!(primitive instanceof ASN1TaggedObject)) continue;
                        ASN1TaggedObject obj = (ASN1TaggedObject)primitive;
                        ASN1Sequence sequence2 = (ASN1Sequence)obj.getObjectParser(0, true);
                        ASN1SequenceParser parser2 = sequence2.parser();
                        ASN1Encodable encodable2 = null;
                        while ((encodable2 = parser2.readObject()) != null) {
                            primitive = encodable2.toASN1Primitive();
                            if (primitive instanceof ASN1TaggedObject) {
                                ASN1TaggedObject obj21 = (ASN1TaggedObject)primitive;
                                ASN1Sequence sequence21 = (ASN1Sequence)obj21.getObjectParser(0, true);
                                ASN1SequenceParser parser21 = sequence21.parser();
                                ASN1Encodable encodable21 = null;
                                while ((encodable21 = parser21.readObject()) != null) {
                                    primitive = encodable21.toASN1Primitive();
                                    if (!(primitive instanceof ASN1Sequence)) continue;
                                    ASN1Sequence sequence22 = (ASN1Sequence)primitive;
                                    ASN1SequenceParser parser22 = sequence22.parser();
                                    ASN1Encodable encodable22 = null;
                                    while ((encodable22 = parser22.readObject()) != null) {
                                        primitive = encodable22.toASN1Primitive();
                                        if (primitive instanceof ASN1Sequence) {
                                            ASN1Sequence sequence23 = (ASN1Sequence)primitive;
                                            ASN1SequenceParser parser23 = sequence23.parser();
                                            ASN1Encodable encodable23 = null;
                                            while ((encodable23 = parser23.readObject()) != null) {
                                                primitive = encodable23.toASN1Primitive();
                                                if (!(primitive instanceof ASN1Set)) continue;
                                                ASN1Set string1 = (ASN1Set)primitive;
                                                ASN1Sequence sequence5 = (ASN1Sequence)string1.getObjectAt(0);
                                                ASN1SequenceParser parser5 = sequence5.parser();
                                                ASN1Encodable encodable5 = null;
                                                while ((encodable5 = parser5.readObject()) != null) {
                                                    ASN1ObjectIdentifier string;
                                                    primitive = encodable5.toASN1Primitive();
                                                    if (primitive instanceof ASN1ObjectIdentifier) {
                                                        string = (ASN1ObjectIdentifier)primitive;
                                                        list.add(string.getId());
                                                    }
                                                    if (primitive instanceof DERUTF8String) {
                                                        string = (DERUTF8String)primitive;
                                                        list.add(string.getString());
                                                    }
                                                    if (!(primitive instanceof DERPrintableString)) continue;
                                                    string = (DERPrintableString)primitive;
                                                    list.add(string.getString());
                                                }
                                            }
                                        }
                                        if (!(primitive instanceof ASN1GeneralizedTime)) continue;
                                        list.clear();
                                    }
                                }
                                continue;
                            }
                            if (!(primitive instanceof ASN1Sequence)) continue;
                            ASN1Sequence sequence31 = (ASN1Sequence)primitive;
                            ASN1SequenceParser parser31 = sequence31.parser();
                            ASN1Encodable encodable31 = null;
                            while ((encodable31 = parser31.readObject()) != null) {
                                primitive = encodable31.toASN1Primitive();
                                if (!(primitive instanceof ASN1TaggedObject)) continue;
                                ASN1TaggedObject obj1 = (ASN1TaggedObject)primitive;
                                ASN1OctetString obj2 = (ASN1OctetString)obj1.getObjectParser(0, true);
                                a = new ASN1InputStream(obj2.getOctetStream());
                                primitive = a.readObject();
                                ASN1Sequence sequence4 = (ASN1Sequence)primitive;
                                ASN1SequenceParser parser4 = sequence4.parser();
                                ASN1Encodable encodable4 = null;
                                while ((encodable4 = parser4.readObject()) != null) {
                                    primitive = encodable4.toASN1Primitive();
                                    if (!(primitive instanceof ASN1GeneralizedTime)) continue;
                                    utctime = ((ASN1GeneralizedTime)primitive).getTime();
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (a != null) {
                try {
                    a.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String stringDate = utctime = utctime.substring(0, 18);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        Date date = null;
        try {
            date = sdf.parse(stringDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        HashMap hm = new HashMap();
        for (int i = 0; i < list.size(); i += 2) {
            hm.put(list.get(i), list.get(i + 1));
        }
        String str1 = (String)hm.get("2.5.4.3");
        String str2 = sdf.format(date);
        if (str1 == null) {
            str1 = "error";
        }
        String[] str = new String[]{str1, str2};
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTsDetail(String timestampResponse, String itemNumber) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> list1 = new ArrayList<String>();
        String cer = "";
        String utctime = "";
        byte[] data = Base64.decode((String)timestampResponse);
        ASN1InputStream ais = new ASN1InputStream(data);
        ASN1Primitive primitive = null;
        ASN1InputStream a = null;
        try {
            while ((primitive = ais.readObject()) != null) {
                if (!(primitive instanceof ASN1Sequence)) continue;
                ASN1Sequence sequence = (ASN1Sequence)primitive;
                ASN1SequenceParser parser = sequence.parser();
                ASN1Encodable encodable = null;
                while ((encodable = parser.readObject()) != null) {
                    primitive = encodable.toASN1Primitive();
                    if (!(primitive instanceof ASN1Sequence)) continue;
                    ASN1Sequence sequence1 = (ASN1Sequence)primitive;
                    ASN1SequenceParser parser1 = sequence1.parser();
                    ASN1Encodable encodable1 = null;
                    while ((encodable1 = parser1.readObject()) != null) {
                        primitive = encodable1.toASN1Primitive();
                        if (!(primitive instanceof ASN1TaggedObject)) continue;
                        ASN1TaggedObject obj = (ASN1TaggedObject)primitive;
                        ASN1Sequence sequence2 = (ASN1Sequence)obj.getObjectParser(0, true);
                        ASN1SequenceParser parser2 = sequence2.parser();
                        ASN1Encodable encodable2 = null;
                        while ((encodable2 = parser2.readObject()) != null) {
                            primitive = encodable2.toASN1Primitive();
                            if (primitive instanceof ASN1Sequence) {
                                ASN1Sequence sequence31 = (ASN1Sequence)primitive;
                                ASN1SequenceParser parser31 = sequence31.parser();
                                ASN1Encodable encodable31 = null;
                                while ((encodable31 = parser31.readObject()) != null) {
                                    primitive = encodable31.toASN1Primitive();
                                    if (!(primitive instanceof ASN1TaggedObject)) continue;
                                    ASN1TaggedObject obj1 = (ASN1TaggedObject)primitive;
                                    ASN1OctetString obj2 = (ASN1OctetString)obj1.getObjectParser(0, true);
                                    a = new ASN1InputStream(obj2.getOctetStream());
                                    primitive = a.readObject();
                                    ASN1Sequence sequence4 = (ASN1Sequence)primitive;
                                    ASN1SequenceParser parser4 = sequence4.parser();
                                    ASN1Encodable encodable4 = null;
                                    while ((encodable4 = parser4.readObject()) != null) {
                                        primitive = encodable4.toASN1Primitive();
                                        if (!(primitive instanceof ASN1GeneralizedTime)) continue;
                                        utctime = ((ASN1GeneralizedTime)primitive).getTime();
                                    }
                                }
                                continue;
                            }
                            if (!(primitive instanceof ASN1TaggedObject)) continue;
                            ASN1TaggedObject obj1 = (ASN1TaggedObject)primitive;
                            ASN1Sequence sequence21 = (ASN1Sequence)obj1.getObjectParser(0, true);
                            cer = java.util.Base64.getEncoder().encodeToString(sequence21.getEncoded());
                            ASN1Sequence sequence22 = (ASN1Sequence)obj1.getObjectParser(0, true);
                            ASN1SequenceParser parser22 = sequence22.parser();
                            ASN1Encodable encodable22 = null;
                            block19: while ((encodable22 = parser22.readObject()) != null) {
                                primitive = encodable22.toASN1Primitive();
                                if (!(primitive instanceof ASN1Sequence)) continue;
                                ASN1Sequence sequence3 = (ASN1Sequence)primitive;
                                ASN1SequenceParser parser3 = sequence3.parser();
                                ASN1Encodable encodable3 = null;
                                while ((encodable3 = parser3.readObject()) != null) {
                                    primitive = encodable3.toASN1Primitive();
                                    if (primitive instanceof ASN1Sequence) {
                                        ASN1Sequence sequence4 = (ASN1Sequence)primitive;
                                        ASN1SequenceParser parser4 = sequence4.parser();
                                        ASN1Encodable encodable4 = null;
                                        while ((encodable4 = parser4.readObject()) != null) {
                                            primitive = encodable4.toASN1Primitive();
                                            if (!(primitive instanceof ASN1Set)) continue;
                                            ASN1Set string1 = (ASN1Set)primitive;
                                            ASN1Sequence sequence5 = (ASN1Sequence)string1.getObjectAt(0);
                                            ASN1SequenceParser parser5 = sequence5.parser();
                                            ASN1Encodable encodable5 = null;
                                            while ((encodable5 = parser5.readObject()) != null) {
                                                ASN1ObjectIdentifier string;
                                                primitive = encodable5.toASN1Primitive();
                                                if (primitive instanceof ASN1ObjectIdentifier) {
                                                    string = (ASN1ObjectIdentifier)primitive;
                                                    list.add(string.getId());
                                                }
                                                if (primitive instanceof DERUTF8String) {
                                                    string = (DERUTF8String)primitive;
                                                    list.add(string.getString());
                                                }
                                                if (!(primitive instanceof DERPrintableString)) continue;
                                                string = (DERPrintableString)primitive;
                                                list.add(string.getString());
                                            }
                                        }
                                    }
                                    if (!(primitive instanceof ASN1GeneralizedTime) && !(primitive instanceof ASN1UTCTime)) continue;
                                    continue block19;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (a != null) {
                try {
                    a.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String stringDate = utctime = utctime.substring(0, 18);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        Date date = null;
        try {
            date = sdf.parse(stringDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        HashMap hm = new HashMap();
        for (int i = 0; i < list.size(); i += 2) {
            hm.put(list.get(i), list.get(i + 1));
        }
        list1.add(sdf.format(date));
        list1.add((String)hm.get("2.5.4.3"));
        list1.add("");
        list1.add(cer);
        list1.add("");
        list1.add("");
        list1.add("");
        list1.add("");
        list1.add((String)hm.get("2.5.4.6"));
        list1.add((String)hm.get("2.5.4.11"));
        list1.add((String)hm.get("2.5.4.7"));
        list1.add((String)hm.get("1.2.840.113549.1.9.1"));
        String itemValue = "";
        itemValue = list1.get(Integer.parseInt(itemNumber)) == null || ((String)list1.get(Integer.parseInt(itemNumber))).equals("") ? "error" : (String)list1.get(Integer.parseInt(itemNumber));
        return itemValue;
    }

    @Override
    public boolean hashSignVerify(String reqDocHash, String signValue) {
        boolean ret = false;
        ArrayList<String> list = new ArrayList<String>();
        try {
            GaiaProvider provider = null;
            Gaia sec = Gaia.getInstance();
            sec.initProvider("BJCAJE");
            provider = sec.openProvider("BJCAJE");
            Pkcs7Util pkcs7Util = new Pkcs7Util(provider);
            byte[] sign = java.util.Base64.getDecoder().decode(signValue);
            byte[] hash = java.util.Base64.getDecoder().decode(reqDocHash);
            ASN1InputStream ais = new ASN1InputStream(sign);
            ASN1Primitive primitive = null;
            while ((primitive = ais.readObject()) != null) {
                if (!(primitive instanceof ASN1Sequence)) continue;
                ASN1Sequence sequence = (ASN1Sequence)primitive;
                ASN1SequenceParser parser = sequence.parser();
                ASN1Encodable encodable = null;
                while ((encodable = parser.readObject()) != null) {
                    primitive = encodable.toASN1Primitive();
                    if (!(primitive instanceof ASN1TaggedObject)) continue;
                    ASN1TaggedObject obj1 = (ASN1TaggedObject)primitive;
                    ASN1Sequence sequence1 = (ASN1Sequence)obj1.getObjectParser(0, true);
                    ASN1SequenceParser parser1 = sequence1.parser();
                    ASN1Encodable encodable1 = null;
                    while ((encodable1 = parser1.readObject()) != null) {
                        primitive = encodable1.toASN1Primitive();
                        if (!(primitive instanceof ASN1TaggedObject)) continue;
                        ASN1TaggedObject obj2 = (ASN1TaggedObject)primitive;
                        ASN1Sequence sequence2 = (ASN1Sequence)obj2.getObjectParser(0, true);
                        ASN1SequenceParser parser2 = sequence2.parser();
                        ASN1Encodable encodable2 = null;
                        while ((encodable2 = parser2.readObject()) != null) {
                            primitive = encodable2.toASN1Primitive();
                            if (!(primitive instanceof ASN1Sequence)) continue;
                            ASN1Sequence sequence3 = (ASN1Sequence)primitive;
                            ASN1SequenceParser parser3 = sequence3.parser();
                            ASN1Encodable encodable3 = null;
                            while ((encodable3 = parser3.readObject()) != null) {
                                primitive = encodable3.toASN1Primitive();
                                if (!(primitive instanceof ASN1Sequence)) continue;
                                ASN1Sequence sequence4 = (ASN1Sequence)primitive;
                                ASN1SequenceParser parser4 = sequence4.parser();
                                ASN1Encodable encodable4 = null;
                                while ((encodable4 = parser4.readObject()) != null) {
                                    primitive = encodable4.toASN1Primitive();
                                    if (!(primitive instanceof ASN1UTCTime)) continue;
                                    ASN1UTCTime obj5 = (ASN1UTCTime)primitive;
                                    list.add(obj5.getAdjustedTime());
                                }
                            }
                        }
                    }
                }
            }
            String stringDate1 = ((String)list.get(0)).substring(0, 14);
            String stringDate2 = ((String)list.get(1)).substring(0, 14);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date1 = sdf.parse(stringDate1);
            Date date2 = sdf.parse(stringDate2);
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date time = new Date(System.currentTimeMillis());
            sdf.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
            String current = sdf.format(time);
            if (sdf.parse(current).getTime() <= sdf.parse(sdf.format(date1)).getTime() || sdf.parse(current).getTime() >= sdf.parse(sdf.format(date2)).getTime()) {
                return ret;
            }
            byte[] hashSignVerify = pkcs7Util.verifyPkcs7SignDigest(sign, hash);
            if (hashSignVerify == null) {
                return ret;
            }
            ret = true;
        }
        catch (PkiException e) {
            e.printStackTrace();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
        return ret;
    }

    @Override
    public boolean hashSignVerifyP1(String serviceCode, String reqDocHash, String signValue, String signCert) {
        boolean ret = false;
        ArrayList<String> list = new ArrayList<String>();
        try {
            Util util = new Util();
            GaiaProvider provider = null;
            Gaia sec = Gaia.getInstance();
            sec.initProvider("BJCAJE");
            provider = sec.openProvider("BJCAJE");
            BjcaCert cert = CertificateUtil.createCert(java.util.Base64.getDecoder().decode(signCert));
            ASN1InputStream ais = new ASN1InputStream(java.util.Base64.getDecoder().decode(signCert));
            ASN1Primitive primitive = null;
            while ((primitive = ais.readObject()) != null) {
                if (!(primitive instanceof ASN1Sequence)) continue;
                ASN1Sequence sequence = (ASN1Sequence)primitive;
                ASN1SequenceParser parser = sequence.parser();
                ASN1Encodable encodable = null;
                while ((encodable = parser.readObject()) != null) {
                    primitive = encodable.toASN1Primitive();
                    if (!(primitive instanceof ASN1Sequence)) continue;
                    ASN1Sequence sequence1 = (ASN1Sequence)primitive;
                    ASN1SequenceParser parser1 = sequence1.parser();
                    ASN1Encodable encodable1 = null;
                    while ((encodable1 = parser1.readObject()) != null) {
                        primitive = encodable1.toASN1Primitive();
                        if (!(primitive instanceof ASN1Sequence)) continue;
                        ASN1Sequence sequence2 = (ASN1Sequence)primitive;
                        ASN1SequenceParser parser2 = sequence2.parser();
                        ASN1Encodable encodable2 = null;
                        while ((encodable2 = parser2.readObject()) != null) {
                            primitive = encodable2.toASN1Primitive();
                            if (!(primitive instanceof ASN1UTCTime)) continue;
                            ASN1UTCTime obj5 = (ASN1UTCTime)primitive;
                            list.add(obj5.getAdjustedTime());
                        }
                    }
                }
            }
            String stringDate1 = ((String)list.get(0)).substring(0, 14);
            String stringDate2 = ((String)list.get(1)).substring(0, 14);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date1 = sdf.parse(stringDate1);
            Date date2 = sdf.parse(stringDate2);
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date time = new Date(System.currentTimeMillis());
            sdf.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
            String current = sdf.format(time);
            if (sdf.parse(current).getTime() <= sdf.parse(sdf.format(date1)).getTime() || sdf.parse(current).getTime() >= sdf.parse(sdf.format(date2)).getTime()) {
                return ret;
            }
            byte[] publicKey = cert.getPublicKeyData();
            SM3Param sm3Param = new SM3Param(publicKey);
            AlgPolicy signPolicy = new AlgPolicy("SM3WithSM2", sm3Param);
            BjcaKey bjcaKey = new BjcaKey("SM2_Public", publicKey);
            ret = serviceCode.equals("1") ? provider.verifySignHashedData(signPolicy, java.util.Base64.getDecoder().decode(reqDocHash), Util.SM2SignHardToSoft(signValue), bjcaKey) : provider.verifySignHashedData(signPolicy, java.util.Base64.getDecoder().decode(reqDocHash), java.util.Base64.getDecoder().decode(signValue), bjcaKey);
        }
        catch (PkiException e) {
            e.printStackTrace();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
        return ret;
    }

    @Override
    public boolean signVerify(String reqDoc, String signValue) {
        boolean ret = false;
        ArrayList<String> list = new ArrayList<String>();
        try {
            GaiaProvider provider = null;
            Gaia sec = Gaia.getInstance();
            sec.initProvider("BJCAJE");
            provider = sec.openProvider("BJCAJE");
            Pkcs7Util pkcs7Util = new Pkcs7Util(provider);
            byte[] sign = java.util.Base64.getDecoder().decode(signValue);
            byte[] value = new String(java.util.Base64.getDecoder().decode(reqDoc), "UTF-8").getBytes();
            ASN1InputStream ais = new ASN1InputStream(sign);
            ASN1Primitive primitive = null;
            while ((primitive = ais.readObject()) != null) {
                if (!(primitive instanceof ASN1Sequence)) continue;
                ASN1Sequence sequence = (ASN1Sequence)primitive;
                ASN1SequenceParser parser = sequence.parser();
                ASN1Encodable encodable = null;
                while ((encodable = parser.readObject()) != null) {
                    primitive = encodable.toASN1Primitive();
                    if (!(primitive instanceof ASN1TaggedObject)) continue;
                    ASN1TaggedObject obj1 = (ASN1TaggedObject)primitive;
                    ASN1Sequence sequence1 = (ASN1Sequence)obj1.getObjectParser(0, true);
                    ASN1SequenceParser parser1 = sequence1.parser();
                    ASN1Encodable encodable1 = null;
                    while ((encodable1 = parser1.readObject()) != null) {
                        primitive = encodable1.toASN1Primitive();
                        if (!(primitive instanceof ASN1TaggedObject)) continue;
                        ASN1TaggedObject obj2 = (ASN1TaggedObject)primitive;
                        ASN1Sequence sequence2 = (ASN1Sequence)obj2.getObjectParser(0, true);
                        ASN1SequenceParser parser2 = sequence2.parser();
                        ASN1Encodable encodable2 = null;
                        while ((encodable2 = parser2.readObject()) != null) {
                            primitive = encodable2.toASN1Primitive();
                            if (!(primitive instanceof ASN1Sequence)) continue;
                            ASN1Sequence sequence3 = (ASN1Sequence)primitive;
                            ASN1SequenceParser parser3 = sequence3.parser();
                            ASN1Encodable encodable3 = null;
                            while ((encodable3 = parser3.readObject()) != null) {
                                primitive = encodable3.toASN1Primitive();
                                if (!(primitive instanceof ASN1Sequence)) continue;
                                ASN1Sequence sequence4 = (ASN1Sequence)primitive;
                                ASN1SequenceParser parser4 = sequence4.parser();
                                ASN1Encodable encodable4 = null;
                                while ((encodable4 = parser4.readObject()) != null) {
                                    primitive = encodable4.toASN1Primitive();
                                    if (!(primitive instanceof ASN1UTCTime)) continue;
                                    ASN1UTCTime obj5 = (ASN1UTCTime)primitive;
                                    list.add(obj5.getAdjustedTime());
                                }
                            }
                        }
                    }
                }
            }
            String stringDate1 = ((String)list.get(0)).substring(0, 14);
            String stringDate2 = ((String)list.get(1)).substring(0, 14);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date1 = sdf.parse(stringDate1);
            Date date2 = sdf.parse(stringDate2);
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date time = new Date(System.currentTimeMillis());
            sdf.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
            String current = sdf.format(time);
            if (sdf.parse(current).getTime() <= sdf.parse(sdf.format(date1)).getTime() || sdf.parse(current).getTime() >= sdf.parse(sdf.format(date2)).getTime()) {
                return ret;
            }
            byte[] signVerify = pkcs7Util.verifyPkcs7Sign(sign, value);
            if (signVerify == null) {
                return ret;
            }
            ret = true;
        }
        catch (PkiException e) {
            e.printStackTrace();
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
        return ret;
    }

    @Override
    public boolean signVerifyP1(String serviceCode, String reqDoc, String signValue, String signCert) {
        boolean ret = false;
        ArrayList<String> list = new ArrayList<String>();
        try {
            Util util = new Util();
            GaiaProvider provider = null;
            Gaia sec = Gaia.getInstance();
            sec.initProvider("BJCAJE");
            provider = sec.openProvider("BJCAJE");
            BjcaCert cert = CertificateUtil.createCert(java.util.Base64.getDecoder().decode(signCert));
            ASN1InputStream ais = new ASN1InputStream(java.util.Base64.getDecoder().decode(signCert));
            ASN1Primitive primitive = null;
            while ((primitive = ais.readObject()) != null) {
                if (!(primitive instanceof ASN1Sequence)) continue;
                ASN1Sequence sequence = (ASN1Sequence)primitive;
                ASN1SequenceParser parser = sequence.parser();
                ASN1Encodable encodable = null;
                while ((encodable = parser.readObject()) != null) {
                    primitive = encodable.toASN1Primitive();
                    if (!(primitive instanceof ASN1Sequence)) continue;
                    ASN1Sequence sequence1 = (ASN1Sequence)primitive;
                    ASN1SequenceParser parser1 = sequence1.parser();
                    ASN1Encodable encodable1 = null;
                    while ((encodable1 = parser1.readObject()) != null) {
                        primitive = encodable1.toASN1Primitive();
                        if (!(primitive instanceof ASN1Sequence)) continue;
                        ASN1Sequence sequence2 = (ASN1Sequence)primitive;
                        ASN1SequenceParser parser2 = sequence2.parser();
                        ASN1Encodable encodable2 = null;
                        while ((encodable2 = parser2.readObject()) != null) {
                            primitive = encodable2.toASN1Primitive();
                            if (!(primitive instanceof ASN1UTCTime)) continue;
                            ASN1UTCTime obj5 = (ASN1UTCTime)primitive;
                            list.add(obj5.getAdjustedTime());
                        }
                    }
                }
            }
            String stringDate1 = ((String)list.get(0)).substring(0, 14);
            String stringDate2 = ((String)list.get(1)).substring(0, 14);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date1 = sdf.parse(stringDate1);
            Date date2 = sdf.parse(stringDate2);
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date time = new Date(System.currentTimeMillis());
            sdf.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
            String current = sdf.format(time);
            if (sdf.parse(current).getTime() <= sdf.parse(sdf.format(date1)).getTime() || sdf.parse(current).getTime() >= sdf.parse(sdf.format(date2)).getTime()) {
                return ret;
            }
            byte[] publicKey = cert.getPublicKeyData();
            byte[] ori = new String(java.util.Base64.getDecoder().decode(reqDoc), "UTF-8").getBytes();
            SM3Param sm3Param = new SM3Param(publicKey);
            AlgPolicy signPolicy = new AlgPolicy("SM3WithSM2", sm3Param);
            BjcaKey bjcaKey = new BjcaKey("SM2_Public", publicKey);
            ret = serviceCode.equals("1") ? provider.verifySignData(signPolicy, ori, Util.SM2SignHardToSoft(signValue), bjcaKey) : provider.verifySignData(signPolicy, ori, java.util.Base64.getDecoder().decode(signValue), bjcaKey);
        }
        catch (PkiException e) {
            e.printStackTrace();
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
        return ret;
    }

    @Override
    public String getSignTime(String signTime) {
        ArrayList<String> list = new ArrayList<String>();
        String cer = null;
        byte[] data = Base64.decode((String)signTime);
        ASN1InputStream ais = new ASN1InputStream(data);
        ASN1Primitive primitive = null;
        try {
            while ((primitive = ais.readObject()) != null) {
                if (!(primitive instanceof ASN1Sequence)) continue;
                ASN1Sequence sequence = (ASN1Sequence)primitive;
                ASN1SequenceParser parser = sequence.parser();
                ASN1Encodable encodable = null;
                while ((encodable = parser.readObject()) != null) {
                    primitive = encodable.toASN1Primitive();
                    if (!(primitive instanceof ASN1TaggedObject)) continue;
                    ASN1TaggedObject obj1 = (ASN1TaggedObject)primitive;
                    ASN1Sequence sequence1 = (ASN1Sequence)obj1.getObjectParser(0, true);
                    ASN1SequenceParser parser1 = sequence1.parser();
                    ASN1Encodable encodable1 = null;
                    while ((encodable1 = parser1.readObject()) != null) {
                        primitive = encodable1.toASN1Primitive();
                        if (!(primitive instanceof ASN1Set)) continue;
                        ASN1Set set2 = (ASN1Set)primitive;
                        ASN1Sequence sequence2 = (ASN1Sequence)set2.getObjectAt(0);
                        ASN1SequenceParser parser2 = sequence2.parser();
                        ASN1Encodable encodable2 = null;
                        while ((encodable2 = parser2.readObject()) != null) {
                            primitive = encodable2.toASN1Primitive();
                            if (!(primitive instanceof ASN1TaggedObject)) continue;
                            ASN1TaggedObject obj3 = (ASN1TaggedObject)primitive;
                            ASN1Sequence sequence3 = (ASN1Sequence)obj3.getObjectParser(0, true);
                            ASN1SequenceParser parser3 = sequence3.parser();
                            ASN1Encodable encodable3 = null;
                            while ((encodable3 = parser3.readObject()) != null) {
                                primitive = encodable3.toASN1Primitive();
                                if (!(primitive instanceof ASN1Set)) continue;
                                ASN1Set set4 = (ASN1Set)primitive;
                                ASN1Sequence sequence4 = (ASN1Sequence)set4.getObjectAt(0);
                                ASN1SequenceParser parser4 = sequence4.parser();
                                ASN1Encodable encodable4 = null;
                                while ((encodable4 = parser4.readObject()) != null) {
                                    primitive = encodable4.toASN1Primitive();
                                    if (!(primitive instanceof ASN1TaggedObject)) continue;
                                    ASN1TaggedObject obj5 = (ASN1TaggedObject)primitive;
                                    ASN1Sequence sequence5 = (ASN1Sequence)obj5.getObjectParser(0, true);
                                    ASN1SequenceParser parser5 = sequence5.parser();
                                    ASN1Encodable encodable5 = null;
                                    while ((encodable5 = parser5.readObject()) != null) {
                                        primitive = encodable5.toASN1Primitive();
                                        if (!(primitive instanceof ASN1Set)) continue;
                                        ASN1Set set6 = (ASN1Set)primitive;
                                        ASN1Sequence sequence6 = (ASN1Sequence)set6.getObjectAt(0);
                                        ASN1SequenceParser parser6 = sequence6.parser();
                                        ASN1Encodable encodable6 = null;
                                        while ((encodable6 = parser6.readObject()) != null) {
                                            primitive = encodable6.toASN1Primitive();
                                            if (!(primitive instanceof ASN1TaggedObject)) continue;
                                            ASN1TaggedObject obj7 = (ASN1TaggedObject)primitive;
                                            ASN1Sequence sequence7 = (ASN1Sequence)obj7.getObjectParser(0, true);
                                            ASN1SequenceParser parser7 = sequence7.parser();
                                            ASN1Encodable encodable7 = null;
                                            while ((encodable7 = parser7.readObject()) != null) {
                                                primitive = encodable7.toASN1Primitive();
                                                if (!(primitive instanceof ASN1Sequence)) continue;
                                                ASN1Sequence sequence8 = (ASN1Sequence)primitive;
                                                ASN1SequenceParser parser8 = sequence8.parser();
                                                ASN1Encodable encodable8 = null;
                                                while ((encodable8 = parser8.readObject()) != null) {
                                                    primitive = encodable8.toASN1Primitive();
                                                    list.add(primitive.toString());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            HashMap hm = new HashMap();
            for (int i = 0; i < list.size(); i += 2) {
                hm.put(list.get(i), list.get(i + 1));
            }
            String stringDate = cer = ((String)hm.get("1.2.840.113549.1.9.5")).substring(1, 12);
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            Date date = null;
            try {
                date = sdf.parse(stringDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            cer = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            cer = "\u89e3\u6790\u7b7e\u540d\u503c\u5931\u8d25!";
        }
        return cer;
    }

    @Override
    public String getCertDn(String cert) {
        byte[] ce = java.util.Base64.getDecoder().decode(cert);
        BjcaCert cer = null;
        try {
            cer = CertificateUtil.createCert(ce);
        }
        catch (PkiException e) {
            e.printStackTrace();
        }
        String subject = cer.getSubject();
        return subject;
    }

    @Override
    public boolean rsaSignVerifyP1(String reqDoc, String cert, String sign) {
        byte[] bytes = java.util.Base64.getDecoder().decode(cert);
        boolean verify = false;
        try {
            CertificateFactory instance = CertificateFactory.getInstance("X.509");
            Certificate certificate = instance.generateCertificate(new ByteArrayInputStream(bytes));
            PublicKey publicKey = certificate.getPublicKey();
            byte[] keyBytes = publicKey.getEncoded();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey key = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(key);
            signature.update(reqDoc.getBytes("utf-8"));
            verify = signature.verify(Base64.decode((byte[])sign.getBytes("utf-8")));
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return verify;
    }
}

