/*
 * Decompiled with CFR 0.152.
 */
package com.xjyb.config;

import com.xjyb.exception.ConfigException;
import com.xjyb.util.SecureCommonUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Properties;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;

public class PasswordServiceConfig {
    private static volatile PasswordServiceConfig INSTANCE = null;
    private int maxTotal;
    private int defaultMaxPerRoute;
    private int validateAfterInactivity;
    private int socketTimeout;
    private int connectTimeout;
    private int connectionRequestTimeout;
    private int maxIdleConnectionMs;
    private int monitorInterval;
    private String appid;
    private String preid;
    private String gateurl;
    private String certurl;
    private String algFlag;
    private String macFlag;
    private String algMode;
    private String certPreName;
    private String certPreKey;
    private String certSessionName;
    private String certSessionKey;
    private String certEncryptName;
    private String certEncryptKey;
    private String caAgency;

    private PasswordServiceConfig() {
        this.defaultMaxPerRoute = this.maxTotal = 800;
        this.validateAfterInactivity = 2000;
        this.socketTimeout = 60000;
        this.connectTimeout = 5000;
        this.connectionRequestTimeout = 500;
        this.maxIdleConnectionMs = 30000;
        this.monitorInterval = 10000;
        this.algFlag = "2";
        this.macFlag = "2";
        this.algMode = "2";
        this.caAgency = "3";
        this.initConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PasswordServiceConfig getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<PasswordServiceConfig> clazz = PasswordServiceConfig.class;
        synchronized (PasswordServiceConfig.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new PasswordServiceConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void initConfig() {
        Properties properties = new Properties();
        try (InputStream in = PasswordServiceConfig.class.getClassLoader().getResourceAsStream("config.properties");){
            if (in == null) {
                throw new ConfigException("0101001003001", "\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\uff0c\u8bf7\u786e\u5b9aconfig.properties\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u5b58\u5728\u3002");
            }
            properties.load(in);
            this.init(properties);
        }
        catch (Exception e) {
            throw new ConfigException("0101001003004", e.getMessage(), e);
        }
    }

    private void init(Properties properties) {
        String monitorInterval;
        String maxIdleConnectionMs;
        String connectionRequestTimeout;
        String connectTimeout;
        String socketTimeout;
        String validateAfterInactivity;
        String defaultMaxPerRoute;
        this.setAppid(properties);
        this.setPreid(properties);
        this.setGateurl(properties);
        this.setCerturl(properties);
        this.setCertPreName(properties);
        this.setCertPreKey(properties);
        this.setCertEncryptName(properties);
        this.setCertEncryptKey(properties);
        this.setCaAgency(properties);
        this.setAlgFlag(properties);
        this.setAlgMode(properties);
        this.setMacFlag(properties);
        String maxTotal = properties.getProperty("maxTotal");
        if (maxTotal != null && maxTotal.length() != 0) {
            this.setMaxTotal(Integer.parseInt(maxTotal));
        }
        if ((defaultMaxPerRoute = properties.getProperty("defaultMaxPerRoute")) != null && defaultMaxPerRoute.length() != 0) {
            this.setDefaultMaxPerRoute(Integer.parseInt(defaultMaxPerRoute));
        }
        if ((validateAfterInactivity = properties.getProperty("validateAfterInactivity")) != null && validateAfterInactivity.length() != 0) {
            this.setValidateAfterInactivity(Integer.parseInt(validateAfterInactivity));
        }
        if ((socketTimeout = properties.getProperty("socketTimeout")) != null && socketTimeout.length() != 0) {
            this.setSocketTimeout(Integer.parseInt(socketTimeout));
        }
        if ((connectTimeout = properties.getProperty("connectTimeout")) != null && connectTimeout.length() != 0) {
            this.setConnectTimeout(Integer.parseInt(connectTimeout));
        }
        if ((connectionRequestTimeout = properties.getProperty("connectionRequestTimeout")) != null && connectionRequestTimeout.length() != 0) {
            this.setConnectionRequestTimeout(Integer.parseInt(connectionRequestTimeout));
        }
        if ((maxIdleConnectionMs = properties.getProperty("maxIdleConnectionMs")) != null && maxIdleConnectionMs.length() != 0) {
            this.setMaxIdleConnectionMs(Integer.parseInt(maxIdleConnectionMs));
        }
        if ((monitorInterval = properties.getProperty("monitorInterval")) != null && monitorInterval.length() != 0) {
            this.setMonitorInterval(Integer.parseInt(monitorInterval));
        }
    }

    private static <T> void requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new ConfigException("0101001003002", message);
        }
    }

    private static void checkCaAgency(String caAgency) {
        if (!("1".equals(caAgency) || "2".equals(caAgency) || "3".equals(caAgency))) {
            throw new ConfigException("0101001003003", "\u4e0d\u5b58\u5728\u7684\u8bc1\u4e66\u673a\u6784\uff1a" + caAgency + "\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u6587\u4ef6\uff01");
        }
    }

    private static void checkAlgFlag(String algFlag) {
        if (!"1".equals(algFlag) && !"2".equals(algFlag)) {
            throw new ConfigException("0101001003003", "algFlag\u73b0\u5728\u652f\u6301\u7684\u7b97\u6cd5\u30101:3DES,2:SM4\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + algFlag);
        }
    }

    private static void checkAlgMode(String algMode) {
        if (!"1".equals(algMode) && !"2".equals(algMode)) {
            throw new ConfigException("0101001003003", "algMode\u73b0\u5728\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f\u30101:ECB,2:CBC\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + algMode);
        }
    }

    private static void checkMacFlag(String macFlag) {
        if (!("1".equals(macFlag) || "2".equals(macFlag) || "3".equals(macFlag))) {
            throw new ConfigException("0101001003003", "macFlag\u73b0\u5728\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f\u30101:ANSI9.9,2:ANSI9.19,3:PBOC3.0\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + macFlag);
        }
    }

    private void setAppid(Properties properties) {
        String appid = System.getProperty("appid");
        if (appid == null || appid.isEmpty()) {
            appid = properties.getProperty("appid");
        }
        PasswordServiceConfig.requireNonNull(appid, "appid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        appid = new String(Base64.getDecoder().decode(appid), StandardCharsets.UTF_8);
        if (appid.length() != 32) {
            throw new ConfigException("0101001003003", "appid\u6570\u636e\u683c\u5f0f\u5f02\u5e38\uff01\u89e3\u6790\u540e\u7684appid\u3010 " + appid + "\u3011\u957f\u5ea6\u4e0d\u7b49\u4e8e32");
        }
        if (!appid.matches("^[0-9a-fA-F]{32}$")) {
            throw new ConfigException("0101001003003", "appid\u6570\u636e\u683c\u5f0f\u5f02\u5e38\uff01\u89e3\u6790\u540e\u7684appid\u3010 " + appid + "\u3011\u4e0d\u662f16\u8fdb\u5236\u5b57\u7b26\u4e32");
        }
        this.appid = appid;
    }

    private void setPreid(Properties properties) {
        String preid = System.getProperty("preid");
        if (preid == null || preid.isEmpty()) {
            preid = properties.getProperty("preid");
        }
        PasswordServiceConfig.requireNonNull(preid, "preid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        preid = new String(Base64.getDecoder().decode(preid), StandardCharsets.UTF_8);
        if (preid.length() != 32) {
            throw new ConfigException("0101001003003", "preid\u6570\u636e\u683c\u5f0f\u5f02\u5e38\uff01\u89e3\u6790\u540e\u7684preid\u3010 " + preid + "\u3011\u957f\u5ea6\u4e0d\u7b49\u4e8e32");
        }
        if (!preid.matches("^[0-9a-fA-F]{32}$")) {
            throw new ConfigException("0101001003003", "preid\u6570\u636e\u683c\u5f0f\u5f02\u5e38\uff01\u89e3\u6790\u540e\u7684preid\u3010 " + preid + "\u3011\u4e0d\u662f16\u8fdb\u5236\u5b57\u7b26\u4e32");
        }
        this.preid = preid;
    }

    private void setGateurl(Properties properties) {
        String gateurl = System.getProperty("gateurl");
        if (gateurl == null || gateurl.isEmpty()) {
            gateurl = properties.getProperty("gateurl");
        }
        PasswordServiceConfig.requireNonNull(gateurl, "gateurl\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!gateurl.endsWith("/")) {
            gateurl = gateurl + "/";
        }
        this.gateurl = gateurl;
    }

    private void setCerturl(Properties properties) {
        String certurl = System.getProperty("certurl");
        if (certurl == null || certurl.isEmpty()) {
            certurl = properties.getProperty("certurl");
        }
        PasswordServiceConfig.requireNonNull(certurl, "certurl\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (!certurl.endsWith(File.separator)) {
            certurl = certurl + File.separator;
        }
        this.certurl = certurl;
    }

    private void setCaAgency(Properties properties) {
        String caAgency = properties.getProperty("caAgency");
        if (caAgency == null || caAgency.length() == 0) {
            caAgency = "3";
        }
        PasswordServiceConfig.checkCaAgency(caAgency);
        this.caAgency = caAgency;
    }

    private void setAlgFlag(Properties properties) {
        String algFlag = properties.getProperty("algFlag");
        if (algFlag == null || "".equals(algFlag)) {
            algFlag = "2";
        }
        PasswordServiceConfig.checkAlgFlag(algFlag);
        this.algFlag = algFlag;
    }

    private void setMacFlag(Properties properties) {
        String macFlag = properties.getProperty("macFlag");
        if (macFlag == null || "".equals(macFlag)) {
            macFlag = "2";
        }
        PasswordServiceConfig.checkMacFlag(macFlag);
        this.macFlag = macFlag;
    }

    private void setAlgMode(Properties properties) {
        String algMode = properties.getProperty("algMode");
        if (algMode == null || "".equals(algMode)) {
            algMode = "2";
        }
        PasswordServiceConfig.checkAlgMode(algMode);
        this.algMode = algMode;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getPreid() {
        return this.preid;
    }

    public String getGateurl() {
        return this.gateurl;
    }

    public String getCerturl() {
        return this.certurl;
    }

    private void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    private void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    private void setValidateAfterInactivity(int validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
    }

    private void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    private void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    private void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    private void setMaxIdleConnectionMs(int maxIdleConnectionMs) {
        this.maxIdleConnectionMs = maxIdleConnectionMs;
    }

    private void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public String getCaAgency() {
        return this.caAgency;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public int getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getMaxIdleConnectionMs() {
        return this.maxIdleConnectionMs;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public String getAlgFlag() {
        return this.algFlag;
    }

    public String getMacFlag() {
        return this.macFlag;
    }

    public String getAlgMode() {
        return this.algMode;
    }

    private void setCertPreName(Properties properties) {
        String certPreName = System.getProperty("certPreName");
        if (certPreName == null || certPreName.isEmpty()) {
            certPreName = properties.getProperty("certPreName");
        }
        PasswordServiceConfig.requireNonNull(certPreName, "\u8eab\u4efd\u8bc1\u4e66\u3010certPreName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.certPreName = certPreName;
    }

    private void setCertPreKey(Properties properties) {
        try {
            String certPreKey;
            String certPreKeyPlain = System.getProperty("certPreKey");
            if (certPreKeyPlain == null || certPreKeyPlain.isEmpty()) {
                certPreKeyPlain = properties.getProperty("certPreKey", "");
            }
            this.certPreKey = certPreKey = SecureCommonUtil.decCertKey(certPreKeyPlain);
        }
        catch (AlgorithmNotFoundException e) {
            throw new ConfigException("0101001003003", "certPreKey\u89e3\u5bc6\u5f02\u5e38");
        }
    }

    private void setCertEncryptName(Properties properties) {
        String certEncryptName = System.getProperty("certEncryptName");
        if (certEncryptName == null || certEncryptName.isEmpty()) {
            certEncryptName = properties.getProperty("certEncryptName");
        }
        PasswordServiceConfig.requireNonNull(certEncryptName, "\u524d\u7f6e\u5bc6\u94a5\u52a0\u5bc6\u8bc1\u4e66\u3010certEncryptName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.certEncryptName = certEncryptName;
    }

    public void setCertEncryptKey(Properties properties) {
        try {
            String certEncryptKey;
            String certEncryptKeyPlain = System.getProperty("certEncryptKey");
            if (certEncryptKeyPlain == null || certEncryptKeyPlain.isEmpty()) {
                certEncryptKeyPlain = properties.getProperty("certEncryptKey", "");
            }
            this.certEncryptKey = certEncryptKey = SecureCommonUtil.decCertKey(certEncryptKeyPlain);
        }
        catch (AlgorithmNotFoundException e) {
            throw new ConfigException("0101001003003", "certEncryptKey\u89e3\u5bc6\u5f02\u5e38");
        }
    }

    public String getCertPreName() {
        return this.certPreName;
    }

    public String getCertPreKey() {
        return this.certPreKey;
    }

    public String getCertSessionName() {
        return this.certSessionName;
    }

    public String getCertSessionKey() {
        return this.certSessionKey;
    }

    public String getCertEncryptName() {
        return this.certEncryptName;
    }

    public String getCertEncryptKey() {
        return this.certEncryptKey;
    }

    public static void main(String[] args) {
        PasswordServiceConfig.checkMacFlag("1");
        PasswordServiceConfig.checkMacFlag("2");
        PasswordServiceConfig.checkMacFlag("3");
        PasswordServiceConfig.checkMacFlag("4");
    }
}

